/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.playlist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.SharedFlow;
import mu.KLogger;
import mu.KotlinLogging;
import net.transgressoft.commons.entity.IdentifiableEntity;
import net.transgressoft.commons.entity.ReactiveEntityBase;
import net.transgressoft.commons.entity.TransEntity;
import net.transgressoft.commons.event.CrudEvent;
import net.transgressoft.commons.event.EventType;
import net.transgressoft.commons.event.StandardCrudEvent;
import net.transgressoft.commons.event.TransEvent;
import net.transgressoft.commons.event.TransEventSubscriber;
import net.transgressoft.commons.event.TransEventSubscription;
import net.transgressoft.commons.music.audio.ReactiveAudioItem;
import net.transgressoft.commons.music.audio.event.AudioItemEventSubscriber;
import net.transgressoft.commons.music.playlist.PlaylistHierarchy;
import net.transgressoft.commons.music.playlist.ReactiveAudioPlaylist;
import net.transgressoft.commons.persistence.Repository;
import net.transgressoft.commons.persistence.VolatileRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.google.common.collect.MultimapBuilder;
import org.jetbrains.kotlin.com.google.common.collect.SortedSetMultimap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00030\u0006:\u0001uB\u001d\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0007H\u0004J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0016J\u0015\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010*H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010,2\u0006\u0010-\u001a\u00020\u0011H\u0016J\"\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010,2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0018\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0016J\u001e\u00102\u001a\u00020\u001c2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000*2\u0006\u00104\u001a\u00020\u0011H\u0016J\u001e\u00105\u001a\u00020\u001c2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000*2\u0006\u00104\u001a\u00020\u0011H\u0016J#\u00105\u001a\u00020\u001c2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00070*2\u0006\u00104\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\b7J\u001e\u00108\u001a\u00020\u001c2\f\u00109\u001a\b\u0012\u0004\u0012\u00028\u00010$2\u0006\u0010:\u001a\u00020\u0011H\u0016J#\u00108\u001a\u00020\u001c2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00110$2\u0006\u0010:\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\b<J\u001e\u0010=\u001a\u00020\u001c2\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00010$2\u0006\u0010:\u001a\u00020\u0011H\u0016J#\u0010=\u001a\u00020\u001c2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00110$2\u0006\u0010:\u001a\u00020\u0011H\u0017\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020\u0007H\u0016J\b\u0010B\u001a\u00020\u0007H\u0016J\u001e\u0010C\u001a\u00020'2\u0006\u0010D\u001a\u00020\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010*H\u0004J\u001d\u0010E\u001a\u00020'2\u0006\u0010D\u001a\u00020\u00112\u0006\u0010 \u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010FJ\"\u0010G\u001a\u00020'2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170I\"\u00020\u0017H\u0096\u0001\u00a2\u0006\u0002\u0010JJ\t\u0010K\u001a\u00020'H\u0096\u0001J\u0011\u0010L\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020\u0007H\u0096\u0001J\u0017\u0010L\u001a\u00020\u001c2\f\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010OH\u0096\u0001J\"\u0010P\u001a\u00020'2\u0012\u0010H\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170I\"\u00020\u0017H\u0096\u0001\u00a2\u0006\u0002\u0010JJ\u001d\u0010Q\u001a\u00020'2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0018H\u0096\u0001J\u0017\u0010S\u001a\b\u0012\u0004\u0012\u00028\u00010,2\u0006\u0010M\u001a\u00020\u0007H\u0096\u0001J\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00028\u00010,2\u0006\u0010U\u001a\u00020\u0011H\u0096\u0001J\u001d\u0010V\u001a\b\u0012\u0004\u0012\u00028\u00010,2\f\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010OH\u0096\u0001J\u0017\u0010W\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010*H\u0096\u0003J\u0016\u0010W\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0001H\u0096\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010X\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010$H\u0096\u0003J\u0016\u0010X\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0001H\u0096\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010Y\u001a\u00020\u001c2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u00010[H\u0096\u0001J%\u0010\\\u001a\u00020\u001c2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00070$2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u00010[H\u0096\u0001J\u001f\u0010^\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020\u00072\f\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u00010[H\u0096\u0001J%\u0010_\u001a\u00020\u001c2\f\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010O2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00028\u00010[H\u0096\u0001J\u001d\u0010`\u001a\b\u0012\u0004\u0012\u00028\u00010$2\f\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010OH\u0096\u0001J%\u0010`\u001a\b\u0012\u0004\u0012\u00028\u00010$2\u0006\u0010a\u001a\u00020\u00072\f\u0010N\u001a\b\u0012\u0004\u0012\u00028\u00010OH\u0096\u0001J\t\u0010a\u001a\u00020\u0007H\u0096\u0001JE\u0010b\u001a\"\u0012\u0006\b\u0000\u0012\u00020d\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u00180c2\u001a\u0010e\u001a\u0016\u0012\u0012\b\u0000\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u00180[H\u0096\u0001J^\u0010b\u001a\"\u0012\u0006\b\u0000\u0012\u00020d\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u00180c2.\u0010e\u001a*\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0g\u0012\u0006\u0012\u0004\u0018\u00010h0fH\u0096\u0001\u00a2\u0006\u0002\u0010iJr\u0010b\u001a\"\u0012\u0006\b\u0000\u0012\u00020d\u0012\u0004\u0012\u00020\u0017\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u00180c2\u0012\u0010j\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170I\"\u00020\u00172.\u0010e\u001a*\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0g\u0012\u0006\u0012\u0004\u0018\u00010h0fH\u0096\u0001\u00a2\u0006\u0002\u0010kJi\u0010b\u001a\u00020'2^\u0010l\u001aZ\u0012&\b\u0000\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0001 n*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00180\u0018 n*,\u0012&\b\u0000\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0001 n*\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00180\u0018\u0018\u00010m0mH\u0096\u0001R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0015\u001a\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0017\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\b\u0001\u0012\u00028\u00000\u00180\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010o\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00010\u00180pX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bq\u0010rR\u0012\u0010s\u001a\u00020\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bs\u0010t\u00a8\u0006v"}, d2={"Lnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase;", "I", "Lnet/transgressoft/commons/music/audio/ReactiveAudioItem;", "P", "Lnet/transgressoft/commons/music/playlist/ReactiveAudioPlaylist;", "Lnet/transgressoft/commons/music/playlist/PlaylistHierarchy;", "Lnet/transgressoft/commons/persistence/Repository;", "", "repository", "<init>", "(Lnet/transgressoft/commons/persistence/Repository;)V", "getRepository", "()Lnet/transgressoft/commons/persistence/Repository;", "logger", "Lmu/KLogger;", "playlistsHierarchyMultiMap", "Lorg/jetbrains/kotlin/com/google/common/collect/Multimap;", "", "idCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "newId", "audioItemEventSubscriber", "Lnet/transgressoft/commons/event/TransEventSubscriber;", "Lnet/transgressoft/commons/event/CrudEvent$Type;", "Lnet/transgressoft/commons/event/CrudEvent;", "getAudioItemEventSubscriber", "()Lnet/transgressoft/commons/event/TransEventSubscriber;", "add", "", "entity", "(Lnet/transgressoft/commons/music/playlist/ReactiveAudioPlaylist;)Z", "addInternal", "playlist", "addOrReplace", "addOrReplaceAll", "entities", "", "remove", "removeFromPlaylistsHierarchy", "", "(Lnet/transgressoft/commons/music/playlist/ReactiveAudioPlaylist;)V", "removeAll", "", "findByName", "Ljava/util/Optional;", "name", "findParentPlaylist", "movePlaylist", "playlistNameToMove", "destinationPlaylistName", "addAudioItemsToPlaylist", "audioItems", "playlistName", "removeAudioItemsFromPlaylist", "audioItemIds", "removeAudioItemIdsFromPlaylist", "addPlaylistsToDirectory", "playlistsToAdd", "directoryName", "playlistNamesToAdd", "addPlaylistNamesToDirectory", "removePlaylistsFromDirectory", "playlistsToRemove", "playlistsNamesToRemove", "removePlaylistNamesFromDirectory", "numberOfPlaylists", "numberOfPlaylistDirectories", "putAllPlaylistInHierarchy", "parentPlaylistUniqueId", "removePlaylistFromHierarchy", "(Ljava/lang/String;Lnet/transgressoft/commons/music/playlist/ReactiveAudioPlaylist;)V", "activateEvents", "types", "", "([Lnet/transgressoft/commons/event/CrudEvent$Type;)V", "clear", "contains", "id", "predicate", "Ljava/util/function/Predicate;", "disableEvents", "emitAsync", "event", "findById", "findByUniqueId", "uniqueId", "findFirst", "minus", "plus", "runForAll", "entityAction", "Ljava/util/function/Consumer;", "runForMany", "ids", "runForSingle", "runMatching", "search", "size", "subscribe", "Lnet/transgressoft/commons/event/TransEventSubscription;", "Lnet/transgressoft/commons/entity/TransEntity;", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;)Lnet/transgressoft/commons/event/TransEventSubscription;", "eventTypes", "([Lnet/transgressoft/commons/event/CrudEvent$Type;Lkotlin/jvm/functions/Function2;)Lnet/transgressoft/commons/event/TransEventSubscription;", "p0", "Ljava/util/concurrent/Flow$Subscriber;", "kotlin.jvm.PlatformType", "changes", "Lkotlinx/coroutines/flow/SharedFlow;", "getChanges", "()Lkotlinx/coroutines/flow/SharedFlow;", "isEmpty", "()Z", "MutablePlaylistBase", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nPlaylistHierarchyBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaylistHierarchyBase.kt\nnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,437:1\n1869#2,2:438\n1869#2,2:441\n1869#2,2:443\n1#3:440\n*S KotlinDebug\n*F\n+ 1 PlaylistHierarchyBase.kt\nnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase\n*L\n144#1:438,2\n232#1:441,2\n249#1:443,2\n*E\n"})
public abstract class PlaylistHierarchyBase<I extends ReactiveAudioItem<I>, P extends ReactiveAudioPlaylist<I, P>>
implements PlaylistHierarchy<I, P>,
Repository<Integer, P> {
    @NotNull
    private final Repository<Integer, P> repository;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Multimap<String, P> playlistsHierarchyMultiMap;
    @NotNull
    private final AtomicInteger idCounter;
    @NotNull
    private final TransEventSubscriber<I, CrudEvent.Type, CrudEvent<Integer, ? extends I>> audioItemEventSubscriber;

    /*
     * WARNING - void declaration
     */
    public PlaylistHierarchyBase(@NotNull Repository<Integer, ? super P> repository) {
        void $this$audioItemEventSubscriber_u24lambda_u240;
        Intrinsics.checkNotNullParameter(repository, (String)"repository");
        this.repository = repository;
        Object object = new CrudEvent.Type[]{CrudEvent.Type.CREATE, CrudEvent.Type.UPDATE, CrudEvent.Type.DELETE};
        this.repository.disableEvents((EventType[])object);
        object = new CrudEvent.Type[]{CrudEvent.Type.CREATE, CrudEvent.Type.UPDATE, CrudEvent.Type.DELETE};
        this.activateEvents((CrudEvent.Type)object);
        this.logger = KotlinLogging.INSTANCE.logger(PlaylistHierarchyBase::logger$lambda$0);
        SortedSetMultimap sortedSetMultimap = MultimapBuilder.treeKeys().treeSetValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)sortedSetMultimap, (String)"build(...)");
        this.playlistsHierarchyMultiMap = (Multimap)sortedSetMultimap;
        this.idCounter = new AtomicInteger(1);
        Object object2 = object = new AudioItemEventSubscriber(this.toString());
        PlaylistHierarchyBase playlistHierarchyBase = this;
        boolean bl = false;
        EventType[] eventTypeArray = new EventType[]{CrudEvent.Type.DELETE};
        $this$audioItemEventSubscriber_u24lambda_u240.addOnNextEventAction(eventTypeArray, arg_0 -> PlaylistHierarchyBase.audioItemEventSubscriber$lambda$0$0(this, arg_0));
        playlistHierarchyBase.audioItemEventSubscriber = (TransEventSubscriber)object;
    }

    public /* synthetic */ PlaylistHierarchyBase(Repository repository, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            repository = (Repository)new VolatileRepository("PlaylistHierarchy", null, 2, null);
        }
        this(repository);
    }

    @NotNull
    protected final Repository<Integer, P> getRepository() {
        return this.repository;
    }

    protected final int newId() {
        int id = 0;
        while (this.contains(id = this.idCounter.getAndIncrement())) {
        }
        return id;
    }

    @NotNull
    public TransEventSubscriber<I, CrudEvent.Type, CrudEvent<Integer, ? extends I>> getAudioItemEventSubscriber() {
        return this.audioItemEventSubscriber;
    }

    public boolean add(@NotNull P entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return this.addInternal(entity);
    }

    private final boolean addInternal(P playlist) {
        boolean added = this.repository.add((IdentifiableEntity)playlist);
        for (ReactiveAudioPlaylist p : playlist.getPlaylists()) {
            this.playlistsHierarchyMultiMap.put((Object)playlist.getUniqueId(), (Object)p);
            added |= this.addInternal(p);
        }
        return added;
    }

    public boolean addOrReplace(@NotNull P entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return this.addOrReplaceAll(SetsKt.setOf(entity));
    }

    public boolean addOrReplaceAll(@NotNull Set<? extends P> entities) {
        Map<Boolean, List<Object>> addedAndReplaced;
        block3: {
            List<Object> it;
            Intrinsics.checkNotNullParameter(entities, (String)"entities");
            List entitiesBeforeUpdate = new ArrayList();
            addedAndReplaced = entities.stream().filter(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$1(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$0(this, arg_0), arg_0)).collect(Collectors.partitioningBy(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$3(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$2(this, entitiesBeforeUpdate, arg_0), arg_0)));
            List<Object> list = addedAndReplaced.get(true);
            if (list != null) {
                it = list;
                boolean bl = false;
                if (!((Collection)it).isEmpty()) {
                    this.repository.emitAsync((TransEvent)new StandardCrudEvent.Create((Collection)it));
                    this.logger.debug(() -> PlaylistHierarchyBase.addOrReplaceAll$lambda$4$0(it));
                }
            }
            List<Object> list2 = addedAndReplaced.get(false);
            if (list2 == null) break block3;
            it = list2;
            boolean bl = false;
            if (!((Collection)it).isEmpty()) {
                this.repository.emitAsync((TransEvent)new StandardCrudEvent.Update((Collection)it, (Collection)entitiesBeforeUpdate));
                this.logger.debug(() -> PlaylistHierarchyBase.addOrReplaceAll$lambda$5$0(it));
            }
        }
        return addedAndReplaced.values().stream().flatMap(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$7(PlaylistHierarchyBase::addOrReplaceAll$lambda$6, arg_0)).findAny().isPresent();
    }

    public boolean remove(@NotNull P entity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        boolean removed = bl = this.repository.remove((IdentifiableEntity)entity);
        boolean bl2 = false;
        if (removed) {
            this.removeFromPlaylistsHierarchy(entity);
        }
        return bl;
    }

    private final void removeFromPlaylistsHierarchy(P playlist) {
        this.playlistsHierarchyMultiMap.removeAll((Object)playlist.getUniqueId());
        this.findParentPlaylist((ReactiveAudioPlaylist<I, P>)playlist).ifPresent(arg_0 -> PlaylistHierarchyBase.removeFromPlaylistsHierarchy$lambda$1(arg_0 -> PlaylistHierarchyBase.removeFromPlaylistsHierarchy$lambda$0(playlist, this, arg_0), arg_0));
        this.removeAll(playlist.getPlaylists());
    }

    public boolean removeAll(@NotNull Collection<? extends P> entities) {
        boolean bl;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        boolean removed = bl = this.repository.removeAll(entities);
        boolean bl2 = false;
        if (removed) {
            Iterable $this$forEach$iv = entities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReactiveAudioPlaylist p0 = (ReactiveAudioPlaylist)element$iv;
                boolean bl3 = false;
                this.removeFromPlaylistsHierarchy(p0);
            }
        }
        return bl;
    }

    @NotNull
    public Optional<P> findByName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.findFirst(arg_0 -> PlaylistHierarchyBase.findByName$lambda$0(name2, arg_0));
    }

    @NotNull
    public Optional<P> findParentPlaylist(@NotNull ReactiveAudioPlaylist<I, P> playlist) {
        Optional<Object> optional;
        Intrinsics.checkNotNullParameter(playlist, (String)"playlist");
        if (this.playlistsHierarchyMultiMap.containsValue(playlist)) {
            Optional<ReactiveAudioPlaylist> optional2 = this.playlistsHierarchyMultiMap.entries().stream().filter(arg_0 -> PlaylistHierarchyBase.findParentPlaylist$lambda$1(arg_0 -> PlaylistHierarchyBase.findParentPlaylist$lambda$0(playlist, arg_0), arg_0)).map(arg_0 -> PlaylistHierarchyBase.findParentPlaylist$lambda$3(arg_0 -> PlaylistHierarchyBase.findParentPlaylist$lambda$2(this, arg_0), arg_0)).findFirst();
            Intrinsics.checkNotNull(optional2);
            optional = optional2;
        } else {
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNull(optional3);
            optional = optional3;
        }
        return optional;
    }

    public void movePlaylist(@NotNull String playlistNameToMove, @NotNull String destinationPlaylistName) {
        Intrinsics.checkNotNullParameter((Object)playlistNameToMove, (String)"playlistNameToMove");
        Intrinsics.checkNotNullParameter((Object)destinationPlaylistName, (String)"destinationPlaylistName");
        Optional<P> playlistToMove = this.findByName(playlistNameToMove);
        Optional<P> destinationPlaylist = this.findByName(destinationPlaylistName);
        if (!playlistToMove.isPresent()) {
            boolean $i$a$-require-PlaylistHierarchyBase$movePlaylist$32 = false;
            String $i$a$-require-PlaylistHierarchyBase$movePlaylist$32 = "Playlist '" + playlistNameToMove + "' does not exist";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$movePlaylist$32.toString());
        }
        if (!destinationPlaylist.isPresent()) {
            boolean bl = false;
            String string = "Playlist '" + destinationPlaylistName + "' does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        P p = playlistToMove.get();
        Intrinsics.checkNotNullExpressionValue(p, (String)"get(...)");
        this.findParentPlaylist((ReactiveAudioPlaylist)p).ifPresent(arg_0 -> PlaylistHierarchyBase.movePlaylist$lambda$3(arg_0 -> PlaylistHierarchyBase.movePlaylist$lambda$2(playlistToMove, this, playlistNameToMove, arg_0), arg_0));
        ReactiveAudioPlaylist reactiveAudioPlaylist = (ReactiveAudioPlaylist)destinationPlaylist.get();
        P p2 = playlistToMove.get();
        Intrinsics.checkNotNullExpressionValue(p2, (String)"get(...)");
        reactiveAudioPlaylist.addPlaylist((ReactiveAudioPlaylist)p2);
        this.logger.debug(() -> PlaylistHierarchyBase.movePlaylist$lambda$4(playlistNameToMove, destinationPlaylistName));
    }

    public boolean addAudioItemsToPlaylist(@NotNull Collection<? extends I> audioItems, @NotNull String playlistName) {
        Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
        Intrinsics.checkNotNullParameter((Object)playlistName, (String)"playlistName");
        Optional<P> it = this.findByName(playlistName);
        boolean bl = false;
        if (!it.isPresent()) {
            boolean bl2 = false;
            String string = "Playlist '" + playlistName + "' does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        return ((ReactiveAudioPlaylist)it.get()).addAudioItems(audioItems);
    }

    public boolean removeAudioItemsFromPlaylist(@NotNull Collection<? extends I> audioItems, @NotNull String playlistName) {
        Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
        Intrinsics.checkNotNullParameter((Object)playlistName, (String)"playlistName");
        Optional<P> it = this.findByName(playlistName);
        boolean bl = false;
        if (!it.isPresent()) {
            boolean bl2 = false;
            String string = "Playlist '" + playlistName + "' does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        return ((ReactiveAudioPlaylist)it.get()).removeAudioItems(audioItems);
    }

    @JvmName(name="removeAudioItemIdsFromPlaylist")
    public boolean removeAudioItemIdsFromPlaylist(@NotNull Collection<Integer> audioItemIds, @NotNull String playlistName) {
        Intrinsics.checkNotNullParameter(audioItemIds, (String)"audioItemIds");
        Intrinsics.checkNotNullParameter((Object)playlistName, (String)"playlistName");
        Optional<P> it = this.findByName(playlistName);
        boolean bl = false;
        if (!it.isPresent()) {
            boolean bl2 = false;
            String string = "Playlist '" + playlistName + "' does not exist";
            throw new IllegalArgumentException(string.toString());
        }
        return ((ReactiveAudioPlaylist)it.get()).removeAudioItemIds(audioItemIds);
    }

    public boolean addPlaylistsToDirectory(@NotNull Set<? extends P> playlistsToAdd, @NotNull String directoryName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(playlistsToAdd, (String)"playlistsToAdd");
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        Optional<P> it = this.findByName(directoryName);
        boolean bl2 = false;
        if (!it.isPresent()) {
            boolean $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$1$32 = false;
            String $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$1$32 = "Directory '" + directoryName + "' does not exist";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$1$32.toString());
        }
        if (!((ReactiveAudioPlaylist)it.get()).isDirectory()) {
            boolean $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$1$42 = false;
            String $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$1$42 = "Playlist '" + directoryName + "' is not a directory";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$1$42.toString());
        }
        boolean added = bl = ((ReactiveAudioPlaylist)it.get()).addPlaylists((Collection)playlistsToAdd);
        boolean bl3 = false;
        if (added) {
            this.playlistsHierarchyMultiMap.putAll((Object)((ReactiveAudioPlaylist)it.get()).getUniqueId(), (Iterable)playlistsToAdd);
        }
        return bl;
    }

    @JvmName(name="addPlaylistNamesToDirectory")
    public boolean addPlaylistNamesToDirectory(@NotNull Set<String> playlistNamesToAdd, @NotNull String directoryName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(playlistNamesToAdd, (String)"playlistNamesToAdd");
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        Optional<P> it = this.findByName(directoryName);
        boolean bl2 = false;
        if (!it.isPresent()) {
            boolean $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$2$32 = false;
            String $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$2$32 = "Directory '" + directoryName + "' does not exist";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$2$32.toString());
        }
        if (!((ReactiveAudioPlaylist)it.get()).isDirectory()) {
            boolean $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$2$42 = false;
            String $i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$2$42 = "Playlist '" + directoryName + "' is not a directory";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$addPlaylistsToDirectory$2$42.toString());
        }
        List<ReactiveAudioPlaylist> playlistsToAdd = playlistNamesToAdd.stream().map(arg_0 -> PlaylistHierarchyBase.addPlaylistsToDirectory$lambda$1$3(arg_0 -> PlaylistHierarchyBase.addPlaylistsToDirectory$lambda$1$2(this, arg_0), arg_0)).toList();
        boolean bl3 = false;
        ReactiveAudioPlaylist reactiveAudioPlaylist = (ReactiveAudioPlaylist)it.get();
        Intrinsics.checkNotNull(playlistsToAdd);
        boolean added = bl = reactiveAudioPlaylist.addPlaylists((Collection)playlistsToAdd);
        boolean bl4 = false;
        if (added) {
            this.playlistsHierarchyMultiMap.putAll((Object)((ReactiveAudioPlaylist)it.get()).getUniqueId(), (Iterable)playlistsToAdd);
        }
        return bl;
    }

    public boolean removePlaylistsFromDirectory(@NotNull Set<? extends P> playlistsToRemove, @NotNull String directoryName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(playlistsToRemove, (String)"playlistsToRemove");
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        Optional<P> it = this.findByName(directoryName);
        boolean bl2 = false;
        if (!it.isPresent()) {
            boolean $i$a$-require-PlaylistHierarchyBase$removePlaylistsFromDirectory$1$22 = false;
            String $i$a$-require-PlaylistHierarchyBase$removePlaylistsFromDirectory$1$22 = "Directory '" + directoryName + "' does not exist";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$removePlaylistsFromDirectory$1$22.toString());
        }
        boolean removed = bl = ((ReactiveAudioPlaylist)it.get()).removePlaylists((Collection)playlistsToRemove);
        boolean bl3 = false;
        if (removed) {
            this.removeAll((Collection)playlistsToRemove);
            Iterable $this$forEach$iv = playlistsToRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReactiveAudioPlaylist playlist = (ReactiveAudioPlaylist)element$iv;
                boolean bl4 = false;
                this.playlistsHierarchyMultiMap.remove((Object)((ReactiveAudioPlaylist)it.get()).getUniqueId(), (Object)playlist);
            }
        }
        return bl;
    }

    @JvmName(name="removePlaylistNamesFromDirectory")
    public boolean removePlaylistNamesFromDirectory(@NotNull Set<String> playlistsNamesToRemove, @NotNull String directoryName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(playlistsNamesToRemove, (String)"playlistsNamesToRemove");
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        Optional<P> it = this.findByName(directoryName);
        boolean bl2 = false;
        if (!it.isPresent()) {
            boolean $i$a$-require-PlaylistHierarchyBase$removePlaylistsFromDirectory$2$22 = false;
            String $i$a$-require-PlaylistHierarchyBase$removePlaylistsFromDirectory$2$22 = "Directory '" + directoryName + "' does not exist";
            throw new IllegalArgumentException($i$a$-require-PlaylistHierarchyBase$removePlaylistsFromDirectory$2$22.toString());
        }
        List<ReactiveAudioPlaylist> playlistsToRemove = playlistsNamesToRemove.stream().map(arg_0 -> PlaylistHierarchyBase.removePlaylistsFromDirectory$lambda$1$2(arg_0 -> PlaylistHierarchyBase.removePlaylistsFromDirectory$lambda$1$1(this, arg_0), arg_0)).toList();
        boolean bl3 = false;
        ReactiveAudioPlaylist reactiveAudioPlaylist = (ReactiveAudioPlaylist)it.get();
        Intrinsics.checkNotNull(playlistsToRemove);
        boolean removed = bl = reactiveAudioPlaylist.removePlaylists((Collection)playlistsToRemove);
        boolean bl4 = false;
        if (removed) {
            this.removeAll(CollectionsKt.toSet((Iterable)playlistsToRemove));
            Iterable $this$forEach$iv = playlistsToRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReactiveAudioPlaylist playlist = (ReactiveAudioPlaylist)element$iv;
                boolean bl5 = false;
                this.playlistsHierarchyMultiMap.remove((Object)((ReactiveAudioPlaylist)it.get()).getUniqueId(), (Object)playlist);
            }
        }
        return bl;
    }

    public int numberOfPlaylists() {
        return ((Collection)this.repository.search(PlaylistHierarchyBase::numberOfPlaylists$lambda$0)).size();
    }

    public int numberOfPlaylistDirectories() {
        return ((Collection)this.repository.search(PlaylistHierarchyBase::numberOfPlaylistDirectories$lambda$0)).size();
    }

    protected final void putAllPlaylistInHierarchy(@NotNull String parentPlaylistUniqueId, @NotNull Collection<? extends P> playlist) {
        Intrinsics.checkNotNullParameter((Object)parentPlaylistUniqueId, (String)"parentPlaylistUniqueId");
        Intrinsics.checkNotNullParameter(playlist, (String)"playlist");
        this.playlistsHierarchyMultiMap.putAll((Object)parentPlaylistUniqueId, (Iterable)playlist);
    }

    protected final void removePlaylistFromHierarchy(@NotNull String parentPlaylistUniqueId, @NotNull P playlist) {
        Intrinsics.checkNotNullParameter((Object)parentPlaylistUniqueId, (String)"parentPlaylistUniqueId");
        Intrinsics.checkNotNullParameter(playlist, (String)"playlist");
        this.playlistsHierarchyMultiMap.remove((Object)parentPlaylistUniqueId, playlist);
    }

    public boolean plus(@NotNull P entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return this.repository.plus((IdentifiableEntity)entity);
    }

    public boolean plus(@NotNull Set<? extends P> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        return this.repository.plus(entities);
    }

    public boolean minus(@NotNull P entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        return this.repository.minus((IdentifiableEntity)entity);
    }

    public boolean minus(@NotNull Collection<? extends P> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        return this.repository.minus(entities);
    }

    public void clear() {
        this.repository.clear();
    }

    public boolean runForSingle(int id, @NotNull Consumer<P> entityAction) {
        Intrinsics.checkNotNullParameter(entityAction, (String)"entityAction");
        return this.repository.runForSingle((Comparable)Integer.valueOf(id), entityAction);
    }

    public boolean runForMany(@NotNull Set<Integer> ids, @NotNull Consumer<P> entityAction) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter(entityAction, (String)"entityAction");
        return this.repository.runForMany(ids, entityAction);
    }

    public boolean runMatching(@NotNull Predicate<P> predicate, @NotNull Consumer<P> entityAction) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(entityAction, (String)"entityAction");
        return this.repository.runMatching(predicate, entityAction);
    }

    public boolean runForAll(@NotNull Consumer<P> entityAction) {
        Intrinsics.checkNotNullParameter(entityAction, (String)"entityAction");
        return this.repository.runForAll(entityAction);
    }

    public boolean contains(int id) {
        return this.repository.contains((Comparable)Integer.valueOf(id));
    }

    public boolean contains(@NotNull Predicate<P> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.repository.contains(predicate);
    }

    @NotNull
    public Set<P> search(@NotNull Predicate<P> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.repository.search(predicate);
    }

    @NotNull
    public Set<P> search(int size, @NotNull Predicate<P> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.repository.search(size, predicate);
    }

    @NotNull
    public Optional<P> findFirst(@NotNull Predicate<P> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this.repository.findFirst(predicate);
    }

    @NotNull
    public Optional<P> findById(int id) {
        return this.repository.findById((Comparable)Integer.valueOf(id));
    }

    @NotNull
    public Optional<P> findByUniqueId(@NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        return this.repository.findByUniqueId(uniqueId);
    }

    public int size() {
        return this.repository.size();
    }

    public boolean isEmpty() {
        return this.repository.isEmpty();
    }

    public void emitAsync(@NotNull CrudEvent<Integer, P> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        this.repository.emitAsync((TransEvent)event);
    }

    @NotNull
    public TransEventSubscription<? super TransEntity, CrudEvent.Type, CrudEvent<Integer, P>> subscribe(@NotNull Function2<? super CrudEvent<Integer, P>, ? super Continuation<? super Unit>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.repository.subscribe(action);
    }

    @NotNull
    public TransEventSubscription<? super TransEntity, CrudEvent.Type, CrudEvent<Integer, P>> subscribe(@NotNull Consumer<? super CrudEvent<Integer, P>> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.repository.subscribe(action);
    }

    @NotNull
    public TransEventSubscription<? super TransEntity, CrudEvent.Type, CrudEvent<Integer, P>> subscribe(@NotNull CrudEvent.Type[] eventTypes, @NotNull Function2<? super CrudEvent<Integer, P>, ? super Continuation<? super Unit>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter((Object)eventTypes, (String)"eventTypes");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.repository.subscribe((EventType[])eventTypes, action);
    }

    public void subscribe(Flow.Subscriber<? super CrudEvent<Integer, P>> p0) {
        this.repository.subscribe(p0);
    }

    public void activateEvents(CrudEvent.Type ... types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        this.repository.activateEvents((EventType[])types);
    }

    public void disableEvents(CrudEvent.Type ... types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        this.repository.disableEvents((EventType[])types);
    }

    @NotNull
    public SharedFlow<CrudEvent<Integer, P>> getChanges() {
        return this.repository.getChanges();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final void audioItemEventSubscriber$lambda$0$0(PlaylistHierarchyBase this$0, CrudEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.runForAll(arg_0 -> PlaylistHierarchyBase.audioItemEventSubscriber$lambda$0$0$0(event, arg_0));
    }

    private static final void audioItemEventSubscriber$lambda$0$0$0(CrudEvent $event, ReactiveAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.removeAudioItemIds((Collection)$event.getEntities().keySet());
    }

    private static final boolean addOrReplaceAll$lambda$0(PlaylistHierarchyBase this$0, ReactiveAudioPlaylist it) {
        return it != null && this$0.repository.contains(it.getId());
    }

    private static final boolean addOrReplaceAll$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean addOrReplaceAll$lambda$2(PlaylistHierarchyBase this$0, List $entitiesBeforeUpdate, ReactiveAudioPlaylist entity) {
        Optional optional;
        Optional $this$addOrReplaceAll_u24lambda_u242_u240 = optional = this$0.repository.findById(entity.getId());
        boolean bl = false;
        $this$addOrReplaceAll_u24lambda_u242_u240.ifPresent(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$2$0$1(arg_0 -> PlaylistHierarchyBase.addOrReplaceAll$lambda$2$0$0($entitiesBeforeUpdate, arg_0), arg_0));
        Optional entityBefore = optional;
        Repository repository = this$0.repository;
        Intrinsics.checkNotNull((Object)entity);
        repository.addOrReplace((IdentifiableEntity)entity);
        return entityBefore.isPresent();
    }

    private static final Unit addOrReplaceAll$lambda$2$0$0(List $entitiesBeforeUpdate, ReactiveAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $entitiesBeforeUpdate.add(it);
        return Unit.INSTANCE;
    }

    private static final void addOrReplaceAll$lambda$2$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean addOrReplaceAll$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Object addOrReplaceAll$lambda$4$0(List $it) {
        return $it.size() + " entities were added: " + $it;
    }

    private static final Object addOrReplaceAll$lambda$5$0(List $it) {
        return $it.size() + " entities were replaced: " + $it;
    }

    private static final Stream addOrReplaceAll$lambda$6(List it) {
        return it.stream();
    }

    private static final Stream addOrReplaceAll$lambda$7(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Unit removeFromPlaylistsHierarchy$lambda$0(ReactiveAudioPlaylist $playlist, PlaylistHierarchyBase this$0, ReactiveAudioPlaylist parentPlaylist) {
        Intrinsics.checkNotNullParameter((Object)parentPlaylist, (String)"parentPlaylist");
        parentPlaylist.removePlaylist($playlist);
        this$0.playlistsHierarchyMultiMap.remove((Object)parentPlaylist, (Object)$playlist);
        return Unit.INSTANCE;
    }

    private static final void removeFromPlaylistsHierarchy$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean findByName$lambda$0(String $name, ReactiveAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    private static final boolean findParentPlaylist$lambda$0(ReactiveAudioPlaylist $playlist, Map.Entry it) {
        return Intrinsics.areEqual((Object)$playlist, it.getValue());
    }

    private static final boolean findParentPlaylist$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ReactiveAudioPlaylist findParentPlaylist$lambda$2(PlaylistHierarchyBase this$0, Map.Entry it) {
        Object k = it.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
        return (ReactiveAudioPlaylist)this$0.findByUniqueId((String)k).get();
    }

    private static final ReactiveAudioPlaylist findParentPlaylist$lambda$3(Function1 $tmp0, Object p0) {
        return (ReactiveAudioPlaylist)$tmp0.invoke(p0);
    }

    private static final Unit movePlaylist$lambda$2(Optional $playlistToMove, PlaylistHierarchyBase this$0, String $playlistNameToMove, ReactiveAudioPlaylist parentPlaylist) {
        Intrinsics.checkNotNullParameter((Object)parentPlaylist, (String)"parentPlaylist");
        Object t = $playlistToMove.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        parentPlaylist.removePlaylist((ReactiveAudioPlaylist)t);
        this$0.logger.debug(() -> PlaylistHierarchyBase.movePlaylist$lambda$2$0($playlistNameToMove, parentPlaylist));
        return Unit.INSTANCE;
    }

    private static final Object movePlaylist$lambda$2$0(String $playlistNameToMove, ReactiveAudioPlaylist $parentPlaylist) {
        return "Playlist '" + $playlistNameToMove + "' removed from '" + $parentPlaylist + "'";
    }

    private static final void movePlaylist$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object movePlaylist$lambda$4(String $playlistNameToMove, String $destinationPlaylistName) {
        return "Playlist '" + $playlistNameToMove + "' moved to '" + $destinationPlaylistName + "'";
    }

    private static final ReactiveAudioPlaylist addPlaylistsToDirectory$lambda$1$2(PlaylistHierarchyBase this$0, String playlistName) {
        Intrinsics.checkNotNull((Object)playlistName);
        return (ReactiveAudioPlaylist)this$0.findByName(playlistName).orElseThrow(() -> PlaylistHierarchyBase.addPlaylistsToDirectory$lambda$1$2$0(playlistName));
    }

    private static final IllegalArgumentException addPlaylistsToDirectory$lambda$1$2$0(String $playlistName) {
        return new IllegalArgumentException("Playlist '" + $playlistName + "' does not exist");
    }

    private static final ReactiveAudioPlaylist addPlaylistsToDirectory$lambda$1$3(Function1 $tmp0, Object p0) {
        return (ReactiveAudioPlaylist)$tmp0.invoke(p0);
    }

    private static final ReactiveAudioPlaylist removePlaylistsFromDirectory$lambda$1$1(PlaylistHierarchyBase this$0, String playlistName) {
        Intrinsics.checkNotNull((Object)playlistName);
        return (ReactiveAudioPlaylist)this$0.findByName(playlistName).orElseThrow(() -> PlaylistHierarchyBase.removePlaylistsFromDirectory$lambda$1$1$0(playlistName));
    }

    private static final IllegalArgumentException removePlaylistsFromDirectory$lambda$1$1$0(String $playlistName) {
        return new IllegalArgumentException("Playlist '" + $playlistName + "' does not exist");
    }

    private static final ReactiveAudioPlaylist removePlaylistsFromDirectory$lambda$1$2(Function1 $tmp0, Object p0) {
        return (ReactiveAudioPlaylist)$tmp0.invoke(p0);
    }

    private static final boolean numberOfPlaylists$lambda$0(ReactiveAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isDirectory();
    }

    private static final boolean numberOfPlaylistDirectories$lambda$0(ReactiveAudioPlaylist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    public PlaylistHierarchyBase() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u00a4\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00010\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003B?\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010$\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u0016\u0010&\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J\u001b\u0010&\u001a\u00020\u00062\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0017\u00a2\u0006\u0002\b(J\u0016\u0010)\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010%H\u0016J\u0016\u0010*\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010%H\u0016J\u001b\u0010*\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020%H\u0017\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020.H\u0016J\u0013\u00100\u001a\u00020\u00062\b\u00101\u001a\u0004\u0018\u000102H\u0096\u0002J\b\u00103\u001a\u00020\u0002H\u0016J\u001c\u00104\u001a\u00020\b\"\u0004\b\u0002\u001052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H50%H\u0002J\b\u00107\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00068V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0005\u0010\u001a\"\u0004\b\u001b\u0010\u001cR+\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00068"}, d2={"Lnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase$MutablePlaylistBase;", "Lnet/transgressoft/commons/entity/ReactiveEntityBase;", "", "Lnet/transgressoft/commons/music/playlist/ReactiveAudioPlaylist;", "id", "isDirectory", "", "name", "", "audioItems", "", "playlists", "", "<init>", "(Lnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase;IZLjava/lang/String;Ljava/util/List;Ljava/util/Set;)V", "getId", "()Ljava/lang/Integer;", "logger", "Lmu/KLogger;", "", "getAudioItems", "()Ljava/util/List;", "", "getPlaylists", "()Ljava/util/Set;", "<set-?>", "()Z", "setDirectory", "(Z)V", "isDirectory$delegate", "Lkotlin/properties/ReadWriteProperty;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "name$delegate", "addAudioItems", "", "removeAudioItems", "audioItemIds", "removeAudioItemIds", "addPlaylists", "removePlaylists", "playlistIds", "removePlaylistIds", "clearAudioItems", "", "clearPlaylists", "equals", "other", "", "hashCode", "formatCollectionWithIndentation", "T", "collection", "toString", "music-commons-core"})
    @SourceDebugExtension(value={"SMAP\nPlaylistHierarchyBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaylistHierarchyBase.kt\nnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase$MutablePlaylistBase\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,437:1\n33#2,3:438\n33#2,3:441\n1869#3,2:444\n1869#3,2:446\n1869#3,2:448\n*S KotlinDebug\n*F\n+ 1 PlaylistHierarchyBase.kt\nnet/transgressoft/commons/music/playlist/PlaylistHierarchyBase$MutablePlaylistBase\n*L\n287#1:438,3\n294#1:441,3\n332#1:444,2\n371#1:446,2\n355#1:448,2\n*E\n"})
    protected abstract class MutablePlaylistBase
    extends ReactiveEntityBase<Integer, P>
    implements ReactiveAudioPlaylist<I, P> {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        private final int id;
        @NotNull
        private final KLogger logger;
        @NotNull
        private final List<I> audioItems;
        @NotNull
        private final Set<P> playlists;
        @NotNull
        private final ReadWriteProperty isDirectory$delegate;
        @NotNull
        private final ReadWriteProperty name$delegate;
        final /* synthetic */ PlaylistHierarchyBase<I, P> this$0;

        public MutablePlaylistBase(PlaylistHierarchyBase this$0, int id, @NotNull boolean isDirectory2, @NotNull String name2, @NotNull List<? extends I> audioItems, Set<? extends P> playlists) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
            Intrinsics.checkNotNullParameter(playlists, (String)"playlists");
            this.this$0 = this$0;
            this.id = id;
            this.logger = KotlinLogging.INSTANCE.logger(MutablePlaylistBase::logger$lambda$0);
            this.audioItems = new ArrayList(audioItems);
            this.playlists = new HashSet(playlists);
            Delegates delegates = Delegates.INSTANCE;
            Object initialValue$iv = isDirectory2;
            boolean $i$f$observable = false;
            this.isDirectory$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>(initialValue$iv, this){
                final /* synthetic */ MutablePlaylistBase this$0;
                {
                    this.this$0 = mutablePlaylistBase;
                    super($initialValue);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                    void newValue2;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    boolean bl = (Boolean)newValue;
                    boolean oldValue2 = (Boolean)oldValue;
                    boolean bl2 = false;
                    if (newValue2 != oldValue2) {
                        ReactiveEntityBase.setAndNotify$default((ReactiveEntityBase)this.this$0, (Object)((boolean)newValue2), (Object)oldValue2, null, (int)4, null);
                        MutablePlaylistBase.access$getLogger$p(this.this$0).trace((Function0)new Function0<Object>(this.this$0, oldValue2, (boolean)newValue2){
                            final /* synthetic */ MutablePlaylistBase this$0;
                            final /* synthetic */ boolean $oldValue;
                            final /* synthetic */ boolean $newValue;
                            {
                                this.this$0 = $receiver;
                                this.$oldValue = $oldValue;
                                this.$newValue = $newValue;
                            }

                            public final Object invoke() {
                                return "Playlist " + this.this$0.getUniqueId() + " changed isDirectory from " + this.$oldValue + " to " + this.$newValue;
                            }
                        });
                    }
                }
            };
            Delegates this_$iv = Delegates.INSTANCE;
            initialValue$iv = name2;
            PlaylistHierarchyBase playlistHierarchyBase = this.this$0;
            boolean $i$f$observable2 = false;
            this.name$delegate = (ReadWriteProperty)new ObservableProperty<String>(initialValue$iv, playlistHierarchyBase, this){
                final /* synthetic */ PlaylistHierarchyBase this$0;
                final /* synthetic */ MutablePlaylistBase this$1$inlined;
                {
                    this.this$0 = playlistHierarchyBase;
                    this.this$1$inlined = mutablePlaylistBase;
                    super($initialValue);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                    void newValue2;
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    String string = (String)newValue;
                    String oldValue2 = (String)oldValue;
                    boolean bl = false;
                    if (!this.this$0.findByName((String)newValue2).isPresent()) {
                        boolean bl2 = false;
                        String string2 = "Playlist with name '" + (String)newValue2 + "' already exists";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    if (!Intrinsics.areEqual((Object)newValue2, (Object)oldValue2)) {
                        ReactiveEntityBase.setAndNotify$default((ReactiveEntityBase)this.this$1$inlined, (Object)newValue2, (Object)oldValue2, null, (int)4, null);
                        MutablePlaylistBase.access$getLogger$p(this.this$1$inlined).trace((Function0)new Function0<Object>(this.this$1$inlined, oldValue2, (String)newValue2){
                            final /* synthetic */ MutablePlaylistBase this$0;
                            final /* synthetic */ String $oldValue;
                            final /* synthetic */ String $newValue;
                            {
                                this.this$0 = $receiver;
                                this.$oldValue = $oldValue;
                                this.$newValue = $newValue;
                            }

                            public final Object invoke() {
                                return "Playlist " + this.this$0.getUniqueId() + " changed name from " + this.$oldValue + " to " + this.$newValue;
                            }
                        });
                    }
                }
            };
        }

        public /* synthetic */ MutablePlaylistBase(PlaylistHierarchyBase playlistHierarchyBase, int n, boolean bl, String string, List list, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n2 & 0x10) != 0) {
                set = SetsKt.emptySet();
            }
            this(playlistHierarchyBase, n, bl, string, list, set);
        }

        @NotNull
        public Integer getId() {
            return this.id;
        }

        @NotNull
        public List<I> getAudioItems() {
            return this.audioItems;
        }

        @NotNull
        public Set<P> getPlaylists() {
            return this.playlists;
        }

        public boolean isDirectory() {
            return (Boolean)this.isDirectory$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public void setDirectory(boolean bl) {
            this.isDirectory$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        @NotNull
        public String getName() {
            return (String)this.name$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        public boolean addAudioItems(@NotNull Collection<? extends I> audioItems) {
            Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
            boolean result2 = this.getAudioItems().stream().anyMatch(arg_0 -> MutablePlaylistBase.addAudioItems$lambda$1(arg_0 -> MutablePlaylistBase.addAudioItems$lambda$0(audioItems, arg_0), arg_0));
            this.setAndNotify(CollectionsKt.plus((Collection)this.getAudioItems(), (Iterable)audioItems), this.getAudioItems(), arg_0 -> MutablePlaylistBase.addAudioItems$lambda$2(this, audioItems, arg_0));
            return result2;
        }

        public boolean removeAudioItems(@NotNull Collection<? extends I> audioItems) {
            Intrinsics.checkNotNullParameter(audioItems, (String)"audioItems");
            boolean result2 = this.getAudioItems().stream().anyMatch(arg_0 -> MutablePlaylistBase.removeAudioItems$lambda$0((Function1)new Function1<I, Boolean>(audioItems){

                public final Boolean invoke(I p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((Collection)this.receiver).contains(p0);
                }
            }, arg_0));
            this.setAndNotify(CollectionsKt.minus((Iterable)this.getAudioItems(), (Iterable)CollectionsKt.toSet((Iterable)audioItems)), this.getAudioItems(), arg_0 -> MutablePlaylistBase.removeAudioItems$lambda$1(this, audioItems, arg_0));
            return result2;
        }

        @JvmName(name="removeAudioItemIds")
        public boolean removeAudioItemIds(@NotNull Collection<Integer> audioItemIds) {
            Intrinsics.checkNotNullParameter(audioItemIds, (String)"audioItemIds");
            boolean result2 = this.getAudioItems().stream().anyMatch(arg_0 -> MutablePlaylistBase.removeAudioItems$lambda$3(arg_0 -> MutablePlaylistBase.removeAudioItems$lambda$2(audioItemIds, arg_0), arg_0));
            this.setAndNotify(CollectionsKt.minus((Iterable)this.getAudioItems(), (Iterable)CollectionsKt.toSet((Iterable)this.getAudioItems())), this.getAudioItems(), arg_0 -> MutablePlaylistBase.removeAudioItems$lambda$4(this, audioItemIds, arg_0));
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean addPlaylists(@NotNull Collection<? extends P> playlists) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(playlists, (String)"playlists");
            Iterable iterable = playlists;
            PlaylistHierarchyBase playlistHierarchyBase = this.this$0;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReactiveAudioPlaylist it = (ReactiveAudioPlaylist)element$iv;
                boolean bl = false;
                playlistHierarchyBase.findParentPlaylist(it).ifPresent(arg_0 -> MutablePlaylistBase.addPlaylists$lambda$0$1(arg_0 -> MutablePlaylistBase.addPlaylists$lambda$0$0(it, this, arg_0), arg_0));
            }
            boolean result2 = !this.getPlaylists().stream().anyMatch(arg_0 -> MutablePlaylistBase.addPlaylists$lambda$1((Function1)new Function1<P, Boolean>(playlists){

                public final Boolean invoke(P p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((Collection)this.receiver).contains(p0);
                }
            }, arg_0));
            this.setAndNotify(SetsKt.plus(this.getPlaylists(), (Iterable)playlists), this.getPlaylists(), arg_0 -> MutablePlaylistBase.addPlaylists$lambda$2(this, playlists, this.this$0, arg_0));
            return result2;
        }

        public boolean removePlaylists(@NotNull Collection<? extends P> playlists) {
            Intrinsics.checkNotNullParameter(playlists, (String)"playlists");
            boolean result2 = this.getPlaylists().stream().anyMatch(arg_0 -> MutablePlaylistBase.removePlaylists$lambda$0((Function1)new Function1<P, Boolean>(playlists){

                public final Boolean invoke(P p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((Collection)this.receiver).contains(p0);
                }
            }, arg_0));
            this.setAndNotify(SetsKt.minus(this.getPlaylists(), (Iterable)CollectionsKt.toSet((Iterable)playlists)), this.getPlaylists(), arg_0 -> MutablePlaylistBase.removePlaylists$lambda$1(this, playlists, this.this$0, arg_0));
            return result2;
        }

        @JvmName(name="removePlaylistIds")
        public boolean removePlaylistIds(@NotNull Collection<Integer> playlistIds) {
            Intrinsics.checkNotNullParameter(playlistIds, (String)"playlistIds");
            boolean result2 = this.getPlaylists().stream().anyMatch(arg_0 -> MutablePlaylistBase.removePlaylists$lambda$3(arg_0 -> MutablePlaylistBase.removePlaylists$lambda$2(playlistIds, arg_0), arg_0));
            boolean bl = CollectionsKt.removeAll((Iterable)this.getPlaylists(), arg_0 -> MutablePlaylistBase.removePlaylists$lambda$4(playlistIds, arg_0));
            PlaylistHierarchyBase playlistHierarchyBase = this.this$0;
            boolean it = bl;
            boolean bl2 = false;
            if (it) {
                Iterable $this$forEach$iv = playlistIds;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int playlistId = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    playlistHierarchyBase.findById(playlistId).ifPresent(arg_0 -> MutablePlaylistBase.removePlaylists$lambda$5$0$1(arg_0 -> MutablePlaylistBase.removePlaylists$lambda$5$0$0(playlistHierarchyBase, this, arg_0), arg_0));
                }
                this.logger.debug(() -> MutablePlaylistBase.removePlaylists$lambda$5$1(playlistIds, this));
            }
            return result2;
        }

        public void clearAudioItems() {
            if (!((Collection)this.getAudioItems()).isEmpty()) {
                int audioItemsSize = this.getAudioItems().size();
                this.setAndNotify(CollectionsKt.emptyList(), this.getAudioItems(), arg_0 -> MutablePlaylistBase.clearAudioItems$lambda$0(this, arg_0));
                this.logger.debug(() -> MutablePlaylistBase.clearAudioItems$lambda$1(audioItemsSize, this));
            }
        }

        public void clearPlaylists() {
            if (!((Collection)this.getPlaylists()).isEmpty()) {
                int playlistSize = this.getPlaylists().size();
                this.setAndNotify(CollectionsKt.emptyList(), this.getPlaylists(), arg_0 -> MutablePlaylistBase.clearPlaylists$lambda$0(this, arg_0));
                this.logger.debug(() -> MutablePlaylistBase.clearPlaylists$lambda$1(playlistSize, this));
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type net.transgressoft.commons.music.playlist.PlaylistHierarchyBase.MutablePlaylistBase<*, *>");
            MutablePlaylistBase cfr_ignored_0 = (MutablePlaylistBase)((Object)object2);
            if (this.isDirectory() != ((MutablePlaylistBase)((Object)other)).isDirectory()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getName(), (Object)((MutablePlaylistBase)((Object)other)).getName())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getAudioItems(), ((MutablePlaylistBase)((Object)other)).getAudioItems())) {
                return false;
            }
            return Intrinsics.areEqual(this.getPlaylists(), ((MutablePlaylistBase)((Object)other)).getPlaylists());
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isDirectory());
            result2 = 31 * result2 + this.getName().hashCode();
            result2 = 31 * result2 + ((Object)this.getAudioItems()).hashCode();
            result2 = 31 * result2 + ((Object)this.getPlaylists()).hashCode();
            return result2;
        }

        private final <T> String formatCollectionWithIndentation(Collection<? extends T> collection) {
            if (collection.isEmpty()) {
                return "[]";
            }
            return CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",\n\t", (CharSequence)"[\n\t", (CharSequence)"\n]", (int)0, null, MutablePlaylistBase::formatCollectionWithIndentation$lambda$0, (int)24, null);
        }

        @NotNull
        public String toString() {
            String formattedAudioItems = this.formatCollectionWithIndentation(this.getAudioItems());
            String formattedPlaylists = this.formatCollectionWithIndentation(this.getPlaylists());
            return "MutablePlaylist(id=" + this.getId() + ", isDirectory=" + this.isDirectory() + ", name='" + this.getName() + "', audioItems=" + formattedAudioItems + ", playlists=" + formattedPlaylists + ")";
        }

        private static final Unit logger$lambda$0() {
            return Unit.INSTANCE;
        }

        private static final boolean addAudioItems$lambda$0(Collection $audioItems, ReactiveAudioItem it) {
            return !$audioItems.contains(it);
        }

        private static final boolean addAudioItems$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void addAudioItems$lambda$2(MutablePlaylistBase this$0, Collection $audioItems, List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.getAudioItems().addAll($audioItems);
            this$0.logger.debug(() -> MutablePlaylistBase.addAudioItems$lambda$2$0($audioItems, this$0));
        }

        private static final Object addAudioItems$lambda$2$0(Collection $audioItems, MutablePlaylistBase this$0) {
            return "Added " + $audioItems + " to playlist " + this$0.getUniqueId();
        }

        private static final boolean removeAudioItems$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void removeAudioItems$lambda$1(MutablePlaylistBase this$0, Collection $audioItems, List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.getAudioItems().removeAll($audioItems);
            this$0.logger.debug(() -> MutablePlaylistBase.removeAudioItems$lambda$1$0($audioItems, this$0));
        }

        private static final Object removeAudioItems$lambda$1$0(Collection $audioItems, MutablePlaylistBase this$0) {
            return "Removed " + $audioItems + " from playlist " + this$0.getUniqueId();
        }

        private static final boolean removeAudioItems$lambda$2(Collection $audioItemIds, ReactiveAudioItem it) {
            return $audioItemIds.contains(it.getId());
        }

        private static final boolean removeAudioItems$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void removeAudioItems$lambda$4(MutablePlaylistBase this$0, Collection $audioItemIds, List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            CollectionsKt.removeAll(this$0.getAudioItems(), arg_0 -> MutablePlaylistBase.removeAudioItems$lambda$4$0($audioItemIds, arg_0));
            this$0.logger.debug(() -> MutablePlaylistBase.removeAudioItems$lambda$4$1($audioItemIds, this$0));
        }

        private static final boolean removeAudioItems$lambda$4$0(Collection $audioItemIds, ReactiveAudioItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $audioItemIds.contains(it.getId());
        }

        private static final Object removeAudioItems$lambda$4$1(Collection $audioItemIds, MutablePlaylistBase this$0) {
            return "Removed audio items with ids " + $audioItemIds + " from playlist " + this$0.getUniqueId();
        }

        private static final Unit addPlaylists$lambda$0$0(ReactiveAudioPlaylist $it, MutablePlaylistBase this$0, ReactiveAudioPlaylist parentPlaylist) {
            Intrinsics.checkNotNullParameter((Object)parentPlaylist, (String)"parentPlaylist");
            parentPlaylist.removePlaylist($it);
            this$0.logger.debug(() -> MutablePlaylistBase.addPlaylists$lambda$0$0$0($it, parentPlaylist));
            return Unit.INSTANCE;
        }

        private static final Object addPlaylists$lambda$0$0$0(ReactiveAudioPlaylist $it, ReactiveAudioPlaylist $parentPlaylist) {
            return "Playlist '" + $it.getName() + "' removed from '" + $parentPlaylist + "'";
        }

        private static final void addPlaylists$lambda$0$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final boolean addPlaylists$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void addPlaylists$lambda$2(MutablePlaylistBase this$0, Collection $playlists, PlaylistHierarchyBase this$1, Set it) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean it2 = bl = this$0.getPlaylists().addAll($playlists);
            boolean bl2 = false;
            if (it2) {
                this$1.putAllPlaylistInHierarchy(this$0.getUniqueId(), $playlists);
                this$0.logger.debug(() -> MutablePlaylistBase.addPlaylists$lambda$2$0$0($playlists, this$0));
            }
        }

        private static final Object addPlaylists$lambda$2$0$0(Collection $playlists, MutablePlaylistBase this$0) {
            return "Added " + $playlists + " to playlist " + this$0.getUniqueId();
        }

        private static final boolean removePlaylists$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void removePlaylists$lambda$1(MutablePlaylistBase this$0, Collection $playlists, PlaylistHierarchyBase this$1, Set it) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean it2 = bl = this$0.getPlaylists().removeAll(CollectionsKt.toSet((Iterable)$playlists));
            boolean bl2 = false;
            if (it2) {
                Iterable $this$forEach$iv = $playlists;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ReactiveAudioPlaylist playlist = (ReactiveAudioPlaylist)element$iv;
                    boolean bl3 = false;
                    this$1.removePlaylistFromHierarchy(this$0.getUniqueId(), playlist);
                }
                this$0.logger.debug(() -> MutablePlaylistBase.removePlaylists$lambda$1$0$1($playlists, this$0));
            }
        }

        private static final Object removePlaylists$lambda$1$0$1(Collection $playlists, MutablePlaylistBase this$0) {
            return "Removed " + $playlists + " from playlist " + this$0.getUniqueId();
        }

        private static final boolean removePlaylists$lambda$2(Collection $playlistIds, ReactiveAudioPlaylist it) {
            return $playlistIds.contains(it.getId());
        }

        private static final boolean removePlaylists$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean removePlaylists$lambda$4(Collection $playlistIds, ReactiveAudioPlaylist playlist) {
            Intrinsics.checkNotNullParameter((Object)playlist, (String)"playlist");
            return $playlistIds.contains(playlist.getId());
        }

        private static final Unit removePlaylists$lambda$5$0$0(PlaylistHierarchyBase this$0, MutablePlaylistBase this$1, ReactiveAudioPlaylist playlist) {
            Intrinsics.checkNotNullParameter((Object)playlist, (String)"playlist");
            this$0.removePlaylistFromHierarchy(this$1.getUniqueId(), playlist);
            return Unit.INSTANCE;
        }

        private static final void removePlaylists$lambda$5$0$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Object removePlaylists$lambda$5$1(Collection $playlistIds, MutablePlaylistBase this$0) {
            return "Removed playlists with ids " + $playlistIds + " from playlist " + this$0.getUniqueId();
        }

        private static final void clearAudioItems$lambda$0(MutablePlaylistBase this$0, List it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.getAudioItems().clear();
        }

        private static final Object clearAudioItems$lambda$1(int $audioItemsSize, MutablePlaylistBase this$0) {
            return "Cleared " + $audioItemsSize + " audio items from playlist " + this$0.getUniqueId();
        }

        private static final void clearPlaylists$lambda$0(MutablePlaylistBase this$0, Collection it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.getPlaylists().clear();
        }

        private static final Object clearPlaylists$lambda$1(int $playlistSize, MutablePlaylistBase this$0) {
            return "Cleared " + $playlistSize + " playlists from playlist " + this$0.getUniqueId();
        }

        private static final CharSequence formatCollectionWithIndentation$lambda$0(Object item) {
            String[] stringArray = new String[]{"\n"};
            return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)String.valueOf(item), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n\t", null, null, (int)0, null, null, (int)62, null);
        }

        public static final /* synthetic */ KLogger access$getLogger$p(MutablePlaylistBase $this) {
            return $this.logger;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(MutablePlaylistBase.class, "isDirectory", "isDirectory()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(MutablePlaylistBase.class, "name", "getName()Ljava/lang/String;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

