/*
 * Decompiled with CFR 0.152.
 */
package net.transgressoft.commons.music.waveform;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.transgressoft.commons.entity.ReactiveEntityBase;
import net.transgressoft.commons.music.audio.AudioFileType;
import net.transgressoft.commons.music.audio.AudioFileTypeKt;
import net.transgressoft.commons.music.waveform.AudioWaveform;
import net.transgressoft.commons.music.waveform.AudioWaveformProcessingException;
import net.transgressoft.commons.music.waveform.ScalableAudioWaveform;
import net.transgressoft.commons.music.waveform.ScalableAudioWaveform$;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ws.schild.jave.Encoder;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingAttributes;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 A2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0003:\u0002@AB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB-\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001eH\u0002J\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0002H\u0002J6\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010.J\u0013\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\b\u00106\u001a\u00020\u0002H\u0016J\b\u00107\u001a\u00020\u0000H\u0016J\b\u00108\u001a\u00020\u0017H\u0016J%\u00109\u001a\u00020)2\u0006\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0001\u00a2\u0006\u0002\b?R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u00128\u0002X\u0083D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u0014R\u0014\u0010/\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006B"}, d2={"Lnet/transgressoft/commons/music/waveform/ScalableAudioWaveform;", "Lnet/transgressoft/commons/entity/ReactiveEntityBase;", "", "Lnet/transgressoft/commons/music/waveform/AudioWaveform;", "id", "audioFilePath", "Ljava/nio/file/Path;", "<init>", "(ILjava/nio/file/Path;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IILjava/nio/file/Path;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/Integer;", "getAudioFilePath", "()Ljava/nio/file/Path;", "amplitudeCoefficient", "", "getAmplitudeCoefficient$annotations", "()V", "supportedAudioTypes", "", "", "Lnet/transgressoft/commons/music/audio/AudioFileType$Companion;", "rawAudioPcm", "", "getRawAudioPcm$annotations", "getRawAudioPcm", "transcodeToWav", "Ljava/io/File;", "path", "getRawPulseCodeModulation", "file", "amplitudes", "", "width", "height", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getScaledPulseCodeModulation", "createImage", "", "outputFile", "waveformColor", "Ljava/awt/Color;", "backgroundColor", "(Ljava/io/File;Ljava/awt/Color;Ljava/awt/Color;IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uniqueId", "getUniqueId", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "clone", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$music_commons_core", "$serializer", "Companion", "music-commons-core"})
@SourceDebugExtension(value={"SMAP\nScalableAudioWaveform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScalableAudioWaveform.kt\nnet/transgressoft/commons/music/waveform/ScalableAudioWaveform\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
public final class ScalableAudioWaveform
extends ReactiveEntityBase<Integer, AudioWaveform>
implements AudioWaveform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    @NotNull
    private final Path audioFilePath;
    private final double amplitudeCoefficient;
    @Nullable
    private int[] rawAudioPcm;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public ScalableAudioWaveform(int id, @NotNull Path audioFilePath) {
        Intrinsics.checkNotNullParameter((Object)audioFilePath, (String)"audioFilePath");
        this.id = id;
        this.audioFilePath = audioFilePath;
        this.amplitudeCoefficient = 3.9;
        if (!this.supportedAudioTypes(AudioFileType.Companion).contains(PathsKt.getExtension((Path)this.getAudioFilePath()))) {
            boolean $i$a$-check-ScalableAudioWaveform$32 = false;
            String $i$a$-check-ScalableAudioWaveform$32 = "File extension '" + PathsKt.getExtension((Path)this.getAudioFilePath()) + "' not supported";
            throw new IllegalStateException($i$a$-check-ScalableAudioWaveform$32.toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.getAudioFilePath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "File '" + this.getAudioFilePath() + "' does not exist";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public Integer getId() {
        return this.id;
    }

    @NotNull
    public Path getAudioFilePath() {
        return this.audioFilePath;
    }

    @Transient
    private static /* synthetic */ void getAmplitudeCoefficient$annotations() {
    }

    private final Set<String> supportedAudioTypes(AudioFileType.Companion $this$supportedAudioTypes) {
        Object[] objectArray = new String[]{AudioFileType.MP3.getExtension(), AudioFileType.M4A.getExtension(), AudioFileType.FLAC.getExtension(), AudioFileType.WAV.getExtension()};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Transient
    private static /* synthetic */ void getRawAudioPcm$annotations() {
    }

    private final int[] getRawAudioPcm(Path audioFilePath) {
        int[] nArray;
        try {
            int[] nArray2;
            if (WhenMappings.$EnumSwitchMapping$0[AudioFileTypeKt.toAudioFileType((String)PathsKt.getExtension((Path)audioFilePath)).ordinal()] == 1) {
                File file = audioFilePath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                nArray2 = this.getRawPulseCodeModulation(file);
            } else {
                int[] nArray3;
                File convertedFile = this.transcodeToWav(audioFilePath);
                boolean bl = false;
                int[] it = nArray3 = this.getRawPulseCodeModulation(convertedFile);
                boolean bl2 = false;
                Files.delete(convertedFile.toPath());
                nArray2 = nArray3;
            }
            nArray = nArray2;
        }
        catch (Exception exception) {
            throw new AudioWaveformProcessingException("Error processing waveform", (Throwable)exception);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File transcodeToWav(Path path) {
        String fileName = ((Object)path.getFileName()).toString();
        File decodedFile = File.createTempFile("decoded_" + fileName, "." + AudioFileType.WAV.getExtension());
        File copiedFile = File.createTempFile("original_" + fileName, "." + PathsKt.getExtension((Path)path));
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
        Files.copy(path, copiedFile.toPath(), copyOptionArray);
        try {
            void $this$transcodeToWav_u24lambda_u240_u240;
            AudioAttributes audioAttributes;
            void $this$transcodeToWav_u24lambda_u240;
            CopyOption[] copyOptionArray2 = copyOptionArray = new EncodingAttributes();
            File file = decodedFile;
            MultimediaObject multimediaObject = new MultimediaObject(copiedFile);
            Encoder encoder = new Encoder();
            boolean bl = false;
            $this$transcodeToWav_u24lambda_u240.setOutputFormat(AudioFileType.WAV.getExtension());
            AudioAttributes audioAttributes2 = audioAttributes = new AudioAttributes();
            void var10_14 = $this$transcodeToWav_u24lambda_u240;
            boolean bl2 = false;
            $this$transcodeToWav_u24lambda_u240_u240.setCodec("pcm_s16le");
            $this$transcodeToWav_u24lambda_u240_u240.setBitRate(Integer.valueOf(16000));
            $this$transcodeToWav_u24lambda_u240_u240.setChannels(Integer.valueOf(2));
            $this$transcodeToWav_u24lambda_u240_u240.setSamplingRate(Integer.valueOf(44100));
            var10_14.setAudioAttributes(audioAttributes);
            Unit unit = Unit.INSTANCE;
            encoder.encode(multimediaObject, file, (EncodingAttributes)copyOptionArray);
        }
        finally {
            Files.delete(copiedFile.toPath());
        }
        Intrinsics.checkNotNull((Object)decodedFile);
        return decodedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] getRawPulseCodeModulation(File file) {
        int[] audioPcm = null;
        Closeable closeable = AudioSystem.getAudioInputStream(file);
        Throwable throwable = null;
        try {
            AudioInputStream input = (AudioInputStream)closeable;
            boolean bl = false;
            AudioFormat baseFormat = input.getFormat();
            AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_UNSIGNED;
            float sampleRate = baseFormat.getSampleRate();
            int sampleSizeInBits = 16;
            int numChannels = baseFormat.getChannels();
            int frameSize = numChannels * 2;
            AudioFormat decodedFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, numChannels, frameSize, sampleRate, false);
            int available = input.available();
            audioPcm = new int[available];
            Closeable closeable2 = AudioSystem.getAudioInputStream(decodedFormat, input);
            Throwable throwable2 = null;
            try {
                AudioInputStream pcmDecodedInput = (AudioInputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[available];
                if (pcmDecodedInput.read(buffer, 0, available) > 0) {
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(available - 1))), (int)2);
                    int i = intProgression.getFirst();
                    int n = intProgression.getLast();
                    int n2 = intProgression.getStep();
                    if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
                        while (true) {
                            audioPcm[i] = (buffer[i + 1] << 8 | buffer[i] & 0xFF) << 16;
                            int[] nArray = audioPcm;
                            int n3 = i;
                            nArray[n3] = nArray[n3] / Short.MAX_VALUE;
                            if (i == n) break;
                            i += n2;
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return audioPcm;
    }

    @Nullable
    public Object amplitudes(int width, int height, @NotNull Continuation<? super float[]> $completion) throws AudioWaveformProcessingException {
        if (!(width > 0)) {
            boolean $i$a$-check-ScalableAudioWaveform$amplitudes$42 = false;
            String $i$a$-check-ScalableAudioWaveform$amplitudes$42 = "Width must be greater than 0";
            throw new IllegalStateException($i$a$-check-ScalableAudioWaveform$amplitudes$42.toString());
        }
        if (!(height > 0)) {
            boolean $i$a$-check-ScalableAudioWaveform$amplitudes$52 = false;
            String $i$a$-check-ScalableAudioWaveform$amplitudes$52 = "Height must be greater than 0";
            throw new IllegalStateException($i$a$-check-ScalableAudioWaveform$amplitudes$52.toString());
        }
        int[] scaledAudioPcm = this.getScaledPulseCodeModulation(height);
        float[] waveformAmplitudes = new float[width];
        int samplesPerPixel = scaledAudioPcm.length / width;
        float divisor = (float)Math.pow(16.0, this.amplitudeCoefficient);
        for (int w = 0; w < width; ++w) {
            float amplitude = 0.0f;
            int samplesAtWidth = w * samplesPerPixel;
            for (int s = 0; s < samplesPerPixel; ++s) {
                amplitude += (float)Math.abs(scaledAudioPcm[samplesAtWidth + s]) / divisor;
            }
            waveformAmplitudes[w] = amplitude /= (float)samplesPerPixel;
        }
        return waveformAmplitudes;
    }

    private final int[] getScaledPulseCodeModulation(int height) throws AudioWaveformProcessingException {
        int[] nArray = this.rawAudioPcm;
        if (this.rawAudioPcm == null) {
            int[] nArray2;
            int[] it = this.getRawAudioPcm(this.getAudioFilePath());
            boolean bl = false;
            int[] scaledRawPcm = nArray2 = new int[it.length];
            boolean bl2 = false;
            int n = it.length;
            for (int i = 0; i < n; ++i) {
                scaledRawPcm[i] = it[i] * height;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object createImage(@NotNull File outputFile, @NotNull Color waveformColor, @NotNull Color backgroundColor, int width, int height, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof createImage.1)) ** GOTO lbl-1000
        var18_7 = $completion;
        if ((var18_7.label & -2147483648) != 0) {
            var18_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ ScalableAudioWaveform this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createImage(null, null, null, 0, 0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(width > 0)) {
                    $i$a$-check-ScalableAudioWaveform$createImage$2 = false;
                    $i$a$-check-ScalableAudioWaveform$createImage$2 = "Width must be greater than 0";
                    throw new IllegalStateException($i$a$-check-ScalableAudioWaveform$createImage$2.toString());
                }
                if (!(height > 0)) {
                    $i$a$-check-ScalableAudioWaveform$createImage$3 = false;
                    $i$a$-check-ScalableAudioWaveform$createImage$3 = "Height must be greater than 0";
                    throw new IllegalStateException($i$a$-check-ScalableAudioWaveform$createImage$3.toString());
                }
                $continuation.L$0 = outputFile;
                $continuation.L$1 = waveformColor;
                $continuation.L$2 = backgroundColor;
                $continuation.I$0 = width;
                $continuation.I$1 = height;
                $continuation.label = 1;
                v0 = this.amplitudes(width, height, (Continuation<? super float[]>)$continuation);
                if (v0 == var19_9) {
                    return var19_9;
                }
                ** GOTO lbl38
            }
            case 1: {
                height = $continuation.I$1;
                width = $continuation.I$0;
                backgroundColor = (Color)$continuation.L$2;
                waveformColor = (Color)$continuation.L$1;
                outputFile = (File)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                amplitudes = (float[])v0;
                $this$createImage_u24lambda_u242 = var9_18 = new BufferedImage(width, height, 2);
                $i$a$-apply-ScalableAudioWaveform$createImage$bufferedImage$1 = false;
                for (x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        absoluteAmplitude = MathKt.roundToInt((float)amplitudes[x]);
                        y1 = (height - 2 * absoluteAmplitude) / 2;
                        y2 = y1 + 2 * absoluteAmplitude;
                        v1 = y1 <= y ? y <= y2 : false;
                        if (v1) {
                            $this$createImage_u24lambda_u242.setRGB(x, y, waveformColor.getRGB());
                            continue;
                        }
                        $this$createImage_u24lambda_u242.setRGB(x, y, backgroundColor.getRGB());
                    }
                }
                bufferedImage = var9_18;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)outputFile);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)waveformColor);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)backgroundColor);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)amplitudes);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)bufferedImage);
                $continuation.I$0 = width;
                $continuation.I$1 = height;
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(bufferedImage, outputFile, null){
                    int label;
                    final /* synthetic */ BufferedImage $bufferedImage;
                    final /* synthetic */ File $outputFile;
                    {
                        this.$bufferedImage = $bufferedImage;
                        this.$outputFile = $outputFile;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((boolean)ImageIO.write((RenderedImage)this.$bufferedImage, "png", this.$outputFile));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var19_9) {
                    return var19_9;
                }
                ** GOTO lbl76
            }
            case 2: {
                height = $continuation.I$1;
                width = $continuation.I$0;
                bufferedImage = (BufferedImage)$continuation.L$4;
                amplitudes = (float[])$continuation.L$3;
                backgroundColor = (Color)$continuation.L$2;
                waveformColor = (Color)$continuation.L$1;
                outputFile = (File)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl76:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public String getUniqueId() {
        return this.getId() + "-" + Arrays.hashCode(this.rawAudioPcm);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(((Object)((Object)this)).getClass(), other.getClass())) {
            return false;
        }
        ScalableAudioWaveform that = (ScalableAudioWaveform)((Object)other);
        return Arrays.equals(this.rawAudioPcm, that.rawAudioPcm);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawAudioPcm);
    }

    @NotNull
    public ScalableAudioWaveform clone() {
        return new ScalableAudioWaveform(this.getId(), this.getAudioFilePath());
    }

    @NotNull
    public String toString() {
        return "ScalableAudioWaveform(uniqueId=" + this.getUniqueId() + ")";
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$music_commons_core(ScalableAudioWaveform self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeIntElement(serialDesc, 0, self.getId().intValue());
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), (Object)self.getAudioFilePath());
    }

    public /* synthetic */ ScalableAudioWaveform(int seen0, int id, Path audioFilePath, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.id = id;
        this.audioFilePath = audioFilePath;
        this.amplitudeCoefficient = 3.9;
        if (!this.supportedAudioTypes(AudioFileType.Companion).contains(PathsKt.getExtension((Path)this.getAudioFilePath()))) {
            boolean $i$a$-check-ScalableAudioWaveform$32 = false;
            String $i$a$-check-ScalableAudioWaveform$32 = "File extension '" + PathsKt.getExtension((Path)this.getAudioFilePath()) + "' not supported";
            throw new IllegalStateException($i$a$-check-ScalableAudioWaveform$32.toString());
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.getAudioFilePath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl = false;
            String string = "File '" + this.getAudioFilePath() + "' does not exist";
            throw new IllegalStateException(string.toString());
        }
        this.rawAudioPcm = null;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(Path.class), new Annotation[0]))};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lnet/transgressoft/commons/music/waveform/ScalableAudioWaveform$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/transgressoft/commons/music/waveform/ScalableAudioWaveform;", "music-commons-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ScalableAudioWaveform> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AudioFileType.values().length];
            try {
                nArray[AudioFileType.WAV.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

