/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ttddyy.dsproxy.asserts.ParameterKeyValue;
import net.ttddyy.dsproxy.listener.logging.RegisterOutParameterValueConverter;
import net.ttddyy.dsproxy.listener.logging.SetNullParameterValueConverter;
import net.ttddyy.dsproxy.proxy.ParameterKey;

public class ParameterKeyValueUtils {
    private static SetNullParameterValueConverter setNullValueConverter = new SetNullParameterValueConverter();
    private static RegisterOutParameterValueConverter registerOutParameterValueConverter = new RegisterOutParameterValueConverter();

    public static ParameterKeyValue createSetParam(int index, Object value) {
        String displayValue = value == null ? null : value.toString();
        return new ParameterKeyValue(index, value, displayValue, ParameterKeyValue.OperationType.SET_PARAM);
    }

    public static ParameterKeyValue createSetParam(String name, Object value) {
        String displayValue = value == null ? null : value.toString();
        return new ParameterKeyValue(name, value, displayValue, ParameterKeyValue.OperationType.SET_PARAM);
    }

    public static ParameterKeyValue createSetParam(ParameterKey key, Object value) {
        String displayValue = value == null ? null : value.toString();
        return new ParameterKeyValue(key, value, displayValue, ParameterKeyValue.OperationType.SET_PARAM);
    }

    public static ParameterKeyValue createSetNull(int index, int sqlType) {
        String displayValue = setNullValueConverter.getDisplayValue(Integer.valueOf(sqlType));
        return new ParameterKeyValue(index, (Object)sqlType, displayValue, ParameterKeyValue.OperationType.SET_NULL);
    }

    public static ParameterKeyValue createSetNull(String name, int sqlType) {
        String displayValue = setNullValueConverter.getDisplayValue(Integer.valueOf(sqlType));
        return new ParameterKeyValue(name, (Object)sqlType, displayValue, ParameterKeyValue.OperationType.SET_NULL);
    }

    public static ParameterKeyValue createSetNull(ParameterKey key, int sqlType) {
        String displayValue = setNullValueConverter.getDisplayValue(Integer.valueOf(sqlType));
        return new ParameterKeyValue(key, (Object)sqlType, displayValue, ParameterKeyValue.OperationType.SET_NULL);
    }

    public static ParameterKeyValue createRegisterOut(int index, Object value) {
        String displayValue = registerOutParameterValueConverter.getDisplayValue(value);
        return new ParameterKeyValue(index, value, displayValue, ParameterKeyValue.OperationType.REGISTER_OUT);
    }

    public static ParameterKeyValue createRegisterOut(String name, Object value) {
        String displayValue = registerOutParameterValueConverter.getDisplayValue(value);
        return new ParameterKeyValue(name, value, displayValue, ParameterKeyValue.OperationType.REGISTER_OUT);
    }

    public static ParameterKeyValue createRegisterOut(ParameterKey key, Object value) {
        String displayValue = registerOutParameterValueConverter.getDisplayValue(value);
        return new ParameterKeyValue(key, value, displayValue, ParameterKeyValue.OperationType.REGISTER_OUT);
    }

    public static SortedSet<ParameterKeyValue> filterBy(SortedSet<ParameterKeyValue> parameters, ParameterKeyValue.OperationType ... operationTypes) {
        TreeSet<ParameterKeyValue> result = new TreeSet<ParameterKeyValue>();
        for (ParameterKeyValue keyValue : parameters) {
            if (!Arrays.asList(operationTypes).contains((Object)keyValue.getType())) continue;
            result.add(keyValue);
        }
        return result;
    }

    public static SortedSet<ParameterKeyValue> filterByKeyType(SortedSet<ParameterKeyValue> parameters, ParameterKey.ParameterKeyType keyType) {
        TreeSet<ParameterKeyValue> result = new TreeSet<ParameterKeyValue>();
        for (ParameterKeyValue keyValue : parameters) {
            if (keyValue.getKey().getType() != keyType) continue;
            result.add(keyValue);
        }
        return result;
    }

    public static SortedSet<ParameterKey> toParamKeys(SortedSet<ParameterKeyValue> parameters) {
        TreeSet<ParameterKey> result = new TreeSet<ParameterKey>();
        for (ParameterKeyValue keyValue : parameters) {
            result.add(keyValue.getKey());
        }
        return result;
    }

    public static <T> Map<ParameterKey, T> toKeyValueMap(SortedSet<ParameterKeyValue> keyValues) {
        LinkedHashMap<ParameterKey, Object> result = new LinkedHashMap<ParameterKey, Object>();
        for (ParameterKeyValue keyValue : keyValues) {
            result.put(keyValue.getKey(), keyValue.getValue());
        }
        return result;
    }

    public static <T> Map<Integer, T> toKeyIndexMap(SortedSet<ParameterKeyValue> keyValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (ParameterKeyValue keyValue : keyValues) {
            result.put(keyValue.getKey().getIndex(), keyValue.getValue());
        }
        return result;
    }

    public static <T> Map<String, T> toKeyNameMap(SortedSet<ParameterKeyValue> keyValues) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (ParameterKeyValue keyValue : keyValues) {
            result.put(keyValue.getKey().getName(), keyValue.getValue());
        }
        return result;
    }

    public static Map<ParameterKey, ParameterKeyValue> toParamKeyMap(SortedSet<ParameterKeyValue> keyValues) {
        LinkedHashMap<ParameterKey, ParameterKeyValue> result = new LinkedHashMap<ParameterKey, ParameterKeyValue>();
        for (ParameterKeyValue keyValue : keyValues) {
            result.put(keyValue.getKey(), keyValue);
        }
        return result;
    }
}

