/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.asserts.CallableBatchExecution;
import net.ttddyy.dsproxy.asserts.CallableExecution;
import net.ttddyy.dsproxy.asserts.PreparedBatchExecution;
import net.ttddyy.dsproxy.asserts.PreparedExecution;
import net.ttddyy.dsproxy.asserts.QueryExecution;
import net.ttddyy.dsproxy.asserts.QueryExecutionFactoryListener;
import net.ttddyy.dsproxy.asserts.StatementBatchExecution;
import net.ttddyy.dsproxy.asserts.StatementExecution;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.support.ProxyDataSource;

public class ProxyTestDataSource
extends ProxyDataSource {
    private QueryExecutionFactoryListener queryExecutionFactoryListener = new QueryExecutionFactoryListener();

    public ProxyTestDataSource() {
        this.initialize();
    }

    public ProxyTestDataSource(DataSource dataSource) {
        super(dataSource);
        this.initialize();
    }

    private void initialize() {
        this.getProxyConfig().getQueryListener().addListener((QueryExecutionListener)this.queryExecutionFactoryListener);
    }

    public void reset() {
        this.queryExecutionFactoryListener.reset();
    }

    public List<StatementExecution> getStatements() {
        return this.getQueryExecutionsFilteredBy(StatementExecution.class);
    }

    public StatementExecution getFirstStatement() {
        return this.getFirstQueryExecution(StatementExecution.class);
    }

    public StatementExecution getLastStatement() {
        return this.getLastQueryExecution(StatementExecution.class);
    }

    public List<StatementBatchExecution> getBatchStatements() {
        return this.getQueryExecutionsFilteredBy(StatementBatchExecution.class);
    }

    public StatementBatchExecution getFirstBatchStatement() {
        return this.getFirstQueryExecution(StatementBatchExecution.class);
    }

    public StatementBatchExecution getLastBatchStatement() {
        return this.getLastQueryExecution(StatementBatchExecution.class);
    }

    public List<PreparedExecution> getPrepareds() {
        return this.getQueryExecutionsFilteredBy(PreparedExecution.class);
    }

    public PreparedExecution getFirstPrepared() {
        return this.getFirstQueryExecution(PreparedExecution.class);
    }

    public PreparedExecution getLastPrepared() {
        return this.getLastQueryExecution(PreparedExecution.class);
    }

    public List<PreparedBatchExecution> getBatchPrepareds() {
        return this.getQueryExecutionsFilteredBy(PreparedBatchExecution.class);
    }

    public PreparedBatchExecution getFirstBatchPrepared() {
        return this.getFirstQueryExecution(PreparedBatchExecution.class);
    }

    public PreparedBatchExecution getLastBatchPrepared() {
        return this.getLastQueryExecution(PreparedBatchExecution.class);
    }

    public List<CallableExecution> getCallables() {
        return this.getQueryExecutionsFilteredBy(CallableExecution.class);
    }

    public CallableExecution getFirstCallable() {
        return this.getFirstQueryExecution(CallableExecution.class);
    }

    public CallableExecution getLastCallable() {
        return this.getLastQueryExecution(CallableExecution.class);
    }

    public List<CallableBatchExecution> getBatchCallables() {
        return this.getQueryExecutionsFilteredBy(CallableBatchExecution.class);
    }

    public CallableBatchExecution getFirstBatchCallable() {
        return this.getFirstQueryExecution(CallableBatchExecution.class);
    }

    public CallableBatchExecution getLastBatchCallable() {
        return this.getLastQueryExecution(CallableBatchExecution.class);
    }

    private <T extends QueryExecution> List<T> getQueryExecutionsFilteredBy(Class<T> classToFilter) {
        ArrayList<QueryExecution> result = new ArrayList<QueryExecution>();
        for (QueryExecution queryExecution : this.getQueryExecutions()) {
            if (!classToFilter.isAssignableFrom(queryExecution.getClass())) continue;
            result.add(queryExecution);
        }
        return result;
    }

    private <T extends QueryExecution> T getFirstQueryExecution(Class<T> classToFilter) {
        List<T> filtered = this.getQueryExecutionsFilteredBy(classToFilter);
        if (filtered.isEmpty()) {
            return null;
        }
        return (T)((QueryExecution)filtered.get(0));
    }

    private <T extends QueryExecution> T getLastQueryExecution(Class<T> classToFilter) {
        List<T> filtered = this.getQueryExecutionsFilteredBy(classToFilter);
        if (filtered.isEmpty()) {
            return null;
        }
        return (T)((QueryExecution)filtered.get(filtered.size() - 1));
    }

    public List<QueryExecution> getQueryExecutions() {
        return this.queryExecutionFactoryListener.getQueryExecutions();
    }

    public QueryExecutionFactoryListener getQueryExecutionFactoryListener() {
        return this.queryExecutionFactoryListener;
    }
}

