/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts;

import java.util.ArrayList;
import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.asserts.BaseQueryExecution;
import net.ttddyy.dsproxy.asserts.CallableBatchExecution;
import net.ttddyy.dsproxy.asserts.CallableBatchExecutionEntry;
import net.ttddyy.dsproxy.asserts.CallableExecution;
import net.ttddyy.dsproxy.asserts.DataSourceAssertException;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterKeyValue;
import net.ttddyy.dsproxy.asserts.ParameterKeyValueUtils;
import net.ttddyy.dsproxy.asserts.PreparedBatchExecution;
import net.ttddyy.dsproxy.asserts.PreparedBatchExecutionEntry;
import net.ttddyy.dsproxy.asserts.PreparedExecution;
import net.ttddyy.dsproxy.asserts.QueryExecution;
import net.ttddyy.dsproxy.asserts.StatementBatchExecution;
import net.ttddyy.dsproxy.asserts.StatementExecution;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.ParameterKey;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;

public class QueryExecutionFactoryListener
implements QueryExecutionListener {
    private List<QueryExecution> queryExecutions = new ArrayList<QueryExecution>();

    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        StatementType statementType = execInfo.getStatementType();
        boolean isBatch = execInfo.isBatch();
        BaseQueryExecution queryExecution = null;
        switch (statementType) {
            case STATEMENT: {
                if (isBatch) {
                    queryExecution = this.createStatementBatchExecution(queryInfoList);
                    break;
                }
                queryExecution = this.createStatementExecution(queryInfoList);
                break;
            }
            case PREPARED: {
                if (isBatch) {
                    queryExecution = this.createPreparedBatchExecution(queryInfoList);
                    break;
                }
                queryExecution = this.createPreparedExecution(queryInfoList);
                break;
            }
            case CALLABLE: {
                queryExecution = isBatch ? this.createCallableBatchExecution(queryInfoList) : this.createCallableExecution(queryInfoList);
            }
        }
        queryExecution.setSuccess(execInfo.isSuccess());
        this.queryExecutions.add(queryExecution);
    }

    private StatementExecution createStatementExecution(List<QueryInfo> queryInfoList) {
        String query = queryInfoList.get(0).getQuery();
        StatementExecution se = new StatementExecution();
        se.setQuery(query);
        return se;
    }

    private StatementBatchExecution createStatementBatchExecution(List<QueryInfo> queryInfoList) {
        StatementBatchExecution sbe = new StatementBatchExecution();
        for (QueryInfo queryInfo : queryInfoList) {
            sbe.getQueries().add(queryInfo.getQuery());
        }
        return sbe;
    }

    private PreparedExecution createPreparedExecution(List<QueryInfo> queryInfoList) {
        String query = queryInfoList.get(0).getQuery();
        PreparedExecution pe = new PreparedExecution();
        pe.setQuery(query);
        if (queryInfoList.size() != 1) {
            throw new DataSourceAssertException("queryInfoList size for PreparedStatement must be 1 but was " + queryInfoList.size());
        }
        QueryInfo queryInfo = queryInfoList.get(0);
        if (queryInfo.getParametersList().size() != 1) {
            throw new DataSourceAssertException("parametersList size for PreparedStatement must be 1 but was " + queryInfo.getParametersList().size());
        }
        List params = (List)queryInfo.getParametersList().get(0);
        this.populateParameterSetOperations(pe, params);
        return pe;
    }

    private PreparedBatchExecution createPreparedBatchExecution(List<QueryInfo> queryInfoList) {
        String query = queryInfoList.get(0).getQuery();
        PreparedBatchExecution pbe = new PreparedBatchExecution();
        pbe.setQuery(query);
        if (queryInfoList.size() != 1) {
            throw new DataSourceAssertException("queryInfoList size for batch PreparedStatement must be 1 but was " + queryInfoList.size());
        }
        QueryInfo queryInfo = queryInfoList.get(0);
        for (List params : queryInfo.getParametersList()) {
            PreparedBatchExecutionEntry batchEntry = new PreparedBatchExecutionEntry();
            this.populateParameterSetOperations(batchEntry, params);
            pbe.addBatchExecutionEntry(batchEntry);
        }
        return pbe;
    }

    private CallableExecution createCallableExecution(List<QueryInfo> queryInfoList) {
        String query = queryInfoList.get(0).getQuery();
        CallableExecution ce = new CallableExecution();
        ce.setQuery(query);
        if (queryInfoList.size() != 1) {
            throw new DataSourceAssertException("queryInfoList size for CallableStatement must be 1 but was " + queryInfoList.size());
        }
        QueryInfo queryInfo = queryInfoList.get(0);
        if (queryInfo.getParametersList().size() != 1) {
            throw new DataSourceAssertException("parametersList size for CallableStatement must be 1 but was " + queryInfo.getParametersList().size());
        }
        List params = (List)queryInfo.getParametersList().get(0);
        this.populateParameterSetOperations(ce, params);
        return ce;
    }

    private CallableBatchExecution createCallableBatchExecution(List<QueryInfo> queryInfoList) {
        String query = queryInfoList.get(0).getQuery();
        CallableBatchExecution cbe = new CallableBatchExecution();
        cbe.setQuery(query);
        if (queryInfoList.size() != 1) {
            throw new DataSourceAssertException("queryInfoList size for batch CallableStatement must be 1 but was " + queryInfoList.size());
        }
        QueryInfo queryInfo = queryInfoList.get(0);
        for (List params : queryInfo.getParametersList()) {
            CallableBatchExecutionEntry batchEntry = new CallableBatchExecutionEntry();
            this.populateParameterSetOperations(batchEntry, params);
            cbe.addBatchExecutionEntry(batchEntry);
        }
        return cbe;
    }

    private void populateParameterSetOperations(ParameterHolder holder, List<ParameterSetOperation> params) {
        for (ParameterSetOperation param : params) {
            this.populateParameterSetOperation(holder, param);
        }
    }

    private void populateParameterSetOperation(ParameterHolder holder, ParameterSetOperation setOperation) {
        ParameterKeyValue keyValue;
        Object[] args = setOperation.getArgs();
        Object key = args[0];
        Object value = args[1];
        if (ParameterSetOperation.isSetNullParameterOperation((ParameterSetOperation)setOperation)) {
            ParameterKey parameterKey = this.getParameterKey(key);
            keyValue = ParameterKeyValueUtils.createSetNull(parameterKey, (int)((Integer)value));
        } else if (ParameterSetOperation.isRegisterOutParameterOperation((ParameterSetOperation)setOperation)) {
            ParameterKey parameterKey = this.getParameterKey(key);
            keyValue = ParameterKeyValueUtils.createRegisterOut(parameterKey, value);
        } else {
            ParameterKey parameterKey = this.getParameterKey(key);
            keyValue = ParameterKeyValueUtils.createSetParam(parameterKey, value);
        }
        holder.getAllParameters().add(keyValue);
    }

    private ParameterKey getParameterKey(Object key) {
        if (key instanceof Integer) {
            return new ParameterKey(((Integer)key).intValue());
        }
        return new ParameterKey((String)key);
    }

    public List<QueryExecution> getQueryExecutions() {
        return this.queryExecutions;
    }

    public void reset() {
        this.queryExecutions.clear();
    }
}

