/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj;

import net.ttddyy.dsproxy.asserts.BatchParameterHolder;
import net.ttddyy.dsproxy.asserts.CallableBatchExecution;
import net.ttddyy.dsproxy.asserts.CallableBatchExecutionEntry;
import net.ttddyy.dsproxy.asserts.assertj.AbstractExecutionAssert;
import net.ttddyy.dsproxy.asserts.assertj.data.ExecutionParameters;
import net.ttddyy.dsproxy.asserts.assertj.helper.BatchExecutionEntryAsserts;
import net.ttddyy.dsproxy.asserts.assertj.helper.ExecutionParameterAsserts;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;

public class CallableBatchExecutionAssert
extends AbstractExecutionAssert<CallableBatchExecutionAssert, CallableBatchExecution> {
    private BatchExecutionEntryAsserts batchAssert;
    private ExecutionParameterAsserts parameterAssert;

    public CallableBatchExecutionAssert(CallableBatchExecution actual) {
        super(actual, CallableBatchExecutionAssert.class);
        this.batchAssert = new BatchExecutionEntryAsserts(this.info);
        this.parameterAssert = new ExecutionParameterAsserts(this.info);
    }

    public CallableBatchExecutionAssert isSuccess() {
        this.isExecutionSuccess();
        return this;
    }

    public CallableBatchExecutionAssert isFailure() {
        this.isExecutionFailure();
        return this;
    }

    public CallableBatchExecutionAssert hasBatchSize(int batchSize) {
        this.batchAssert.assertBatchSize((BatchParameterHolder)this.actual, batchSize, "callable");
        return this;
    }

    public CallableBatchExecutionAssert batch(int batchIndex, ExecutionParameters params) {
        this.batchAssert.assertBatchExecutionEntry((BatchParameterHolder)this.actual, batchIndex, CallableBatchExecutionEntry.class);
        CallableBatchExecutionEntry batchEntry = (CallableBatchExecutionEntry)((CallableBatchExecution)this.actual).getBatchExecutionEntries().get(batchIndex);
        this.parameterAssert.assertParameterKeys(batchEntry, params, true);
        if (ExecutionParameters.ExecutionParametersType.CONTAINS_KEYS_ONLY == params.getType()) {
            return this;
        }
        this.parameterAssert.assertExecutionParameters(batchEntry, params);
        return this;
    }

    public AbstractCharSequenceAssert<?, String> query() {
        return Assertions.assertThat((String)((CallableBatchExecution)this.actual).getQuery());
    }
}

