/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterKeyValue;
import net.ttddyy.dsproxy.asserts.ParameterKeyValueUtils;
import net.ttddyy.dsproxy.asserts.PreparedExecution;
import net.ttddyy.dsproxy.asserts.assertj.AbstractExecutionAssert;
import net.ttddyy.dsproxy.asserts.assertj.data.ExecutionParameter;
import net.ttddyy.dsproxy.asserts.assertj.data.ExecutionParameters;
import net.ttddyy.dsproxy.asserts.assertj.helper.ExecutionParameterAsserts;
import net.ttddyy.dsproxy.proxy.ParameterKey;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;

public class PreparedExecutionAssert
extends AbstractExecutionAssert<PreparedExecutionAssert, PreparedExecution> {
    private ExecutionParameterAsserts parameterAsserts;

    public PreparedExecutionAssert(PreparedExecution actual) {
        super(actual, PreparedExecutionAssert.class);
        this.parameterAsserts = new ExecutionParameterAsserts(this.info);
    }

    public PreparedExecutionAssert isSuccess() {
        this.isExecutionSuccess();
        return this;
    }

    public PreparedExecutionAssert isFailure() {
        this.isExecutionFailure();
        return this;
    }

    public PreparedExecutionAssert containsParam(int paramIndex, Object value) {
        this.containsParams(ExecutionParameter.param(paramIndex, value));
        return this;
    }

    public PreparedExecutionAssert containsNullParam(int index, int sqlType) {
        this.containsParams(ExecutionParameter.nullParam(index, sqlType));
        return this;
    }

    public PreparedExecutionAssert containsNullParam(int index) {
        this.containsParams(ExecutionParameter.nullParam(index));
        return this;
    }

    public PreparedExecutionAssert containsParams(ExecutionParameter ... params) {
        ExecutionParameters executionParameters = ExecutionParameters.containsParams(params);
        this.parameterAsserts.assertParameterKeys((ParameterHolder)this.actual, executionParameters, false);
        this.parameterAsserts.assertExecutionParameters((ParameterHolder)this.actual, executionParameters);
        return this;
    }

    public PreparedExecutionAssert containsParamIndex(int paramIndex) {
        this.containsParamIndexes(paramIndex);
        return this;
    }

    public PreparedExecutionAssert containsParamIndexes(int ... paramIndexes) {
        ExecutionParameters executionParameters = ExecutionParameters.containsParamIndexes(paramIndexes);
        this.parameterAsserts.assertParameterKeys((ParameterHolder)this.actual, executionParameters, false);
        return this;
    }

    public PreparedExecutionAssert containsParamValuesExactly(Object ... paramValues) {
        SortedSet<ParameterKeyValue> actualKeyValues = ((PreparedExecution)this.actual).getAllParameters();
        if (!this.isContainsParamValuesExactly(actualKeyValues, paramValues)) {
            String failureMessage = this.getFailureMessageForValuesExactly(actualKeyValues, paramValues);
            this.failWithMessage(failureMessage, new Object[0]);
        }
        return this;
    }

    private boolean isContainsParamValuesExactly(SortedSet<ParameterKeyValue> actualAsSet, Object[] expected) {
        ParameterKeyValue[] actual = actualAsSet.toArray(new ParameterKeyValue[actualAsSet.size()]);
        if (actual.length != expected.length) {
            return false;
        }
        for (int i = 0; i < actual.length; ++i) {
            Object expectedValue;
            ParameterKeyValue actualKeyValue = actual[i];
            Object actualValue = actualKeyValue.isSetNull() ? null : actualKeyValue.getValue();
            if (actualValue == (expectedValue = expected[i]) || actualValue != null && actualValue.equals(expectedValue)) continue;
            return false;
        }
        return true;
    }

    private String getFailureMessageForValuesExactly(SortedSet<ParameterKeyValue> actualKeyValues, Object[] expected) {
        LinkedHashMap<ParameterKey, Object> expectedParamAndValue = new LinkedHashMap<ParameterKey, Object>();
        for (int i = 0; i < expected.length; ++i) {
            expectedParamAndValue.put(new ParameterKey(i + 1), expected[i]);
        }
        String actualMessage = this.getActualKeyValueToDisplay(actualKeyValues);
        String expectedMessage = this.getExpectedKeyValueToDisplay(expectedParamAndValue);
        String missingMessage = this.getMissingToDisplay(actualKeyValues, expectedParamAndValue);
        String extraMessage = this.getExtraToDisplay(actualKeyValues, expectedParamAndValue);
        return String.format("%nExpecting: prepared parameter values%n<%s>%nto be exactly:%n<%s>%nbut missing:%n<%s>%nextra:%n<%s>", actualMessage, expectedMessage, missingMessage, extraMessage);
    }

    private String getActualKeyValueToDisplay(SortedSet<ParameterKeyValue> keyValues) {
        LinkedHashMap<Integer, String> actualValueMapToDisplay = new LinkedHashMap<Integer, String>();
        for (ParameterKeyValue keyValue : keyValues) {
            int index = keyValue.getKey().getIndex();
            actualValueMapToDisplay.put(index, keyValue.getDisplayValue());
        }
        return ((Object)actualValueMapToDisplay).toString();
    }

    private String getExpectedKeyValueToDisplay(Map<ParameterKey, Object> expectedParamValues) {
        LinkedHashMap<Integer, Object> toDisplay = new LinkedHashMap<Integer, Object>();
        for (Map.Entry<ParameterKey, Object> entry : expectedParamValues.entrySet()) {
            toDisplay.put(entry.getKey().getIndex(), entry.getValue() == null ? "NULL" : entry.getValue());
        }
        return ((Object)toDisplay).toString();
    }

    private String getMissingToDisplay(SortedSet<ParameterKeyValue> actual, Map<ParameterKey, Object> expected) {
        LinkedHashMap<Integer, Object> missing = new LinkedHashMap<Integer, Object>();
        Map<ParameterKey, ParameterKeyValue> actualParamKeyMap = ParameterKeyValueUtils.toParamKeyMap(new TreeSet<ParameterKeyValue>(actual));
        for (Map.Entry<ParameterKey, Object> entry : expected.entrySet()) {
            int index = entry.getKey().getIndex();
            Object expectedValue = entry.getValue();
            ParameterKeyValue actualKeyValue = actualParamKeyMap.get(entry.getKey());
            if (actualKeyValue == null) {
                if (expectedValue == null) {
                    missing.put(index, "NULL");
                    continue;
                }
                missing.put(index, expectedValue);
                continue;
            }
            if (expectedValue == null) {
                if (actualKeyValue.isSetNull()) continue;
                missing.put(index, "NULL");
                continue;
            }
            if (expectedValue.equals(actualKeyValue.getValue())) continue;
            missing.put(index, expectedValue);
        }
        return ((Object)missing).toString();
    }

    private String getExtraToDisplay(SortedSet<ParameterKeyValue> actual, Map<ParameterKey, Object> expected) {
        LinkedHashMap<Integer, String> extra = new LinkedHashMap<Integer, String>();
        for (ParameterKeyValue actualKeyValue : actual) {
            ParameterKey actualKey = actualKeyValue.getKey();
            if (expected.containsKey(actualKey)) continue;
            extra.put(actualKey.getIndex(), actualKeyValue.getDisplayValue());
        }
        return ((Object)extra).toString();
    }

    public AbstractCharSequenceAssert<?, String> query() {
        return Assertions.assertThat((String)((PreparedExecution)this.actual).getQuery());
    }
}

