/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj;

import java.util.ArrayList;
import java.util.List;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.asserts.BaseQueryExecution;
import net.ttddyy.dsproxy.asserts.DefaultQueryExtractor;
import net.ttddyy.dsproxy.asserts.ProxyTestDataSource;
import net.ttddyy.dsproxy.asserts.QueryExecution;
import net.ttddyy.dsproxy.asserts.QueryExtractor;
import net.ttddyy.dsproxy.asserts.hamcrest.ExecutionType;
import net.ttddyy.dsproxy.listener.QueryUtils;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class ProxyTestDataSourceAssert
extends AbstractAssert<ProxyTestDataSourceAssert, ProxyTestDataSource> {
    private static final int QUERY_LENGTH_TO_SHOW = 12;
    private QueryExtractor queryExtractor = new DefaultQueryExtractor();
    @VisibleForTesting
    protected Objects objects = Objects.instance();

    public ProxyTestDataSourceAssert(ProxyTestDataSource actual) {
        super((Object)actual, ProxyTestDataSourceAssert.class);
    }

    public ProxyTestDataSourceAssert hasExecutionType(ExecutionType executionType, Index index) {
        this.isNotNull();
        List<QueryExecution> queryExecutions = ((ProxyTestDataSource)((Object)this.actual)).getQueryExecutions();
        if (queryExecutions.size() <= index.value) {
            this.failWithMessage("Expecting: index <%s> is less than the size of query executions <%s>", new Object[]{index.value, queryExecutions.size()});
        }
        QueryExecution queryExecution = queryExecutions.get(index.value);
        Class[] expectedExecutionTypes = executionType.getExecutionTypes();
        this.objects.assertIsInstanceOfAny((AssertionInfo)this.info, (Object)queryExecution, expectedExecutionTypes);
        return this;
    }

    public ProxyTestDataSourceAssert hasExecutionCount(int count) {
        this.checkExecutionCount(count, "executions", ((ProxyTestDataSource)((Object)this.actual)).getQueryExecutions());
        return this;
    }

    public ProxyTestDataSourceAssert hasStatementCount(int count) {
        this.checkExecutionCount(count, "statement executions", ((ProxyTestDataSource)((Object)this.actual)).getStatements());
        return this;
    }

    public ProxyTestDataSourceAssert hasBatchStatementCount(int count) {
        this.checkExecutionCount(count, "batch statement executions", ((ProxyTestDataSource)((Object)this.actual)).getBatchStatements());
        return this;
    }

    public ProxyTestDataSourceAssert hasStatementOrBatchStatementCount(int count) {
        ArrayList<BaseQueryExecution> executions = new ArrayList<BaseQueryExecution>();
        executions.addAll(((ProxyTestDataSource)((Object)this.actual)).getStatements());
        executions.addAll(((ProxyTestDataSource)((Object)this.actual)).getBatchStatements());
        this.checkExecutionCount(count, "statement or batch statement executions", executions);
        return this;
    }

    public ProxyTestDataSourceAssert hasPreparedCount(int count) {
        this.checkExecutionCount(count, "prepared executions", ((ProxyTestDataSource)((Object)this.actual)).getPrepareds());
        return this;
    }

    public ProxyTestDataSourceAssert hasBatchPreparedCount(int count) {
        this.checkExecutionCount(count, "batch prepared executions", ((ProxyTestDataSource)((Object)this.actual)).getBatchPrepareds());
        return this;
    }

    public ProxyTestDataSourceAssert hasPreparedOrBatchPreparedCount(int count) {
        ArrayList<BaseQueryExecution> executions = new ArrayList<BaseQueryExecution>();
        executions.addAll(((ProxyTestDataSource)((Object)this.actual)).getPrepareds());
        executions.addAll(((ProxyTestDataSource)((Object)this.actual)).getBatchPrepareds());
        this.checkExecutionCount(count, "prepared or batch prepared executions", executions);
        return this;
    }

    public ProxyTestDataSourceAssert hasCallableCount(int count) {
        this.checkExecutionCount(count, "callable executions", ((ProxyTestDataSource)((Object)this.actual)).getCallables());
        return this;
    }

    public ProxyTestDataSourceAssert hasBatchCallableCount(int count) {
        this.checkExecutionCount(count, "batch callable executions", ((ProxyTestDataSource)((Object)this.actual)).getBatchCallables());
        return this;
    }

    public ProxyTestDataSourceAssert hasCallableOrBatchCallableCount(int count) {
        ArrayList<BaseQueryExecution> executions = new ArrayList<BaseQueryExecution>();
        executions.addAll(((ProxyTestDataSource)((Object)this.actual)).getCallables());
        executions.addAll(((ProxyTestDataSource)((Object)this.actual)).getBatchCallables());
        this.checkExecutionCount(count, "callable or batch callable executions", executions);
        return this;
    }

    private void checkExecutionCount(int expectedCount, String executionType, List<? extends QueryExecution> executions) {
        this.isNotNull();
        if (executions == null) {
            this.failWithMessage("executions is %s null", new Object[0]);
        } else if (executions.size() != expectedCount) {
            this.failWithMessage("Expected %s size: <%d> but was <%d>", new Object[]{executionType, expectedCount, executions.size()});
        }
    }

    public ProxyTestDataSourceAssert hasTotalQueryCount(int count) {
        this.checkQueryCount(null, count);
        return this;
    }

    public ProxyTestDataSourceAssert hasSelectCount(int count) {
        this.checkQueryCount(QueryType.SELECT, count);
        return this;
    }

    public ProxyTestDataSourceAssert hasInsertCount(int count) {
        this.checkQueryCount(QueryType.INSERT, count);
        return this;
    }

    public ProxyTestDataSourceAssert hasUpdateCount(int count) {
        this.checkQueryCount(QueryType.UPDATE, count);
        return this;
    }

    public ProxyTestDataSourceAssert hasDeleteCount(int count) {
        this.checkQueryCount(QueryType.DELETE, count);
        return this;
    }

    public ProxyTestDataSourceAssert hasOtherCount(int count) {
        this.checkQueryCount(QueryType.OTHER, count);
        return this;
    }

    private void checkQueryCount(QueryType expectedType, int expectedCount) {
        this.isNotNull();
        boolean isTotal = expectedType == null;
        ArrayList<String> allQueries = new ArrayList<String>();
        int actualCount = 0;
        for (QueryExecution queryExecution : ((ProxyTestDataSource)((Object)this.actual)).getQueryExecutions()) {
            List<String> queries = this.queryExtractor.getQueries(queryExecution);
            for (String query : queries) {
                QueryType queryType = QueryUtils.getQueryType((String)query);
                if (isTotal || expectedType.equals((Object)queryType)) {
                    ++actualCount;
                }
                if ((query = query.trim()).length() > 12) {
                    query = query.substring(0, 12) + "...";
                }
                allQueries.add(query);
            }
        }
        if (expectedCount != actualCount) {
            if (expectedType == null) {
                this.failWithMessage("Expected query count: <%d> but was <%d>: %s", new Object[]{expectedCount, actualCount, allQueries});
            } else {
                this.failWithMessage("Expected %s count: <%d> but was <%d>: %s", new Object[]{expectedType, expectedCount, actualCount, allQueries});
            }
        }
    }
}

