/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj;

import java.util.List;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.asserts.StatementBatchExecution;
import net.ttddyy.dsproxy.asserts.assertj.AbstractExecutionAssert;
import net.ttddyy.dsproxy.listener.QueryUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.Index;

public class StatementBatchExecutionAssert
extends AbstractExecutionAssert<StatementBatchExecutionAssert, StatementBatchExecution> {
    public StatementBatchExecutionAssert(StatementBatchExecution actual) {
        super(actual, StatementBatchExecutionAssert.class);
    }

    public StatementBatchExecutionAssert isSuccess() {
        this.isExecutionSuccess();
        return this;
    }

    public StatementBatchExecutionAssert isFailure() {
        this.isExecutionFailure();
        return this;
    }

    public StatementBatchExecutionAssert hasBatchSize(int batchSize) {
        int actualSize = ((StatementBatchExecution)this.actual).getQueries().size();
        if (actualSize != batchSize) {
            this.failWithMessage("%nExpected batch size:<%s> but was:<%s> in batch statement executions%n", new Object[]{batchSize, actualSize});
        }
        return this;
    }

    public AbstractListAssert<?, ? extends List<? extends String>, String, ObjectAssert<String>> queries() {
        return Assertions.assertThat(((StatementBatchExecution)this.actual).getQueries());
    }

    public AbstractCharSequenceAssert<?, String> query(Index index) {
        return this.query(index.value);
    }

    public AbstractCharSequenceAssert<?, String> query(int index) {
        String query = ((StatementBatchExecution)this.actual).getQueries().get(index);
        return Assertions.assertThat((String)query);
    }

    public StatementBatchExecutionAssert contains(QueryType queryType, Index index) {
        return this.contains(queryType, index.value);
    }

    public StatementBatchExecutionAssert contains(QueryType queryType, int index) {
        String query = ((StatementBatchExecution)this.actual).getQueries().get(index);
        QueryType actualType = QueryUtils.getQueryType((String)query);
        if (actualType != queryType) {
            this.failWithMessage("%nExpected query type:<%s> but was:<%s> at index:<%d>%n", new Object[]{queryType, actualType, index});
        }
        return this;
    }

    public StatementBatchExecutionAssert hasSelectCount(int count) {
        return this.hasQueryCount(QueryType.SELECT, count);
    }

    public StatementBatchExecutionAssert hasInsertCount(int count) {
        return this.hasQueryCount(QueryType.INSERT, count);
    }

    public StatementBatchExecutionAssert hasUpdateCount(int count) {
        return this.hasQueryCount(QueryType.UPDATE, count);
    }

    public StatementBatchExecutionAssert hasDeleteCount(int count) {
        return this.hasQueryCount(QueryType.DELETE, count);
    }

    public StatementBatchExecutionAssert hasOtherCount(int count) {
        return this.hasQueryCount(QueryType.OTHER, count);
    }

    public StatementBatchExecutionAssert hasQueryCount(QueryType queryType, int count) {
        int matchedCount = 0;
        int selectCount = 0;
        int insertCount = 0;
        int updateCount = 0;
        int deleteCount = 0;
        int otherCount = 0;
        for (String query : ((StatementBatchExecution)this.actual).getQueries()) {
            QueryType actualQueryType = QueryUtils.getQueryType((String)query);
            switch (actualQueryType) {
                case SELECT: {
                    ++selectCount;
                    break;
                }
                case INSERT: {
                    ++insertCount;
                    break;
                }
                case UPDATE: {
                    ++updateCount;
                    break;
                }
                case DELETE: {
                    ++deleteCount;
                    break;
                }
                case OTHER: {
                    ++otherCount;
                }
            }
            if (!queryType.equals((Object)actualQueryType)) continue;
            ++matchedCount;
        }
        if (matchedCount != count) {
            String summary = String.format("select=%d, insert=%d, update=%d, delete=%d, other=%d", selectCount, insertCount, updateCount, deleteCount, otherCount);
            this.failWithMessage("%nExpected %s count:<%d> but was:<%d> in:%n<%s>", new Object[]{queryType, count, matchedCount, summary});
        }
        return this;
    }
}

