/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ttddyy.dsproxy.asserts.assertj.data.ExecutionParameter;
import net.ttddyy.dsproxy.proxy.ParameterKey;

public class ExecutionParameters {
    private List<ExecutionParameter> parameters = new ArrayList<ExecutionParameter>();
    private ExecutionParametersType type;

    public static ExecutionParameters containsParams(ExecutionParameter ... params) {
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.type = ExecutionParametersType.CONTAINS;
        executionParameters.parameters.addAll(Arrays.asList(params));
        return executionParameters;
    }

    public static ExecutionParameters containsParamsExactly(ExecutionParameter ... params) {
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.type = ExecutionParametersType.CONTAINS_EXACTLY;
        executionParameters.parameters.addAll(Arrays.asList(params));
        return executionParameters;
    }

    public static ExecutionParameters containsParamKeys(Object ... paramKeys) {
        ArrayList<ExecutionParameter.ParamKeyOnlyExecution> params = new ArrayList<ExecutionParameter.ParamKeyOnlyExecution>();
        for (Object rawParamKey : paramKeys) {
            ExecutionParameter.ParamKeyOnlyExecution param;
            if (rawParamKey instanceof Integer) {
                param = new ExecutionParameter.ParamKeyOnlyExecution(new ParameterKey(((Integer)rawParamKey).intValue()));
            } else if (rawParamKey instanceof String) {
                param = new ExecutionParameter.ParamKeyOnlyExecution(new ParameterKey((String)rawParamKey));
            } else {
                throw new IllegalArgumentException("param key should be int or String");
            }
            params.add(param);
        }
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.type = ExecutionParametersType.CONTAINS_KEYS_ONLY;
        executionParameters.parameters.addAll(params);
        return executionParameters;
    }

    public static ExecutionParameters containsParamIndexes(int ... paramIndexes) {
        ArrayList<ExecutionParameter.ParamKeyOnlyExecution> params = new ArrayList<ExecutionParameter.ParamKeyOnlyExecution>();
        for (int paramIndex : paramIndexes) {
            ExecutionParameter.ParamKeyOnlyExecution param = new ExecutionParameter.ParamKeyOnlyExecution(new ParameterKey(paramIndex));
            params.add(param);
        }
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.type = ExecutionParametersType.CONTAINS_KEYS_ONLY;
        executionParameters.parameters.addAll(params);
        return executionParameters;
    }

    public static ExecutionParameters containsParamNames(String ... paramNames) {
        ArrayList<ExecutionParameter.ParamKeyOnlyExecution> params = new ArrayList<ExecutionParameter.ParamKeyOnlyExecution>();
        for (String paramName : paramNames) {
            ExecutionParameter.ParamKeyOnlyExecution param = new ExecutionParameter.ParamKeyOnlyExecution(new ParameterKey(paramName));
            params.add(param);
        }
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.type = ExecutionParametersType.CONTAINS_KEYS_ONLY;
        executionParameters.parameters.addAll(params);
        return executionParameters;
    }

    public List<ExecutionParameter> getParameters() {
        return this.parameters;
    }

    public ExecutionParametersType getType() {
        return this.type;
    }

    public static enum ExecutionParametersType {
        CONTAINS,
        CONTAINS_EXACTLY,
        CONTAINS_KEYS_ONLY;

    }
}

