/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj.helper;

import java.util.List;
import net.ttddyy.dsproxy.asserts.BatchExecutionEntry;
import net.ttddyy.dsproxy.asserts.BatchParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.assertj.helper.AbstractHelperAsserts;
import org.assertj.core.api.WritableAssertionInfo;

public class BatchExecutionEntryAsserts
extends AbstractHelperAsserts {
    public BatchExecutionEntryAsserts(WritableAssertionInfo info) {
        super(info);
    }

    public void assertBatchSize(BatchParameterHolder batchParameterHolder, int batchSize, String batchType) {
        int actualSize = batchParameterHolder.getBatchExecutionEntries().size();
        if (actualSize != batchSize) {
            this.failWithMessage("%nExpected batch size:<%s> but was:<%s> in batch %s executions%n", batchSize, actualSize, batchType);
        }
    }

    public void assertBatchExecutionEntry(BatchParameterHolder batchParameterHolder, int batchIndex, Class<? extends ParameterHolder> batchExecutionEntryClass) {
        String message;
        List<BatchExecutionEntry> batchEntries = batchParameterHolder.getBatchExecutionEntries();
        int batchSize = batchEntries.size();
        if (batchIndex < 0) {
            message = String.format("\nExpecting: batch index <%d> should be greater than equal to <0>", batchIndex);
            this.failWithMessage(message, new Object[0]);
        } else if (batchSize <= batchIndex) {
            message = String.format("\nExpecting: batch index <%d> is too big for the batch size <%d>", batchIndex, batchSize);
            this.failWithMessage(message, new Object[0]);
        }
        BatchExecutionEntry batchEntry = batchParameterHolder.getBatchExecutionEntries().get(batchIndex);
        if (!batchEntry.getClass().isAssignableFrom(batchExecutionEntryClass)) {
            this.failWithMessage("\nExpecting: batch entry\n<%s>\nbut was\n<%s>", batchExecutionEntryClass.getSimpleName(), batchEntry.getClass().getSimpleName());
        }
    }
}

