/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.assertj.helper;

import java.sql.SQLType;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.ttddyy.dsproxy.asserts.OutParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterKeyValue;
import net.ttddyy.dsproxy.asserts.ParameterKeyValueUtils;
import net.ttddyy.dsproxy.asserts.assertj.data.ExecutionParameter;
import net.ttddyy.dsproxy.asserts.assertj.data.ExecutionParameters;
import net.ttddyy.dsproxy.asserts.assertj.helper.AbstractHelperAsserts;
import net.ttddyy.dsproxy.listener.logging.RegisterOutParameterValueConverter;
import net.ttddyy.dsproxy.listener.logging.SetNullParameterValueConverter;
import net.ttddyy.dsproxy.proxy.ParameterKey;
import org.assertj.core.api.WritableAssertionInfo;

public class ExecutionParameterAsserts
extends AbstractHelperAsserts {
    private SetNullParameterValueConverter setNullValueConverter = new SetNullParameterValueConverter();
    private RegisterOutParameterValueConverter registerOutParameterValueConverter = new RegisterOutParameterValueConverter();

    public ExecutionParameterAsserts(WritableAssertionInfo info) {
        super(info);
    }

    private SortedSet<ParameterKey> getExpectedParamExecutionKeys(ExecutionParameters params, Class<?> ... classes) {
        TreeSet<ParameterKey> keys = new TreeSet<ParameterKey>();
        for (ExecutionParameter param : params.getParameters()) {
            for (Class<?> clazz : classes) {
                if (!clazz.isInstance(param)) continue;
                keys.add(param.getKey());
            }
        }
        return keys;
    }

    private void assertParameterKeysOnly(SortedSet<ParameterKey> actualAllKeys, SortedSet<ParameterKey> expectedParamKeyOnlyKeys, boolean isCallable) {
        if (actualAllKeys.containsAll(expectedParamKeyOnlyKeys)) {
            return;
        }
        TreeSet<ParameterKey> notFoundParameterKeys = new TreeSet<ParameterKey>(expectedParamKeyOnlyKeys);
        notFoundParameterKeys.removeAll(actualAllKeys);
        String actualKeys = this.getParameterKeysAsString(actualAllKeys);
        String expectedKeys = this.getParameterKeysAsString(expectedParamKeyOnlyKeys);
        String notFoundKeys = this.getParameterKeysAsString(notFoundParameterKeys);
        this.failWithMessage("%nExpecting: %s parameter keys%n<%s>%nto contain:%n<%s>%nbut could not find:%n<%s>", isCallable ? "callable" : "prepared", actualKeys, expectedKeys, notFoundKeys);
    }

    private SortedSet<ParameterKey> getParameterKeysDiff(Set<ParameterKey> left, Set<ParameterKey> right) {
        TreeSet<ParameterKey> result = new TreeSet<ParameterKey>(left);
        result.removeAll(right);
        return result;
    }

    public void assertParameterKeys(ParameterHolder parameterHolder, ExecutionParameters params, boolean isCallable) {
        boolean hasMissingKeys;
        SortedSet<ParameterKey> actualAllKeys = ParameterKeyValueUtils.toParamKeys(parameterHolder.getAllParameters());
        SortedSet<ParameterKey> expectedParamKeyOnlyKeys = this.getExpectedParamExecutionKeys(params, ExecutionParameter.ParamKeyOnlyExecution.class);
        if (!expectedParamKeyOnlyKeys.isEmpty()) {
            this.assertParameterKeysOnly(actualAllKeys, expectedParamKeyOnlyKeys, isCallable);
        }
        SortedSet<ParameterKeyValue> actualParamValues = parameterHolder.getAllParameters();
        SortedSet<ParameterKey> actualSetParamKeys = ParameterKeyValueUtils.toParamKeys(ParameterKeyValueUtils.filterBy(actualParamValues, ParameterKeyValue.OperationType.SET_PARAM));
        SortedSet<ParameterKey> actualSetNullParamKeys = ParameterKeyValueUtils.toParamKeys(ParameterKeyValueUtils.filterBy(actualParamValues, ParameterKeyValue.OperationType.SET_NULL));
        SortedSet<ParameterKey> actualOutParamKeys = ParameterKeyValueUtils.toParamKeys(ParameterKeyValueUtils.filterBy(actualParamValues, ParameterKeyValue.OperationType.REGISTER_OUT));
        SortedSet<ParameterKey> expectedSetParamKeys = this.getExpectedParamExecutionKeys(params, ExecutionParameter.SetParamExecution.class);
        SortedSet<ParameterKey> expectedSetNullParamKeys = this.getExpectedParamExecutionKeys(params, ExecutionParameter.SetNullParamExecution.class);
        SortedSet<ParameterKey> expectedOutParamKeys = this.getExpectedParamExecutionKeys(params, ExecutionParameter.RegisterOutParamExecutionWithIntType.class, ExecutionParameter.RegisterOutParamExecutionWithSQLType.class);
        TreeSet<ParameterKey> expectedAllKeys = new TreeSet<ParameterKey>();
        expectedAllKeys.addAll(expectedSetParamKeys);
        expectedAllKeys.addAll(expectedSetNullParamKeys);
        expectedAllKeys.addAll(expectedOutParamKeys);
        SortedSet<ParameterKey> missingSetParamKeys = this.getParameterKeysDiff(expectedSetParamKeys, actualSetParamKeys);
        SortedSet<ParameterKey> missingSetNullParamKeys = this.getParameterKeysDiff(expectedSetNullParamKeys, actualSetNullParamKeys);
        SortedSet<ParameterKey> missingOutParamKeys = this.getParameterKeysDiff(expectedOutParamKeys, actualOutParamKeys);
        boolean hasMissingSetParamKeys = !missingSetParamKeys.isEmpty();
        boolean hasMissingSetNullKeys = !missingSetNullParamKeys.isEmpty();
        boolean hasMissingOutKeys = !missingOutParamKeys.isEmpty();
        boolean bl = hasMissingKeys = hasMissingSetParamKeys || hasMissingSetNullKeys || hasMissingOutKeys;
        if (hasMissingKeys) {
            String actualKeys = this.getParameterKeysAsString(actualAllKeys);
            StringBuilder actualKeysDetail = new StringBuilder();
            actualKeysDetail.append("params=");
            actualKeysDetail.append(this.getParameterKeysAsString(ParameterKeyValueUtils.toParamKeys(ParameterKeyValueUtils.filterBy(actualParamValues, ParameterKeyValue.OperationType.SET_PARAM))));
            actualKeysDetail.append(", set-null=");
            actualKeysDetail.append(this.getParameterKeysAsString(ParameterKeyValueUtils.toParamKeys(ParameterKeyValueUtils.filterBy(actualParamValues, ParameterKeyValue.OperationType.SET_NULL))));
            actualKeysDetail.append(", register-out=");
            actualKeysDetail.append(this.getParameterKeysAsString(ParameterKeyValueUtils.toParamKeys(ParameterKeyValueUtils.filterBy(actualParamValues, ParameterKeyValue.OperationType.REGISTER_OUT))));
            String expectedKeys = this.getKeysAsString(hasMissingSetParamKeys, hasMissingSetNullKeys, hasMissingOutKeys, expectedSetParamKeys, expectedSetNullParamKeys, expectedOutParamKeys);
            String notFoundKeys = this.getKeysAsString(hasMissingSetParamKeys, hasMissingSetNullKeys, hasMissingOutKeys, missingSetParamKeys, missingSetNullParamKeys, missingOutParamKeys);
            this.failWithMessage("%nExpecting: %s parameter keys%n<%s>%n(%s)%nto contain:%n<%s>%nbut could not find:%n<%s>", isCallable ? "callable" : "prepared", actualKeys, actualKeysDetail, expectedKeys, notFoundKeys);
        }
        if (ExecutionParameters.ExecutionParametersType.CONTAINS_EXACTLY == params.getType()) {
            boolean isSameSize;
            boolean isParamsSameSize = actualSetParamKeys.size() == expectedSetParamKeys.size();
            boolean isSetNullParamsSameSize = actualSetNullParamKeys.size() == expectedSetNullParamKeys.size();
            boolean isOutParamsSameSize = actualOutParamKeys.size() == expectedOutParamKeys.size();
            boolean bl2 = isSameSize = isParamsSameSize && isSetNullParamsSameSize && isOutParamsSameSize;
            if (!isSameSize) {
                SortedSet<ParameterKey> extraSetParamKeys = this.getParameterKeysDiff(actualSetParamKeys, expectedSetParamKeys);
                SortedSet<ParameterKey> extraSetNullParamKeys = this.getParameterKeysDiff(actualSetNullParamKeys, expectedSetNullParamKeys);
                SortedSet<ParameterKey> extraOutParamKeys = this.getParameterKeysDiff(actualOutParamKeys, expectedOutParamKeys);
                String actualKeys = this.getParameterKeysAsString(actualAllKeys);
                String expectedKeys = this.getParameterKeysAsString(expectedAllKeys);
                StringBuilder actualKeysDetail = new StringBuilder();
                actualKeysDetail.append("params=");
                actualKeysDetail.append(this.getParameterKeysAsString(actualSetParamKeys));
                actualKeysDetail.append(", set-null=");
                actualKeysDetail.append(this.getParameterKeysAsString(actualSetNullParamKeys));
                actualKeysDetail.append(", register-out=");
                actualKeysDetail.append(this.getParameterKeysAsString(actualOutParamKeys));
                StringBuilder expectedKeysDetail = new StringBuilder();
                expectedKeysDetail.append("params=");
                expectedKeysDetail.append(this.getParameterKeysAsString(expectedSetParamKeys));
                expectedKeysDetail.append(", set-null=");
                expectedKeysDetail.append(this.getParameterKeysAsString(expectedSetNullParamKeys));
                expectedKeysDetail.append(", register-out=");
                expectedKeysDetail.append(this.getParameterKeysAsString(expectedOutParamKeys));
                boolean hasExtraParamKeys = !extraSetParamKeys.isEmpty();
                boolean hasExtraSetNullKeys = !extraSetNullParamKeys.isEmpty();
                boolean hasExtraOutKeys = !extraOutParamKeys.isEmpty();
                String missingKeys = this.getKeysAsString(hasMissingSetParamKeys, hasMissingSetNullKeys, hasMissingOutKeys, missingSetParamKeys, missingSetNullParamKeys, missingOutParamKeys);
                String extraKeys = this.getKeysAsString(hasExtraParamKeys, hasExtraSetNullKeys, hasExtraOutKeys, extraSetParamKeys, extraSetNullParamKeys, extraOutParamKeys);
                this.failWithMessage("%nExpecting: %s parameter keys%n<%s>%n(%s)%nto be exactly:%n<%s>%n(%s)%nbut missing keys:%n<%s>%nextra keys:%n<%s>", "callable", actualKeys, actualKeysDetail, expectedKeys, expectedKeysDetail, missingKeys, extraKeys);
            }
        }
    }

    private String getKeysAsString(boolean writeParamKeys, boolean writeSetNullKeys, boolean writeOutKeys, SortedSet<ParameterKey> paramKeys, SortedSet<ParameterKey> setNullKeys, SortedSet<ParameterKey> registerOutKeys) {
        StringBuilder sb = new StringBuilder();
        if (writeParamKeys) {
            sb.append("params=");
            sb.append(this.getParameterKeysAsString(paramKeys));
        }
        if (writeSetNullKeys) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("set-null=");
            sb.append(this.getParameterKeysAsString(setNullKeys));
        }
        if (writeOutKeys) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append("register-out=");
            sb.append(this.getParameterKeysAsString(registerOutKeys));
        }
        return sb.toString();
    }

    public <T extends ParameterHolder> void assertExecutionParameters(T paramHolder, ExecutionParameters params) {
        for (ExecutionParameter param : params.getParameters()) {
            this.assertExecutionParameter(paramHolder, param);
        }
    }

    public <T extends ParameterHolder> void assertExecutionParameter(T paramHolder, ExecutionParameter param) {
        ParameterKey expectedParamKey = param.getKey();
        if (param instanceof ExecutionParameter.SetParamExecution) {
            Object expectedValue = ((ExecutionParameter.SetParamExecution)param).getValue();
            this.validateSetParameter(expectedParamKey, expectedValue, paramHolder);
        } else if (param instanceof ExecutionParameter.SetNullParamExecution) {
            Integer sqlType = ((ExecutionParameter.SetNullParamExecution)param).getSqlType();
            this.validateSetNullParameter(expectedParamKey, sqlType, paramHolder);
        } else if (param instanceof ExecutionParameter.RegisterOutParamExecutionWithIntType && paramHolder instanceof OutParameterHolder) {
            int sqlType = ((ExecutionParameter.RegisterOutParamExecutionWithIntType)param).getSqlType();
            this.validateOutParamParameterWithInt(expectedParamKey, sqlType, (OutParameterHolder)paramHolder);
        } else if (param instanceof ExecutionParameter.RegisterOutParamExecutionWithSQLType && paramHolder instanceof OutParameterHolder) {
            SQLType sqlType = ((ExecutionParameter.RegisterOutParamExecutionWithSQLType)param).getSqlType();
            this.validateOutParamParameterWithSQLType(expectedParamKey, sqlType, (OutParameterHolder)paramHolder);
        } else {
            throw new IllegalStateException("wrong parameter type: " + param.getClass().getSimpleName());
        }
    }

    public <T extends ParameterHolder> void validateSetParameter(ParameterKey expectedParamKey, Object expectedValue, T executionEntry) {
        Object actualValue = ParameterKeyValueUtils.toKeyValueMap(executionEntry.getSetParams()).get(expectedParamKey);
        if (expectedValue != actualValue) {
            SortedMap<String, Object> sortedParams = this.getAllParamsForDisplay(executionEntry);
            String expectedEntry = String.format("%s=%s", expectedParamKey.getKeyAsString(), expectedValue);
            this.failWithMessage("%nExpecting: parameters %n<%s>%nto contain:%n<[%s]>%nbut could not find:%n<[%s]>", sortedParams, expectedEntry, expectedEntry);
        }
    }

    public <T extends ParameterHolder> void validateSetNullParameter(ParameterKey expectedParamKey, Integer sqlType, T executionEntry) {
        if (sqlType == null) {
            return;
        }
        Object actualValue = ParameterKeyValueUtils.toKeyValueMap(executionEntry.getSetNullParams()).get(expectedParamKey);
        if (sqlType != actualValue) {
            SortedMap<String, Object> sortedParams = this.getAllParamsForDisplay(executionEntry);
            String displayValue = this.setNullValueConverter.getDisplayValue(sqlType);
            String expectedEntry = String.format("%s=%s", expectedParamKey.getKeyAsString(), displayValue);
            this.failWithMessage("%nExpecting: parameters %n<%s>%nto contain:%n<[%s]>%nbut could not find:%n<[%s]>", sortedParams, expectedEntry, expectedEntry);
        }
    }

    private void validateOutParamParameterWithInt(ParameterKey expectedParamKey, int sqlType, OutParameterHolder executionEntry) {
        Object actualValue = ParameterKeyValueUtils.toKeyValueMap(executionEntry.getOutParams()).get(expectedParamKey);
        if (!new Integer(sqlType).equals(actualValue)) {
            SortedMap<String, Object> sortedParams = this.getAllParamsForDisplay(executionEntry);
            String displayValue = this.registerOutParameterValueConverter.getDisplayValue((Object)sqlType);
            String expectedEntry = String.format("%s=%s", expectedParamKey.getKeyAsString(), displayValue);
            this.failWithMessage("%nExpecting: parameters %n<%s>%nto contain:%n<[%s]>%nbut could not find:%n<[%s]>", sortedParams, expectedEntry, expectedEntry);
        }
    }

    private void validateOutParamParameterWithSQLType(ParameterKey expectedParamKey, SQLType sqlType, OutParameterHolder executionEntry) {
        Object actualValue = ParameterKeyValueUtils.toKeyValueMap(executionEntry.getOutParams()).get(expectedParamKey);
        if (sqlType != actualValue) {
            SortedMap<String, Object> sortedParams = this.getAllParamsForDisplay(executionEntry);
            String displayValue = this.registerOutParameterValueConverter.getDisplayValue((Object)sqlType);
            String expectedEntry = String.format("%s=%s", expectedParamKey.getKeyAsString(), displayValue);
            this.failWithMessage("%nExpecting: parameters %n<%s>%nto contain:%n<[%s]>%nbut could not find:%n<[%s]>", sortedParams, expectedEntry, expectedEntry);
        }
    }

    private <T extends ParameterHolder> SortedMap<String, Object> getAllParamsForDisplay(T entry) {
        TreeMap<String, Object> sorted = new TreeMap<String, Object>();
        for (ParameterKeyValue keyValue : entry.getAllParameters()) {
            sorted.put(keyValue.getKey().getKeyAsString(), keyValue.getDisplayValue());
        }
        return sorted;
    }

    private String getParameterKeysAsString(Set<ParameterKey> keys) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (ParameterKey key : keys) {
            sb.append(key.getKeyAsString());
            sb.append(", ");
        }
        if (!keys.isEmpty()) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }
}

