/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import java.util.List;
import net.ttddyy.dsproxy.asserts.BatchExecutionEntry;
import net.ttddyy.dsproxy.asserts.BatchParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.hamcrest.CompositeMatcher;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class BatchParameterHolderAssertions {
    BatchParameterHolderAssertions() {
    }

    public static Matcher<? super BatchParameterHolder> batchSize(int batchSize) {
        return new FeatureMatcher<BatchParameterHolder, Integer>(Matchers.equalTo((Object)batchSize), "batchSize", "batchSize"){

            protected Integer featureValueOf(BatchParameterHolder actual) {
                return actual.getBatchExecutionEntries().size();
            }
        };
    }

    public static Matcher<? super BatchParameterHolder> batch(final int index, Matcher<? super ParameterHolder> parameterHolderMatcher) {
        return new CompositeMatcher<BatchParameterHolder, ParameterHolder>(parameterHolderMatcher){

            @Override
            protected boolean validateByThisMatcher(BatchParameterHolder item, Description expected, Description actual) {
                List<BatchExecutionEntry> entries = item.getBatchExecutionEntries();
                int size = entries.size();
                if (size - 1 < index) {
                    expected.appendText("batch[" + index + "] exists");
                    actual.appendText("batch[] size was " + size);
                    return false;
                }
                BatchExecutionEntry entry = entries.get(index);
                if (!(entry instanceof ParameterHolder)) {
                    expected.appendText("batch[" + index + "] an instance of " + ParameterHolder.class.getSimpleName());
                    actual.appendText("batch[" + index + "] is a " + item.getClass().getName());
                    return false;
                }
                return true;
            }

            @Override
            public ParameterHolder getValue(BatchParameterHolder actual) {
                BatchExecutionEntry entry = actual.getBatchExecutionEntries().get(index);
                return (ParameterHolder)((Object)entry);
            }

            @Override
            public String getSubMatcherFailureDescriptionPrefix() {
                return "batch[" + index + "] ";
            }
        };
    }
}

