/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import java.sql.SQLType;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.ttddyy.dsproxy.asserts.OutParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.hamcrest.ParameterHolderMatcher;
import net.ttddyy.dsproxy.asserts.hamcrest.SqlTypeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class OutParameterHolderAssertions {
    OutParameterHolderAssertions() {
    }

    public static Matcher<? super ParameterHolder> outParamNames(Matcher<? super Collection<String>> collectionMatcher) {
        return new ParameterHolderMatcher.OutParamMatcher<Collection<String>>(collectionMatcher){

            @Override
            public Collection<String> featureValueOf(OutParameterHolder actual) {
                return actual.getOutParamNames();
            }
        };
    }

    public static Matcher<? super ParameterHolder> outParamIndexes(Matcher<? super Collection<Integer>> collectionMatcher) {
        return new ParameterHolderMatcher.OutParamMatcher<Collection<Integer>>(collectionMatcher){

            @Override
            public Collection<Integer> featureValueOf(OutParameterHolder actual) {
                return actual.getOutParamIndexes();
            }
        };
    }

    public static Matcher<? super ParameterHolder> outParam(String paramName, int sqlType) {
        SqlTypeMatcher matcher = new SqlTypeMatcher(sqlType);
        return OutParameterHolderAssertions.getOutputMatcherByName(paramName, matcher, Integer.class);
    }

    public static Matcher<? super ParameterHolder> outParam(String paramName, SQLType sqlType) {
        Matcher matcher = Matchers.equalTo((Object)sqlType);
        return OutParameterHolderAssertions.getOutputMatcherByName(paramName, matcher, SQLType.class);
    }

    public static Matcher<? super ParameterHolder> outParam(int index, int sqlType) {
        SqlTypeMatcher matcher = new SqlTypeMatcher(sqlType);
        return OutParameterHolderAssertions.getOutputMatcherByIndex(index, matcher, Integer.class);
    }

    public static Matcher<? super ParameterHolder> outParam(int index, SQLType sqlType) {
        Matcher matcher = Matchers.equalTo((Object)sqlType);
        return OutParameterHolderAssertions.getOutputMatcherByIndex(index, matcher, SQLType.class);
    }

    private static <T> Matcher<? super ParameterHolder> getOutputMatcherByName(final String paramName, Matcher<T> matcher, final Class<T> valueType) {
        return new ParameterHolderMatcher.OutParamMatcher<T>(matcher){

            @Override
            public boolean validateParameterByOutParam(OutParameterHolder actual, Description descForExpected, Description descForFailure) {
                Object value = actual.getOutParamsByName().get(paramName);
                if (value == null) {
                    Set<String> names = actual.getOutParamsByName().keySet();
                    TreeSet<String> sorted = new TreeSet<String>(names);
                    descForExpected.appendText("out param name " + paramName + " exist");
                    descForFailure.appendText("out param names are " + sorted);
                    return false;
                }
                if (!valueType.isAssignableFrom(value.getClass())) {
                    descForExpected.appendText("value of out param " + paramName + " is instance of " + valueType);
                    descForFailure.appendText("value " + value + " was " + value.getClass());
                    return false;
                }
                return true;
            }

            @Override
            public T featureValueOf(OutParameterHolder actual) {
                this.descForExpected.appendText("out param " + paramName + " is ");
                this.descForFailure.appendText("out param " + paramName + " was ");
                return actual.getOutParamsByName().get(paramName);
            }
        };
    }

    private static <T> Matcher<? super ParameterHolder> getOutputMatcherByIndex(final int index, Matcher<T> matcher, final Class<T> valueType) {
        return new ParameterHolderMatcher.OutParamMatcher<T>(matcher){

            @Override
            public boolean validateParameterByOutParam(OutParameterHolder actual, Description descForExpected, Description descForFailure) {
                Object value = actual.getOutParamsByIndex().get(index);
                if (value == null) {
                    Set<Integer> indexes = actual.getOutParamsByIndex().keySet();
                    TreeSet<Integer> sorted = new TreeSet<Integer>(indexes);
                    descForExpected.appendText("out param index " + index + " exist");
                    descForFailure.appendText("out param indexes are " + sorted);
                    return false;
                }
                if (!valueType.isAssignableFrom(value.getClass())) {
                    descForExpected.appendText("value of out param index " + index + " is instance of " + valueType);
                    descForFailure.appendText("value " + value + " was " + value.getClass());
                    return false;
                }
                return true;
            }

            @Override
            public T featureValueOf(OutParameterHolder actual) {
                this.descForExpected.appendText("out param index " + index + " is ");
                this.descForFailure.appendText("out param index " + index + " was ");
                return actual.getOutParamsByIndex().get(index);
            }
        };
    }
}

