/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.ttddyy.dsproxy.asserts.ParameterByIndexHolder;
import net.ttddyy.dsproxy.asserts.ParameterByNameHolder;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import net.ttddyy.dsproxy.asserts.hamcrest.ParameterHolderMatcher;
import net.ttddyy.dsproxy.asserts.hamcrest.SqlTypeMatcher;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class ParameterHolderAssertions {
    ParameterHolderAssertions() {
    }

    public static Matcher<? super ParameterHolder> paramsByName(Matcher<Map<? extends String, ?>> mapMatcher) {
        return new ParameterHolderMatcher.ParameterByNameMatcher<Map<? extends String, ?>>((Matcher)mapMatcher){

            @Override
            public Map<? extends String, ?> featureValueOf(ParameterByNameHolder actual) {
                this.descForExpected.appendText("parameters as a ");
                return actual.getSetParamsByName();
            }
        };
    }

    public static Matcher<? super ParameterHolder> paramsByIndex(Matcher<Map<? extends Integer, ?>> mapMatcher) {
        return new ParameterHolderMatcher.ParameterByIndexMatcher<Map<? extends Integer, ?>>((Matcher)mapMatcher){

            @Override
            public Map<? extends Integer, ?> featureValueOf(ParameterByIndexHolder actual) {
                this.descForExpected.appendText("parameters as a ");
                return actual.getSetParamsByIndex();
            }
        };
    }

    public static Matcher<? super ParameterHolder> paramIndexes(Matcher<? super Collection<Integer>> collectionMatcher) {
        return new ParameterHolderMatcher.ParameterByIndexMatcher<Collection<Integer>>(collectionMatcher){

            @Override
            public Collection<Integer> featureValueOf(ParameterByIndexHolder actual) {
                this.descForExpected.appendText("parameter indexes as ");
                return actual.getParamIndexes();
            }
        };
    }

    public static Matcher<? super ParameterHolder> paramIndexes(Integer ... indexes) {
        return ParameterHolderAssertions.paramIndexes((Matcher<? super Collection<Integer>>)Matchers.hasItems((Object[])indexes));
    }

    public static Matcher<? super ParameterHolder> paramNames(Matcher<? super Collection<String>> collectionMatcher) {
        return new ParameterHolderMatcher.ParameterByNameMatcher<Collection<String>>(collectionMatcher){

            @Override
            public Collection<String> featureValueOf(ParameterByNameHolder actual) {
                this.descForExpected.appendText("parameter names as ");
                return actual.getParamNames();
            }
        };
    }

    public static Matcher<? super ParameterHolder> paramNames(String ... names) {
        return ParameterHolderAssertions.paramNames((Matcher<? super Collection<String>>)Matchers.hasItems((Object[])names));
    }

    public static Matcher<? super ParameterHolder> param(final String name, Matcher<Object> matcher) {
        return new ParameterHolderMatcher.ParameterByNameMatcher<Object>(matcher){

            @Override
            public Object featureValueOf(ParameterByNameHolder actual) {
                return actual.getSetParamsByName().get(name);
            }

            @Override
            public boolean validateParameterByName(ParameterByNameHolder actual, Description descForExpected, Description descForFailure) {
                if (!actual.getParamNames().contains(name)) {
                    descForExpected.appendText("parameter name " + name);
                    descForFailure.appendText("parameter name " + name + " doesn't exist.");
                    return false;
                }
                descForExpected.appendText("params[" + name + "] ");
                descForFailure.appendText("params[" + name + "] ");
                return true;
            }
        };
    }

    public static Matcher<? super ParameterHolder> param(final Integer index, Matcher<Object> matcher) {
        return new ParameterHolderMatcher.ParameterByIndexMatcher<Object>(matcher){

            @Override
            public Object featureValueOf(ParameterByIndexHolder actual) {
                return actual.getSetParamsByIndex().get(index);
            }

            @Override
            public boolean validateParameterByIndex(ParameterByIndexHolder actual, Description descForExpected, Description descForFailure) {
                if (!actual.getParamIndexes().contains(index)) {
                    descForExpected.appendText("parameter index " + index);
                    descForFailure.appendText("parameter index " + index + " doesn't exist.");
                    return false;
                }
                descForExpected.appendText("params[" + index + "] ");
                descForFailure.appendText("params[" + index + "] ");
                return true;
            }
        };
    }

    public static <T> Matcher<? super ParameterHolder> param(final String name, final Class<T> clazz, Matcher<? super T> matcher) {
        return new ParameterHolderMatcher.ParameterByNameMatcher<T>(matcher){

            @Override
            public T featureValueOf(ParameterByNameHolder actual) {
                return actual.getSetParamsByName().get(name);
            }

            @Override
            public boolean validateParameterByName(ParameterByNameHolder actual, Description descForExpected, Description descForFailure) {
                Object value = actual.getSetParamsByName().get(name);
                if (value == null) {
                    descForExpected.appendText("parameter name " + name);
                    descForFailure.appendText("parameter name " + name + " doesn't exist.");
                    return false;
                }
                if (!clazz.isAssignableFrom(value.getClass())) {
                    descForExpected.appendText("parameter can cast to " + clazz.getSimpleName());
                    descForFailure.appendText("parameter can not cast to" + clazz.getSimpleName());
                    return false;
                }
                descForExpected.appendText("params[" + name + "] ");
                descForFailure.appendText("params[" + name + "] ");
                return true;
            }
        };
    }

    public static <T> Matcher<? super ParameterHolder> param(final int index, final Class<T> clazz, Matcher<? super T> matcher) {
        return new ParameterHolderMatcher.ParameterByIndexMatcher<T>(matcher){

            @Override
            public T featureValueOf(ParameterByIndexHolder actual) {
                return actual.getSetParamsByIndex().get(index);
            }

            @Override
            public boolean validateParameterByIndex(ParameterByIndexHolder actual, Description descForExpected, Description descForFailure) {
                Object value = actual.getSetParamsByIndex().get(index);
                if (value == null) {
                    descForExpected.appendText("parameter index " + index);
                    descForFailure.appendText("parameter index " + index + " doesn't exist.");
                    return false;
                }
                if (!clazz.isAssignableFrom(value.getClass())) {
                    descForExpected.appendText("parameter can cast to " + clazz.getSimpleName());
                    descForFailure.appendText("parameter can not cast to" + clazz.getSimpleName());
                    return false;
                }
                descForExpected.appendText("params[" + index + "] ");
                descForFailure.appendText("params[" + index + "] ");
                return true;
            }
        };
    }

    public static Matcher<? super ParameterHolder> paramAsString(Integer index, Matcher<? super String> matcher) {
        return ParameterHolderAssertions.param(index, String.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsInteger(Integer index, Matcher<? super Integer> matcher) {
        return ParameterHolderAssertions.param(index, Integer.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsLong(Integer index, Matcher<? super Long> matcher) {
        return ParameterHolderAssertions.param(index, Long.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsDouble(Integer index, Matcher<? super Double> matcher) {
        return ParameterHolderAssertions.param(index, Double.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsShort(Integer index, Matcher<? super Short> matcher) {
        return ParameterHolderAssertions.param(index, Short.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsBoolean(Integer index, Matcher<? super Boolean> matcher) {
        return ParameterHolderAssertions.param(index, Boolean.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsByte(Integer index, Matcher<? super Byte> matcher) {
        return ParameterHolderAssertions.param(index, Byte.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsFloat(Integer index, Matcher<? super Float> matcher) {
        return ParameterHolderAssertions.param(index, Float.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsBigDecimal(Integer index, Matcher<? super BigDecimal> matcher) {
        return ParameterHolderAssertions.param(index, BigDecimal.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsBytes(Integer index, Matcher<? super byte[]> matcher) {
        return ParameterHolderAssertions.param(index, byte[].class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsDate(Integer index, Matcher<? super Date> matcher) {
        return ParameterHolderAssertions.param(index, Date.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsTime(Integer index, Matcher<? super Time> matcher) {
        return ParameterHolderAssertions.param(index, Time.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsTimestamp(Integer index, Matcher<? super Timestamp> matcher) {
        return ParameterHolderAssertions.param(index, Timestamp.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsArray(Integer index, Matcher<? super Array> matcher) {
        return ParameterHolderAssertions.param(index, Array.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsString(String name, Matcher<? super String> matcher) {
        return ParameterHolderAssertions.param(name, String.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsInteger(String name, Matcher<? super Integer> matcher) {
        return ParameterHolderAssertions.param(name, Integer.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsLong(String name, Matcher<? super Long> matcher) {
        return ParameterHolderAssertions.param(name, Long.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsDouble(String name, Matcher<? super Double> matcher) {
        return ParameterHolderAssertions.param(name, Double.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsShort(String name, Matcher<? super Short> matcher) {
        return ParameterHolderAssertions.param(name, Short.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsBoolean(String name, Matcher<? super Boolean> matcher) {
        return ParameterHolderAssertions.param(name, Boolean.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsByte(String name, Matcher<? super Byte> matcher) {
        return ParameterHolderAssertions.param(name, Byte.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsFloat(String name, Matcher<? super Float> matcher) {
        return ParameterHolderAssertions.param(name, Float.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsBigDecimal(String name, Matcher<? super BigDecimal> matcher) {
        return ParameterHolderAssertions.param(name, BigDecimal.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsBytes(String name, Matcher<? super byte[]> matcher) {
        return ParameterHolderAssertions.param(name, byte[].class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsDate(String name, Matcher<? super Date> matcher) {
        return ParameterHolderAssertions.param(name, Date.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsTime(String name, Matcher<? super Time> matcher) {
        return ParameterHolderAssertions.param(name, Time.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsTimestamp(String name, Matcher<? super Timestamp> matcher) {
        return ParameterHolderAssertions.param(name, Timestamp.class, matcher);
    }

    public static Matcher<? super ParameterHolder> paramAsArray(String name, Matcher<? super Array> matcher) {
        return ParameterHolderAssertions.param(name, Array.class, matcher);
    }

    public static Matcher<? super ParameterHolder> nullParam(final int index, int sqlType) {
        SqlTypeMatcher sqlTypeMatcher = new SqlTypeMatcher(sqlType, "NULL[", "]");
        return new ParameterHolderMatcher.ParameterByIndexMatcher<Integer>((Matcher)sqlTypeMatcher){

            @Override
            public Integer featureValueOf(ParameterByIndexHolder actual) {
                return actual.getSetNullParamsByIndex().get(index);
            }

            @Override
            public boolean validateParameterByIndex(ParameterByIndexHolder actual, Description descForExpected, Description descForFailure) {
                if (!actual.getSetNullParamsByIndex().containsKey(index)) {
                    descForExpected.appendText("parameter index " + index);
                    descForFailure.appendText("parameter index " + index + " doesn't exist.");
                    return false;
                }
                descForExpected.appendText("params[" + index + "] is ");
                descForFailure.appendText("params[" + index + "] was ");
                return true;
            }
        };
    }

    public static Matcher<? super ParameterHolder> nullParam(final String name, int sqlType) {
        SqlTypeMatcher sqlTypeMatcher = new SqlTypeMatcher(sqlType, "NULL[", "]");
        return new ParameterHolderMatcher.ParameterByNameMatcher<Integer>((Matcher)sqlTypeMatcher){

            @Override
            public Integer featureValueOf(ParameterByNameHolder actual) {
                return actual.getSetNullParamsByName().get(name);
            }

            @Override
            public boolean validateParameterByName(ParameterByNameHolder actual, Description descForExpected, Description descForFailure) {
                if (!actual.getSetNullParamsByName().containsKey(name)) {
                    descForExpected.appendText("parameter name " + name);
                    descForFailure.appendText("parameter name " + name + " doesn't exist.");
                    return false;
                }
                descForExpected.appendText("params[" + name + "] is ");
                descForFailure.appendText("params[" + name + "] was ");
                return true;
            }
        };
    }

    public static Matcher<? super ParameterHolder> nullParam(final String name) {
        EmptyParameterHolderMatcher emptyMatcher = new EmptyParameterHolderMatcher();
        return new ParameterHolderMatcher.ParameterByNameMatcher<ParameterHolder>((Matcher)emptyMatcher){

            @Override
            public ParameterHolder featureValueOf(ParameterByNameHolder actual) {
                return null;
            }

            @Override
            public boolean validateParameterByName(ParameterByNameHolder actual, Description descForExpected, Description descForFailure) {
                Set<String> names = actual.getSetNullParamsByName().keySet();
                if (!names.contains(name)) {
                    descForExpected.appendText("params[" + name + "] is NULL");
                    TreeSet<String> sorted = new TreeSet<String>(names);
                    descForFailure.appendText("setNull names are ").appendValueList("[", ", ", "]", sorted);
                    return false;
                }
                return true;
            }
        };
    }

    public static Matcher<? super ParameterHolder> nullParam(final int index) {
        EmptyParameterHolderMatcher emptyMatcher = new EmptyParameterHolderMatcher();
        return new ParameterHolderMatcher.ParameterByIndexMatcher<ParameterHolder>((Matcher)emptyMatcher){

            @Override
            public ParameterHolder featureValueOf(ParameterByIndexHolder actual) {
                return null;
            }

            @Override
            public boolean validateParameterByIndex(ParameterByIndexHolder actual, Description descForExpected, Description descForFailure) {
                Set<Integer> indexes = actual.getSetNullParamsByIndex().keySet();
                if (!indexes.contains(index)) {
                    descForExpected.appendText("params[" + index + "] is NULL");
                    TreeSet<Integer> sorted = new TreeSet<Integer>(indexes);
                    descForFailure.appendText("setNull indexes are ").appendValueList("[", ", ", "]", sorted);
                    return false;
                }
                return true;
            }
        };
    }

    private static class EmptyParameterHolderMatcher
    extends BaseMatcher<ParameterHolder> {
        private EmptyParameterHolderMatcher() {
        }

        public boolean matches(Object item) {
            return true;
        }

        public void describeTo(Description description) {
        }
    }
}

