/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import net.ttddyy.dsproxy.asserts.OutParameterHolder;
import net.ttddyy.dsproxy.asserts.ParameterByIndexHolder;
import net.ttddyy.dsproxy.asserts.ParameterByNameHolder;
import net.ttddyy.dsproxy.asserts.ParameterHolder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public abstract class ParameterHolderMatcher<S>
extends BaseMatcher<ParameterHolder> {
    private final Matcher<? super S> subMatcher;
    private MatchBy matchBy;
    protected Description descForExpected = new StringDescription();
    protected Description descForFailure = new StringDescription();

    protected ParameterHolderMatcher(Matcher<? super S> subMatcher, MatchBy matchBy) {
        this.subMatcher = subMatcher;
        this.matchBy = matchBy;
    }

    public boolean matches(Object item) {
        S featureValue;
        if (!(item instanceof ParameterHolder)) {
            this.populateCompatibilityFailureMessage(ParameterHolder.class, item);
            return false;
        }
        ParameterHolder holder = (ParameterHolder)item;
        if (MatchBy.INDEX.equals((Object)this.matchBy)) {
            if (!(holder instanceof ParameterByIndexHolder)) {
                this.populateCompatibilityFailureMessage(ParameterByIndexHolder.class, holder);
                return false;
            }
            ParameterByIndexHolder byIndexHolder = (ParameterByIndexHolder)holder;
            if (!this.validateParameterByIndex(byIndexHolder, this.descForExpected, this.descForFailure)) {
                return false;
            }
            featureValue = this.getFeatureValue(byIndexHolder);
        } else if (MatchBy.NAME.equals((Object)this.matchBy)) {
            if (!(holder instanceof ParameterByNameHolder)) {
                this.populateCompatibilityFailureMessage(ParameterByNameHolder.class, holder);
                return false;
            }
            ParameterByNameHolder byNameHolder = (ParameterByNameHolder)holder;
            if (!this.validateParameterByName(byNameHolder, this.descForExpected, this.descForFailure)) {
                return false;
            }
            featureValue = this.getFeatureValue(byNameHolder);
        } else {
            if (!(holder instanceof OutParameterHolder)) {
                this.populateCompatibilityFailureMessage(OutParameterHolder.class, holder);
                return false;
            }
            OutParameterHolder byOutParamHolder = (OutParameterHolder)holder;
            if (!this.validateParameterByOutParam(byOutParamHolder, this.descForExpected, this.descForFailure)) {
                return false;
            }
            featureValue = this.getFeatureValue(byOutParamHolder);
        }
        if (!this.subMatcher.matches(featureValue)) {
            StringDescription description = new StringDescription();
            this.subMatcher.describeMismatch(featureValue, (Description)description);
            this.descForExpected.appendDescriptionOf(this.subMatcher);
            this.descForFailure.appendText(description.toString());
            return false;
        }
        return true;
    }

    private void populateCompatibilityFailureMessage(Class<?> expectedInterface, Object actual) {
        String interfaceName = expectedInterface.getSimpleName();
        this.descForExpected.appendText("implementation of ").appendText(interfaceName);
        this.descForFailure.appendText(actual.getClass().getSimpleName()).appendText(" didn't implement ").appendText(interfaceName);
    }

    public S getFeatureValue(ParameterByIndexHolder actual) {
        throw new UnsupportedOperationException("Subclass that uses byIndex should implement this method.");
    }

    public S getFeatureValue(ParameterByNameHolder actual) {
        throw new UnsupportedOperationException("Subclass that uses byName should implement this method.");
    }

    public S getFeatureValue(OutParameterHolder actual) {
        throw new UnsupportedOperationException("Subclass that uses byName should implement this method.");
    }

    public boolean validateParameterByIndex(ParameterByIndexHolder actual, Description descForExpected, Description descForFailure) {
        return true;
    }

    public boolean validateParameterByName(ParameterByNameHolder actual, Description descForExpected, Description descForFailure) {
        return true;
    }

    public boolean validateParameterByOutParam(OutParameterHolder actual, Description descForExpected, Description descForFailure) {
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.descForExpected.toString());
    }

    public void describeMismatch(Object item, Description description) {
        description.appendText(this.descForFailure.toString());
    }

    public static abstract class OutParamMatcher<T>
    extends ParameterHolderMatcher<T> {
        public OutParamMatcher(Matcher<? super T> subMatcher) {
            super(subMatcher, MatchBy.OUTPARAM);
        }

        @Override
        public T getFeatureValue(OutParameterHolder actual) {
            return this.featureValueOf(actual);
        }

        public abstract T featureValueOf(OutParameterHolder var1);
    }

    public static abstract class ParameterByNameMatcher<T>
    extends ParameterHolderMatcher<T> {
        public ParameterByNameMatcher(Matcher<? super T> subMatcher) {
            super(subMatcher, MatchBy.NAME);
        }

        @Override
        public T getFeatureValue(ParameterByNameHolder actual) {
            return this.featureValueOf(actual);
        }

        public abstract T featureValueOf(ParameterByNameHolder var1);
    }

    public static abstract class ParameterByIndexMatcher<T>
    extends ParameterHolderMatcher<T> {
        public ParameterByIndexMatcher(Matcher<? super T> subMatcher) {
            super(subMatcher, MatchBy.INDEX);
        }

        @Override
        public T getFeatureValue(ParameterByIndexHolder actual) {
            return this.featureValueOf(actual);
        }

        public abstract T featureValueOf(ParameterByIndexHolder var1);
    }

    protected static enum MatchBy {
        INDEX,
        NAME,
        OUTPARAM;

    }
}

