/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import java.util.List;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.asserts.DefaultQueryExtractor;
import net.ttddyy.dsproxy.asserts.ProxyTestDataSource;
import net.ttddyy.dsproxy.asserts.QueriesHolder;
import net.ttddyy.dsproxy.asserts.QueryExecution;
import net.ttddyy.dsproxy.asserts.QueryExtractor;
import net.ttddyy.dsproxy.asserts.QueryHolder;
import net.ttddyy.dsproxy.asserts.hamcrest.CompositeMatcher;
import net.ttddyy.dsproxy.listener.QueryUtils;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

class ProxyTestDataSourceAssertions {
    ProxyTestDataSourceAssertions() {
    }

    public static Matcher<ProxyTestDataSource> executions(final int index, Matcher<? super QueryExecution> queryExecutionMatcher) {
        return new CompositeMatcher<ProxyTestDataSource, QueryExecution>(queryExecutionMatcher){

            @Override
            protected boolean validateByThisMatcher(ProxyTestDataSource item, Description expected, Description actual) {
                List<QueryExecution> queryExecutions = item.getQueryExecutions();
                int size = queryExecutions.size();
                if (size - 1 < index) {
                    expected.appendText("queryExecutions[" + index + "] exists");
                    actual.appendText("queryExecutions[] size was " + size);
                    return false;
                }
                return true;
            }

            @Override
            public QueryExecution getValue(ProxyTestDataSource actual) {
                return actual.getQueryExecutions().get(index);
            }

            @Override
            public String getSubMatcherFailureDescriptionPrefix() {
                return "queryExecutions[" + index + "] ";
            }
        };
    }

    public static Matcher<ProxyTestDataSource> executionCount(int count) {
        String msg = "queryExecutions size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getQueryExecutions().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> statementCount(int count) {
        String msg = "StatementExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getStatements().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> batchStatementCount(int count) {
        String msg = "StatementBatchExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getBatchStatements().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> statementOrBatchStatementCount(int count) {
        String msg = "StatementExecution or StatementBatchExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getStatements().size() + actual.getBatchStatements().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> preparedCount(int count) {
        String msg = "PreparedExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getPrepareds().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> batchPreparedCount(int count) {
        String msg = "PreparedBatchExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getBatchPrepareds().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> preparedOrBatchPreparedCount(int count) {
        String msg = "PreparedExecution or PreparedBatchExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getPrepareds().size() + actual.getBatchPrepareds().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> callableCount(int count) {
        String msg = "CallableExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getCallables().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> batchCallableCount(int count) {
        String msg = "CallableBatchExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getBatchCallables().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> callableOrBatchCallableCount(int count) {
        String msg = "CallableExecution or CallableBatchExecution size";
        return new FeatureMatcher<ProxyTestDataSource, Integer>(Matchers.equalTo((Object)count), msg, msg){

            protected Integer featureValueOf(ProxyTestDataSource actual) {
                return actual.getCallables().size() + actual.getBatchCallables().size();
            }
        };
    }

    public static Matcher<ProxyTestDataSource> totalQueryCount(final int count) {
        return new TypeSafeMatcher<ProxyTestDataSource>(){

            protected boolean matchesSafely(ProxyTestDataSource item) {
                int actualSize = this.countQueries(item);
                return count == actualSize;
            }

            public void describeTo(Description description) {
                description.appendText(count + " query executions");
            }

            protected void describeMismatchSafely(ProxyTestDataSource item, Description mismatchDescription) {
                int actualSize = this.countQueries(item);
                mismatchDescription.appendText("was " + actualSize + " query executions");
            }

            private int countQueries(ProxyTestDataSource ds) {
                int count2 = 0;
                for (QueryExecution queryExecution : ds.getQueryExecutions()) {
                    if (queryExecution instanceof QueryHolder) {
                        ++count2;
                        continue;
                    }
                    if (!(queryExecution instanceof QueriesHolder)) continue;
                    count2 += ((QueriesHolder)((Object)queryExecution)).getQueries().size();
                }
                return count2;
            }
        };
    }

    public static Matcher<ProxyTestDataSource> selectCount(int count) {
        return new QueryTypeCountMatcher(QueryType.SELECT, count);
    }

    public static Matcher<ProxyTestDataSource> insertCount(int count) {
        return new QueryTypeCountMatcher(QueryType.INSERT, count);
    }

    public static Matcher<ProxyTestDataSource> updateCount(int count) {
        return new QueryTypeCountMatcher(QueryType.UPDATE, count);
    }

    public static Matcher<ProxyTestDataSource> deleteCount(int count) {
        return new QueryTypeCountMatcher(QueryType.DELETE, count);
    }

    public static Matcher<ProxyTestDataSource> otherCount(int count) {
        return new QueryTypeCountMatcher(QueryType.OTHER, count);
    }

    private static class QueryTypeCountMatcher
    extends TypeSafeMatcher<ProxyTestDataSource> {
        private QueryType expectedQueryType;
        private int matchedCount = 0;
        private int expectedCount = 0;
        private QueryExtractor queryExtractor = new DefaultQueryExtractor();

        private QueryTypeCountMatcher(QueryType expectedQueryType, int expectedCount) {
            this.expectedQueryType = expectedQueryType;
            this.expectedCount = expectedCount;
        }

        protected boolean matchesSafely(ProxyTestDataSource item) {
            for (QueryExecution queryExecution : item.getQueryExecutions()) {
                List<String> queries = this.queryExtractor.getQueries(queryExecution);
                for (String query : queries) {
                    QueryType queryType = QueryUtils.getQueryType((String)query);
                    if (!this.expectedQueryType.equals((Object)queryType)) continue;
                    ++this.matchedCount;
                }
            }
            return this.matchedCount == this.expectedCount;
        }

        public void describeTo(Description description) {
            String msg = this.expectedCount + " " + this.expectedQueryType + " query executions";
            description.appendText(msg);
        }

        protected void describeMismatchSafely(ProxyTestDataSource item, Description mismatchDescription) {
            String msg = "was " + this.matchedCount + " " + this.expectedQueryType + " query executions";
            mismatchDescription.appendText(msg);
        }
    }
}

