/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import java.util.Collection;
import net.ttddyy.dsproxy.asserts.QueriesHolder;
import net.ttddyy.dsproxy.asserts.QueryHolder;
import net.ttddyy.dsproxy.asserts.hamcrest.CompositeMatcher;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;

class QueriesHolderAssertions {
    QueriesHolderAssertions() {
    }

    public static Matcher<? super QueriesHolder> queries(final int index, Matcher<String> stringMatcher) {
        return new CompositeMatcher<QueriesHolder, String>(stringMatcher){

            @Override
            protected boolean validateByThisMatcher(QueriesHolder item, Description expected, Description actual) {
                int size = item.getQueries().size();
                if (size - 1 < index) {
                    expected.appendText("queries[" + index + "] exists");
                    actual.appendText("queries[] size was " + size);
                    return false;
                }
                return true;
            }

            @Override
            public String getValue(QueriesHolder actual) {
                return actual.getQueries().get(index);
            }

            @Override
            public String getSubMatcherFailureDescriptionPrefix() {
                return "queries[" + index + "] ";
            }
        };
    }

    public static Matcher<? super QueriesHolder> queries(Matcher<? super Collection<String>> collectionMatcher) {
        return new FeatureMatcher<QueriesHolder, Collection<String>>(collectionMatcher, "queries[]", "queries[]"){

            protected Collection<String> featureValueOf(QueriesHolder actual) {
                return actual.getQueries();
            }
        };
    }

    public static Matcher<? super QueriesHolder> queryTypes(final int index, Matcher<? super QueryHolder> queryHolderMatcher) {
        return new CompositeMatcher<QueriesHolder, QueryHolder>(queryHolderMatcher){

            @Override
            protected boolean validateByThisMatcher(QueriesHolder item, Description expected, Description actual) {
                int size = item.getQueries().size();
                if (size - 1 < index) {
                    expected.appendText("queries[" + index + "] exists");
                    actual.appendText("queries[] size was " + size);
                    return false;
                }
                return true;
            }

            @Override
            public QueryHolder getValue(QueriesHolder actual) {
                final String query = actual.getQueries().get(index);
                QueryHolder queryHolder = new QueryHolder(){

                    @Override
                    public String getQuery() {
                        return query;
                    }
                };
                return queryHolder;
            }

            @Override
            public String getSubMatcherFailureDescriptionPrefix() {
                return "queries[" + index + "] ";
            }
        };
    }
}

