/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import net.ttddyy.dsproxy.asserts.QueryExecution;
import net.ttddyy.dsproxy.asserts.hamcrest.ExecutionType;
import net.ttddyy.dsproxy.asserts.hamcrest.ExecutionTypeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

class QueryExecutionAssertions {
    QueryExecutionAssertions() {
    }

    public static Matcher<QueryExecution> success() {
        return new TypeSafeMatcher<QueryExecution>(){

            protected boolean matchesSafely(QueryExecution item) {
                return item.isSuccess();
            }

            public void describeTo(Description description) {
                description.appendText("success");
            }

            protected void describeMismatchSafely(QueryExecution item, Description mismatchDescription) {
                mismatchDescription.appendText("was failure");
            }
        };
    }

    public static Matcher<QueryExecution> failure() {
        return new TypeSafeMatcher<QueryExecution>(){

            protected boolean matchesSafely(QueryExecution item) {
                return !item.isSuccess();
            }

            public void describeTo(Description description) {
                description.appendText("failure");
            }

            protected void describeMismatchSafely(QueryExecution item, Description mismatchDescription) {
                mismatchDescription.appendText("was success");
            }
        };
    }

    public static Matcher<? super QueryExecution> batch() {
        return new ExecutionTypeMatcher(ExecutionType.IS_BATCH);
    }

    public static Matcher<? super QueryExecution> statement() {
        return new ExecutionTypeMatcher(ExecutionType.IS_STATEMENT);
    }

    public static Matcher<? super QueryExecution> batchStatement() {
        return new ExecutionTypeMatcher(ExecutionType.IS_BATCH_STATEMENT);
    }

    public static Matcher<? super QueryExecution> statementOrBatchStatement() {
        return new ExecutionTypeMatcher(ExecutionType.IS_STATEMENT_OR_BATCH_STATEMENT);
    }

    public static Matcher<? super QueryExecution> prepared() {
        return new ExecutionTypeMatcher(ExecutionType.IS_PREPARED);
    }

    public static Matcher<? super QueryExecution> batchPrepared() {
        return new ExecutionTypeMatcher(ExecutionType.IS_BATCH_PREPARED);
    }

    public static Matcher<? super QueryExecution> preparedOrBatchPrepared() {
        return new ExecutionTypeMatcher(ExecutionType.IS_PREPARED_OR_BATCH_PREPARED);
    }

    public static Matcher<? super QueryExecution> callable() {
        return new ExecutionTypeMatcher(ExecutionType.IS_CALLABLE);
    }

    public static Matcher<? super QueryExecution> batchCallable() {
        return new ExecutionTypeMatcher(ExecutionType.IS_BATCH_CALLABLE);
    }

    public static Matcher<? super QueryExecution> callableOrBatchCallable() {
        return new ExecutionTypeMatcher(ExecutionType.IS_CALLABLE_OR_BATCH_CALLABLE);
    }
}

