/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.asserts.QueryHolder;
import net.ttddyy.dsproxy.listener.QueryUtils;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

class QueryHolderAssertions {
    QueryHolderAssertions() {
    }

    public static Matcher<? super QueryHolder> query(Matcher<String> stringMatcher) {
        return new FeatureMatcher<QueryHolder, String>(stringMatcher, "query", "query"){

            protected String featureValueOf(QueryHolder actual) {
                return actual.getQuery();
            }
        };
    }

    public static Matcher<? super QueryHolder> queryType(final QueryType expectedType) {
        return new TypeSafeMatcher<QueryHolder>(){

            protected boolean matchesSafely(QueryHolder item) {
                String query = item.getQuery();
                QueryType actualType = QueryUtils.getQueryType((String)query);
                return expectedType == actualType;
            }

            public void describeTo(Description description) {
                description.appendText("query type \"" + expectedType + "\"");
            }

            protected void describeMismatchSafely(QueryHolder item, Description mismatchDescription) {
                String query = item.getQuery();
                QueryType actualType = QueryUtils.getQueryType((String)query);
                String msg = "query type was \"" + actualType + "\" (" + query + ")";
                mismatchDescription.appendText(msg);
            }
        };
    }

    public static Matcher<? super QueryHolder> select() {
        return QueryHolderAssertions.queryType(QueryType.SELECT);
    }

    public static Matcher<? super QueryHolder> insert() {
        return QueryHolderAssertions.queryType(QueryType.INSERT);
    }

    public static Matcher<? super QueryHolder> update() {
        return QueryHolderAssertions.queryType(QueryType.UPDATE);
    }

    public static Matcher<? super QueryHolder> delete() {
        return QueryHolderAssertions.queryType(QueryType.DELETE);
    }

    public static Matcher<? super QueryHolder> other() {
        return QueryHolderAssertions.queryType(QueryType.OTHER);
    }
}

