/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.asserts.hamcrest;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class SqlTypeMatcher
extends TypeSafeMatcher<Integer> {
    public static final Map<Integer, String> typeNameByValue = new HashMap<Integer, String>();
    protected int expectedSqlType;
    protected String messagePrefix = "";
    protected String messageSuffix = "";

    public SqlTypeMatcher(int expectedSqlType) {
        this.expectedSqlType = expectedSqlType;
    }

    public SqlTypeMatcher(int expectedSqlType, String messagePrefix, String messageSuffix) {
        this.expectedSqlType = expectedSqlType;
        this.messagePrefix = messagePrefix;
        this.messageSuffix = messageSuffix;
    }

    protected boolean matchesSafely(Integer item) {
        if (item == null) {
            return false;
        }
        return this.expectedSqlType == item;
    }

    public void describeTo(Description description) {
        description.appendText(this.getMessage(this.expectedSqlType));
    }

    protected void describeMismatchSafely(Integer item, Description mismatchDescription) {
        mismatchDescription.appendText(this.getMessage(item));
    }

    protected String getMessage(Integer sqlType) {
        String typeName = typeNameByValue.get(sqlType);
        if (typeName == null) {
            typeName = "UNKNOWN";
        }
        return this.messagePrefix + typeName + ":" + sqlType + this.messageSuffix;
    }

    public void setMessagePrefix(String messagePrefix) {
        this.messagePrefix = messagePrefix;
    }

    public void setMessageSuffix(String messageSuffix) {
        this.messageSuffix = messageSuffix;
    }

    static {
        try {
            Field[] fields;
            for (Field field : fields = Types.class.getDeclaredFields()) {
                typeNameByValue.put(field.getInt(null), field.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

