/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.r2dbc.core;

import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ttddyy.dsproxy.r2dbc.core.Binding;
import net.ttddyy.dsproxy.r2dbc.core.BindingValue;
import reactor.util.annotation.NonNull;

public class Bindings {
    private SortedSet<Binding> indexBindings = new TreeSet<Binding>();
    private SortedSet<Binding> identifierBindings = new TreeSet<Binding>();

    public void addIndexBinding(int index, BindingValue value) {
        this.indexBindings.add(new IndexBinding(index, value));
    }

    public void addIdentifierBinding(Object identifier, BindingValue value) {
        this.identifierBindings.add(new IdentifierBinding(identifier, value));
    }

    public SortedSet<Binding> getIndexBindings() {
        return this.indexBindings;
    }

    public SortedSet<Binding> getIdentifierBindings() {
        return this.identifierBindings;
    }

    public static class IdentifierBinding
    implements Binding,
    Comparable<IdentifierBinding> {
        private Object identifier;
        private BindingValue value;

        public IdentifierBinding(Object identifier, BindingValue value) {
            this.identifier = identifier;
            this.value = value;
        }

        @Override
        public int compareTo(@NonNull IdentifierBinding o) {
            return Objects.compare((Comparable)this.identifier, (Comparable)o.identifier, Comparator.naturalOrder());
        }

        @Override
        public Object getKey() {
            return this.identifier;
        }

        @Override
        public BindingValue getBindingValue() {
            return this.value;
        }
    }

    public static class IndexBinding
    implements Binding,
    Comparable<IndexBinding> {
        private int index;
        private BindingValue value;

        public IndexBinding(int index, BindingValue value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(@NonNull IndexBinding o) {
            return Integer.compare(this.index, o.index);
        }

        @Override
        public Object getKey() {
            return this.index;
        }

        @Override
        public BindingValue getBindingValue() {
            return this.value;
        }
    }
}

