/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.r2dbc.core;

import net.ttddyy.dsproxy.r2dbc.core.MethodExecutionInfo;
import net.ttddyy.dsproxy.r2dbc.core.ProxyEventType;
import net.ttddyy.dsproxy.r2dbc.core.QueryExecutionInfo;

public interface ProxyExecutionListener {
    default public void onMethodExecution(MethodExecutionInfo executionInfo) {
        ProxyEventType eventType = executionInfo.getProxyEventType();
        if (eventType == ProxyEventType.BEFORE_METHOD) {
            this.beforeMethod(executionInfo);
        } else if (eventType == ProxyEventType.AFTER_METHOD) {
            this.afterMethod(executionInfo);
        }
    }

    default public void onQueryExecution(QueryExecutionInfo executionInfo) {
        ProxyEventType eventType = executionInfo.getProxyEventType();
        if (eventType == ProxyEventType.BEFORE_QUERY) {
            this.beforeQuery(executionInfo);
        } else if (eventType == ProxyEventType.AFTER_QUERY) {
            this.afterQuery(executionInfo);
        }
    }

    default public void beforeMethod(MethodExecutionInfo executionInfo) {
    }

    default public void afterMethod(MethodExecutionInfo executionInfo) {
    }

    default public void beforeQuery(QueryExecutionInfo execInfo) {
    }

    default public void afterQuery(QueryExecutionInfo execInfo) {
    }

    default public void eachQueryResult(QueryExecutionInfo execInfo) {
    }
}

