/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.r2dbc.proxy;

import io.r2dbc.spi.Result;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.ttddyy.dsproxy.r2dbc.core.ConnectionInfo;
import net.ttddyy.dsproxy.r2dbc.core.MethodExecutionInfo;
import net.ttddyy.dsproxy.r2dbc.core.ProxyEventType;
import net.ttddyy.dsproxy.r2dbc.core.ProxyExecutionListener;
import net.ttddyy.dsproxy.r2dbc.core.QueryExecutionInfo;
import net.ttddyy.dsproxy.r2dbc.proxy.ProxyConfig;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public abstract class CallbackSupport {
    private static final Set<Method> PASS_THROUGH_METHODS;
    protected Clock clock = Clock.systemUTC();
    protected ProxyConfig proxyConfig;

    public CallbackSupport(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    protected Object proceedExecution(Method method, Object target, Object[] args, ProxyExecutionListener listener, ConnectionInfo connectionInfo, BiFunction<Object, MethodExecutionInfo, Object> onMap, Consumer<MethodExecutionInfo> onComplete) throws Throwable {
        if (PASS_THROUGH_METHODS.contains(method)) {
            try {
                return method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        if ("toString".equals(method.getName())) {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getSimpleName());
            sb.append("-proxy [");
            sb.append(target.toString());
            sb.append("]");
            return sb.toString();
        }
        AtomicReference startTimeHolder = new AtomicReference();
        MethodExecutionInfo executionInfo = new MethodExecutionInfo();
        executionInfo.setMethod(method);
        executionInfo.setMethodArgs(args);
        executionInfo.setTarget(target);
        executionInfo.setConnectionInfo(connectionInfo);
        Class<?> returnType = method.getReturnType();
        if (Publisher.class.isAssignableFrom(returnType)) {
            Publisher result;
            try {
                result = (Publisher)method.invoke(target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            return Flux.empty().doOnSubscribe(s -> {
                Instant startTime = this.clock.instant();
                startTimeHolder.set(startTime);
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                executionInfo.setThreadName(threadName);
                executionInfo.setThreadId(threadId);
                executionInfo.setProxyEventType(ProxyEventType.BEFORE_METHOD);
                listener.onMethodExecution(executionInfo);
            }).concatWith(result).map(resultObj -> {
                executionInfo.setResult(resultObj);
                if (onMap != null) {
                    return onMap.apply(resultObj, executionInfo);
                }
                return resultObj;
            }).doOnComplete(() -> {
                if (onComplete != null) {
                    onComplete.accept(executionInfo);
                }
            }).doOnError(throwable -> executionInfo.setThrown((Throwable)throwable)).doFinally(signalType -> {
                Instant startTime = (Instant)startTimeHolder.get();
                Instant currentTime = this.clock.instant();
                Duration executionDuration = Duration.between(startTime, currentTime);
                executionInfo.setExecuteDuration(executionDuration);
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                executionInfo.setThreadName(threadName);
                executionInfo.setThreadId(threadId);
                executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
                listener.onMethodExecution(executionInfo);
            });
        }
        String threadName = Thread.currentThread().getName();
        long threadId = Thread.currentThread().getId();
        executionInfo.setThreadName(threadName);
        executionInfo.setThreadId(threadId);
        executionInfo.setProxyEventType(ProxyEventType.BEFORE_METHOD);
        listener.onMethodExecution(executionInfo);
        Instant startTime = this.clock.instant();
        Object result = null;
        Throwable thrown = null;
        try {
            result = method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            thrown = ex.getTargetException();
            throw thrown;
        }
        finally {
            executionInfo.setResult(result);
            executionInfo.setThrown(thrown);
            Instant currentTime = this.clock.instant();
            Duration executionDuration = Duration.between(startTime, currentTime);
            executionInfo.setExecuteDuration(executionDuration);
            executionInfo.setProxyEventType(ProxyEventType.AFTER_METHOD);
            listener.onMethodExecution(executionInfo);
        }
        return result;
    }

    protected Flux<? extends Result> interceptQueryExecution(Publisher<? extends Result> flux, ProxyExecutionListener listener, QueryExecutionInfo executionInfo) {
        AtomicReference startTimeHolder = new AtomicReference();
        AtomicInteger resultCount = new AtomicInteger(0);
        return Flux.empty().ofType(Result.class).doOnSubscribe(s -> {
            Instant startTime = this.clock.instant();
            startTimeHolder.set(startTime);
            String threadName = Thread.currentThread().getName();
            long threadId = Thread.currentThread().getId();
            executionInfo.setThreadName(threadName);
            executionInfo.setThreadId(threadId);
            executionInfo.setCurrentResult(null);
            executionInfo.setProxyEventType(ProxyEventType.BEFORE_QUERY);
            listener.onQueryExecution(executionInfo);
        }).concatWith(flux).doOnNext(result -> {
            Instant startTime = (Instant)startTimeHolder.get();
            Instant currentTime = this.clock.instant();
            Duration executionDuration = Duration.between(startTime, currentTime);
            executionInfo.setExecuteDuration(executionDuration);
            String threadName = Thread.currentThread().getName();
            long threadId = Thread.currentThread().getId();
            executionInfo.setThreadName(threadName);
            executionInfo.setThreadId(threadId);
            executionInfo.setProxyEventType(ProxyEventType.EACH_QUERY_RESULT);
            executionInfo.setCurrentResult((Result)result);
            int count = resultCount.incrementAndGet();
            executionInfo.setCurrentResultCount(count);
            listener.eachQueryResult(executionInfo);
        }).doOnComplete(() -> executionInfo.setSuccess(true)).doOnError(throwable -> {
            executionInfo.setThrowable((Throwable)throwable);
            executionInfo.setSuccess(false);
        }).doFinally(signalType -> {
            Instant startTime = (Instant)startTimeHolder.get();
            Instant currentTime = this.clock.instant();
            Duration executionDuration = Duration.between(startTime, currentTime);
            executionInfo.setExecuteDuration(executionDuration);
            String threadName = Thread.currentThread().getName();
            long threadId = Thread.currentThread().getId();
            executionInfo.setThreadName(threadName);
            executionInfo.setThreadId(threadId);
            executionInfo.setCurrentResult(null);
            executionInfo.setProxyEventType(ProxyEventType.AFTER_QUERY);
            listener.onQueryExecution(executionInfo);
        });
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    static {
        try {
            Method objectToStringMethod = Object.class.getMethod("toString", new Class[0]);
            PASS_THROUGH_METHODS = Arrays.stream(Object.class.getMethods()).filter(method -> !objectToStringMethod.equals(method)).collect(Collectors.toSet());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

