/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.r2dbc.proxy;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ttddyy.dsproxy.r2dbc.core.BindingValue;
import net.ttddyy.dsproxy.r2dbc.core.Bindings;
import net.ttddyy.dsproxy.r2dbc.core.ConnectionInfo;
import net.ttddyy.dsproxy.r2dbc.core.ExecutionType;
import net.ttddyy.dsproxy.r2dbc.core.QueryExecutionInfo;
import net.ttddyy.dsproxy.r2dbc.core.QueryInfo;
import net.ttddyy.dsproxy.r2dbc.proxy.CallbackSupport;
import net.ttddyy.dsproxy.r2dbc.proxy.ProxyConfig;
import org.reactivestreams.Publisher;

public class ReactiveStatementCallback
extends CallbackSupport {
    private Statement<?> statement;
    private ConnectionInfo connectionInfo;
    private String query;
    private List<Bindings> bindings = new ArrayList<Bindings>();
    private int currentBindingsIndex = 0;

    public ReactiveStatementCallback(Statement<?> statement, String query, ConnectionInfo connectionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.statement = statement;
        this.query = query;
        this.connectionInfo = connectionInfo;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getTarget".equals(methodName)) {
            return this.statement;
        }
        if ("getOriginalConnection".equals(methodName)) {
            return this.connectionInfo.getOriginalConnection();
        }
        Object result = this.proceedExecution(method, this.statement, args, this.proxyConfig.getListeners(), this.connectionInfo, null, null);
        if ("add".equals(methodName)) {
            ++this.currentBindingsIndex;
        } else if ("bind".equals(methodName) || "bindNull".equals(methodName)) {
            if (this.bindings.size() <= this.currentBindingsIndex) {
                this.bindings.add(new Bindings());
            }
            Bindings bindings = this.bindings.get(this.currentBindingsIndex);
            BindingValue bindingValue = "bind".equals(methodName) ? new BindingValue.SimpleBindingValue(args[1]) : new BindingValue.NullBindingValue((Class)args[1]);
            if (args[0] instanceof Integer) {
                bindings.addIndexBinding((Integer)args[0], bindingValue);
            } else {
                bindings.addIdentifierBinding(args[0], bindingValue);
            }
        } else if ("execute".equals(methodName)) {
            QueryInfo queryInfo = new QueryInfo(this.query);
            queryInfo.getBindingsList().addAll(this.bindings);
            List<QueryInfo> queries = Stream.of(queryInfo).collect(Collectors.toList());
            QueryExecutionInfo execInfo = new QueryExecutionInfo();
            execInfo.setType(ExecutionType.STATEMENT);
            execInfo.setQueries(queries);
            execInfo.setBindingsSize(this.bindings.size());
            execInfo.setMethod(method);
            execInfo.setMethodArgs(args);
            execInfo.setConnectionInfo(this.connectionInfo);
            Publisher publisher = (Publisher)result;
            return this.interceptQueryExecution((Publisher<? extends Result>)publisher, this.proxyConfig.getListeners(), execInfo);
        }
        return result;
    }
}

