/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.r2dbc.proxy;

import io.r2dbc.spi.Result;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import net.ttddyy.dsproxy.r2dbc.core.ConnectionInfo;
import net.ttddyy.dsproxy.r2dbc.core.ProxyEventType;
import net.ttddyy.dsproxy.r2dbc.core.QueryExecutionInfo;
import net.ttddyy.dsproxy.r2dbc.proxy.CallbackSupport;
import net.ttddyy.dsproxy.r2dbc.proxy.ProxyConfig;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ReactiveResultCallback
extends CallbackSupport {
    private Result result;
    private QueryExecutionInfo queryExecutionInfo;

    public ReactiveResultCallback(Result result, QueryExecutionInfo queryExecutionInfo, ProxyConfig proxyConfig) {
        super(proxyConfig);
        this.result = result;
        this.queryExecutionInfo = queryExecutionInfo;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        ConnectionInfo connectionInfo = this.queryExecutionInfo.getConnectionInfo();
        if ("getTarget".equals(methodName)) {
            return this.result;
        }
        if ("getOriginalConnection".equals(methodName)) {
            return connectionInfo.getOriginalConnection();
        }
        Object invocationResult = this.proceedExecution(method, this.result, args, this.proxyConfig.getListeners(), connectionInfo, null, null);
        if ("map".equals(methodName)) {
            AtomicInteger resultCount = new AtomicInteger(0);
            return Flux.from((Publisher)((Publisher)invocationResult)).doOnEach(signal -> {
                boolean proceed;
                boolean bl = proceed = signal.isOnNext() || signal.isOnError();
                if (!proceed) {
                    return;
                }
                int count = resultCount.incrementAndGet();
                if (signal.isOnNext()) {
                    Object mappedResult = signal.get();
                    this.queryExecutionInfo.setCurrentResultCount(count);
                    this.queryExecutionInfo.setCurrentMappedResult(mappedResult);
                    this.queryExecutionInfo.setThrowable(null);
                } else {
                    Throwable thrown = signal.getThrowable();
                    this.queryExecutionInfo.setCurrentResultCount(count);
                    this.queryExecutionInfo.setCurrentMappedResult(null);
                    this.queryExecutionInfo.setThrowable(thrown);
                }
                this.queryExecutionInfo.setProxyEventType(ProxyEventType.EACH_QUERY_RESULT);
                String threadName = Thread.currentThread().getName();
                long threadId = Thread.currentThread().getId();
                this.queryExecutionInfo.setThreadName(threadName);
                this.queryExecutionInfo.setThreadId(threadId);
                this.proxyConfig.getListeners().eachQueryResult(this.queryExecutionInfo);
            });
        }
        return invocationResult;
    }
}

