/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.SLF4JLogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SLF4JQueryLoggingListener
implements QueryExecutionListener {
    private static final String MESSAGE = "Name:{} Time:{} Num:{} Query:{}";
    private Logger logger = LoggerFactory.getLogger(SLF4JQueryLoggingListener.class);
    private SLF4JLogLevel logLevel = SLF4JLogLevel.DEBUG;

    @Override
    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    @Override
    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String dataSourceName = execInfo.getDataSourceName();
        long elapsedTime = execInfo.getElapsedTime();
        int numOfQuery = queryInfoList.size();
        StringBuilder sb = new StringBuilder();
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("{");
            String query = queryInfo.getQuery();
            List<?> args = queryInfo.getQueryArgs();
            sb.append("[");
            sb.append(query);
            sb.append("][");
            for (Object arg : args) {
                sb.append(arg);
                sb.append(',');
            }
            this.chopIfEndWith(sb, ',');
            sb.append("]");
            sb.append("} ");
        }
        String queries = sb.toString();
        this.writeLog(new Object[]{dataSourceName, elapsedTime, numOfQuery, queries});
    }

    private void chopIfEndWith(StringBuilder sb, char c) {
        int lastCharIndex = sb.length() - 1;
        if (sb.charAt(lastCharIndex) == c) {
            sb.deleteCharAt(lastCharIndex);
        }
    }

    private void writeLog(Object[] argArray) {
        switch (this.logLevel) {
            case DEBUG: {
                this.logger.debug(MESSAGE, argArray);
                break;
            }
            case ERROR: {
                this.logger.error(MESSAGE, argArray);
                break;
            }
            case INFO: {
                this.logger.info(MESSAGE, argArray);
                break;
            }
            case TRACE: {
                this.logger.trace(MESSAGE, argArray);
                break;
            }
            case WARN: {
                this.logger.warn(MESSAGE, argArray);
            }
        }
    }

    public void setLogLevel(SLF4JLogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

