/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.ObjectArrayUtils;

public class ConnectionInvocationHandler
implements InvocationHandler {
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private Connection connection;
    private QueryExecutionListener listener;
    private String dataSourceName;

    public ConnectionInvocationHandler(Connection connection) {
        this.connection = connection;
    }

    public ConnectionInvocationHandler(Connection connection, QueryExecutionListener listener) {
        this.connection = connection;
        this.listener = listener;
    }

    public ConnectionInvocationHandler(Connection connection, QueryExecutionListener listener, String dataSourceName) {
        this.connection = connection;
        this.listener = listener;
        this.dataSourceName = dataSourceName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder("ConnectionInvocationHandler [");
            sb.append(this.connection.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.connection;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.connection.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.connection.isWrapperFor(clazz);
            }
        }
        try {
            Object retVal = method.invoke((Object)this.connection, args);
            if ("createStatement".equals(methodName)) {
                return JdbcProxyFactory.createStatement((Statement)retVal, this.listener, this.dataSourceName);
            }
            if ("prepareStatement".equals(methodName)) {
                if (ObjectArrayUtils.isFirstArgString(args)) {
                    String query = (String)args[0];
                    return JdbcProxyFactory.createPreparedStatement((PreparedStatement)retVal, query, this.listener, this.dataSourceName);
                }
            } else if ("prepareCall".equals(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
                String query = (String)args[0];
                return JdbcProxyFactory.createCallableStatement((CallableStatement)retVal, query, this.listener, this.dataSourceName);
            }
            return retVal;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

