/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;

public class DataSourceInvocationHandler
implements InvocationHandler {
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private DataSource dataSource;
    private QueryExecutionListener listener;
    private String dataSourceName;

    public DataSourceInvocationHandler() {
    }

    public DataSourceInvocationHandler(DataSource dataSource, QueryExecutionListener listener, String dataSourceName) {
        this.dataSource = dataSource;
        this.listener = listener;
        this.dataSourceName = dataSourceName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder("DataSourceInvocationHandler [");
            sb.append(this.dataSource.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.dataSource;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.dataSource.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.dataSource.isWrapperFor(clazz);
            }
        }
        try {
            Object retVal = method.invoke((Object)this.dataSource, args);
            if ("getConnection".equals(methodName)) {
                return JdbcProxyFactory.createConnection((Connection)retVal, this.listener, this.dataSourceName);
            }
            return retVal;
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setListener(QueryExecutionListener listener) {
        this.listener = listener;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }
}

