/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.CallableStatementInvocationHandler;
import net.ttddyy.dsproxy.proxy.ConnectionInvocationHandler;
import net.ttddyy.dsproxy.proxy.DataSourceInvocationHandler;
import net.ttddyy.dsproxy.proxy.PreparedStatementInvocationHandler;
import net.ttddyy.dsproxy.proxy.ProxyJdbcObject;
import net.ttddyy.dsproxy.proxy.StatementInvocationHandler;

public class JdbcProxyFactory {
    public static DataSource createDataSource(DataSource dataSource, QueryExecutionListener listener, String dataSourceName) {
        return (DataSource)Proxy.newProxyInstance(ProxyJdbcObject.class.getClassLoader(), new Class[]{ProxyJdbcObject.class, DataSource.class}, (InvocationHandler)new DataSourceInvocationHandler(dataSource, listener, dataSourceName));
    }

    public static Connection createConnection(Connection connection, QueryExecutionListener listener) {
        return JdbcProxyFactory.createConnection(connection, listener, "");
    }

    public static Connection createConnection(Connection connection, QueryExecutionListener listener, String dataSourceName) {
        return (Connection)Proxy.newProxyInstance(ProxyJdbcObject.class.getClassLoader(), new Class[]{ProxyJdbcObject.class, Connection.class}, (InvocationHandler)new ConnectionInvocationHandler(connection, listener, dataSourceName));
    }

    public static Statement createStatement(Statement statement, QueryExecutionListener listener) {
        return JdbcProxyFactory.createStatement(statement, listener, "");
    }

    public static Statement createStatement(Statement statement, QueryExecutionListener listener, String dataSourceName) {
        return (Statement)Proxy.newProxyInstance(ProxyJdbcObject.class.getClassLoader(), new Class[]{ProxyJdbcObject.class, Statement.class}, (InvocationHandler)new StatementInvocationHandler(statement, listener, dataSourceName));
    }

    public static PreparedStatement createPreparedStatement(PreparedStatement preparedStatement, String query, QueryExecutionListener listener) {
        return JdbcProxyFactory.createPreparedStatement(preparedStatement, query, listener, "");
    }

    public static PreparedStatement createPreparedStatement(PreparedStatement preparedStatement, String query, QueryExecutionListener listener, String dataSourceName) {
        return (PreparedStatement)Proxy.newProxyInstance(ProxyJdbcObject.class.getClassLoader(), new Class[]{ProxyJdbcObject.class, PreparedStatement.class}, (InvocationHandler)new PreparedStatementInvocationHandler(preparedStatement, query, listener, dataSourceName));
    }

    public static CallableStatement createCallableStatement(CallableStatement callableStatement, String query, QueryExecutionListener listener, String dataSourceName) {
        return (CallableStatement)Proxy.newProxyInstance(ProxyJdbcObject.class.getClassLoader(), new Class[]{ProxyJdbcObject.class, CallableStatement.class}, (InvocationHandler)new CallableStatementInvocationHandler(callableStatement, query, listener, dataSourceName));
    }
}

