/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.BatchQueryHolder;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;

public class PreparedStatementInvocationHandler
implements InvocationHandler {
    private static final Set<String> PARAMETER_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("setArray", "setAsciiStream", "setBigDecimal", "setBinaryStream", "setBlob", "setBoolean", "setByte", "setBytes", "setCharacterStream", "setClob", "setDate", "setDouble", "setFloat", "setInt", "setLong", "setNull", "setObject", "setRef", "setShort", "setString", "setTime", "setTimestamp", "setUnicodeStream", "setURL", "clearParameters")));
    private static final Set<String> BATCH_PARAM_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("addBatch", "clearBatch")));
    private static final Set<String> EXEC_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("executeBatch", "executeQuery", "executeUpdate", "execute")));
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private static final Set<String> GET_CONNECTION_METHOD = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getConnection")));
    private static final Set<String> METHODS_TO_INTERCEPT = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(PARAMETER_METHODS);
            this.addAll(BATCH_PARAM_METHODS);
            this.addAll(EXEC_METHODS);
            this.addAll(JDBC4_METHODS);
            this.addAll(GET_CONNECTION_METHOD);
            this.add("getDataSourceName");
            this.add("toString");
            this.add("getTarget");
        }
    });
    private static final Set<String> METHODS_TO_OPERATE_PARAMETER = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(PARAMETER_METHODS);
            this.addAll(BATCH_PARAM_METHODS);
        }
    });
    private PreparedStatement ps;
    private String query;
    private String dataSourceName;
    private SortedMap<Integer, Object> queryParams = new TreeMap<Integer, Object>();
    private QueryExecutionListener listener;
    private List<BatchQueryHolder> batchQueries = new ArrayList<BatchQueryHolder>();

    public PreparedStatementInvocationHandler(PreparedStatement ps, String query) {
        this.ps = ps;
        this.query = query;
    }

    public PreparedStatementInvocationHandler(PreparedStatement ps, String query, QueryExecutionListener listener) {
        this.ps = ps;
        this.query = query;
        this.listener = listener;
    }

    public PreparedStatementInvocationHandler(PreparedStatement ps, String query, QueryExecutionListener listener, String dataSourceName) {
        this.ps = ps;
        this.query = query;
        this.listener = listener;
        this.dataSourceName = dataSourceName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder("PreparedStatementInvocationHandler [");
            sb.append(this.ps.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.ps;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.ps.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.ps.isWrapperFor(clazz);
            }
        }
        if (GET_CONNECTION_METHOD.contains(methodName)) {
            Connection conn = (Connection)MethodUtils.proceedExecution(method, this.ps, args);
            return JdbcProxyFactory.createConnection(conn, this.listener, this.dataSourceName);
        }
        if (METHODS_TO_OPERATE_PARAMETER.contains(methodName)) {
            if (PARAMETER_METHODS.contains(methodName)) {
                if ("clearParameters".equals(methodName)) {
                    this.queryParams.clear();
                } else {
                    Integer paramIndex = (Integer)args[0];
                    Object paramValue = args[1];
                    this.queryParams.put(paramIndex, paramValue);
                }
            } else if (BATCH_PARAM_METHODS.contains(methodName)) {
                if ("addBatch".equals(methodName)) {
                    BatchQueryHolder queryHolder = new BatchQueryHolder();
                    queryHolder.setQuery(this.query);
                    queryHolder.setArgs(new ArrayList<Object>(this.queryParams.values()));
                    this.batchQueries.add(queryHolder);
                } else if ("clearBatch".equals(methodName)) {
                    this.batchQueries.clear();
                }
            }
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        if ("executeBatch".equals(methodName)) {
            for (BatchQueryHolder queryHolder : this.batchQueries) {
                queries.add(new QueryInfo(queryHolder.getQuery(), queryHolder.getArgs()));
            }
        } else if ("executeQuery".equals(methodName) || "executeUpdate".equals(methodName) || "execute".equals(methodName)) {
            queries.add(new QueryInfo(this.query, new ArrayList<Object>(this.queryParams.values())));
        }
        this.listener.beforeQuery(new ExecutionInfo(this.dataSourceName, method, args), queries);
        ExecutionInfo execInfo = new ExecutionInfo(this.dataSourceName, method, args);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.ps, args);
            long afterTime = System.currentTimeMillis();
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            throw ex.getTargetException();
        }
        finally {
            this.listener.afterQuery(execInfo, queries);
        }
    }
}

