/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ObjectArrayUtils;

public class StatementInvocationHandler
implements InvocationHandler {
    private static final Set<String> BATCH_PARAM_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("addBatch", "clearBatch")));
    private static final Set<String> EXEC_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("executeBatch", "executeQuery", "executeUpdate", "execute")));
    private static final Set<String> JDBC4_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("unwrap", "isWrapperFor")));
    private static final Set<String> GET_CONNECTION_METHOD = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("getConnection")));
    private static final Set<String> METHODS_TO_INTERCEPT = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(BATCH_PARAM_METHODS);
            this.addAll(EXEC_METHODS);
            this.addAll(JDBC4_METHODS);
            this.addAll(GET_CONNECTION_METHOD);
            this.add("getDataSourceName");
            this.add("toString");
            this.add("getTarget");
        }
    });
    private Statement stmt;
    private QueryExecutionListener listener;
    private String dataSourceName;
    private List<String> batchQueries = new ArrayList<String>();

    public StatementInvocationHandler(Statement stmt) {
        this.stmt = stmt;
    }

    public StatementInvocationHandler(Statement stmt, QueryExecutionListener listener) {
        this.stmt = stmt;
        this.listener = listener;
    }

    public StatementInvocationHandler(Statement stmt, QueryExecutionListener listener, String dataSourceName) {
        this.stmt = stmt;
        this.listener = listener;
        this.dataSourceName = dataSourceName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.stmt, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder("StatementInvocationHandler [");
            sb.append(this.stmt.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.stmt;
        }
        if (JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.stmt.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.stmt.isWrapperFor(clazz);
            }
        }
        if (GET_CONNECTION_METHOD.contains(methodName)) {
            Connection conn = (Connection)MethodUtils.proceedExecution(method, this.stmt, args);
            return JdbcProxyFactory.createConnection(conn, this.listener, this.dataSourceName);
        }
        if ("addBatch".equals(methodName) || "clearBatch".equals(methodName)) {
            if ("addBatch".equals(methodName) && ObjectArrayUtils.isFirstArgString(args)) {
                this.batchQueries.add((String)args[0]);
            } else if ("clearBatch".equals(methodName)) {
                this.batchQueries.clear();
            }
            try {
                return method.invoke((Object)this.stmt, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        if ("executeBatch".equals(methodName)) {
            for (String batchQuery : this.batchQueries) {
                queries.add(new QueryInfo(batchQuery, null));
            }
        } else if (("executeQuery".equals(methodName) || "executeUpdate".equals(methodName) || "execute".equals(methodName)) && ObjectArrayUtils.isFirstArgString(args)) {
            String query = (String)args[0];
            queries.add(new QueryInfo(query, null));
        }
        this.listener.beforeQuery(new ExecutionInfo(this.dataSourceName, method, args), queries);
        ExecutionInfo execInfo = new ExecutionInfo(this.dataSourceName, method, args);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.stmt, args);
            long afterTime = System.currentTimeMillis();
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            throw ex.getTargetException();
        }
        finally {
            this.listener.afterQuery(execInfo, queries);
        }
    }
}

