/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.support.CommonsLogUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsQueryCountLoggingFilter
implements Filter {
    private static final String CLEAR_QUERY_COUNTER_PARAM = "clearQueryCounter";
    private static final String LOG_LEVEL_PARAM = "logLevel";
    private Log log = LogFactory.getLog(CommonsQueryCountLoggingFilter.class);
    private boolean clearQueryCounter = true;
    private CommonsLogLevel logLevel = CommonsLogLevel.DEBUG;

    public void init(FilterConfig filterConfig) throws ServletException {
        String logLevelParam;
        CommonsLogLevel logLevel;
        String clearQueryCounterParam = filterConfig.getInitParameter(CLEAR_QUERY_COUNTER_PARAM);
        if (clearQueryCounterParam != null && "false".equalsIgnoreCase(clearQueryCounterParam)) {
            this.clearQueryCounter = false;
        }
        if ((logLevel = CommonsLogLevel.nullSafeValueOf(logLevelParam = filterConfig.getInitParameter(LOG_LEVEL_PARAM))) != null) {
            this.logLevel = logLevel;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount counter = QueryCountHolder.get(dsName);
            String message = CommonsLogUtils.getCountLogMessage(counter, dsName);
            this.writeLog(message);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    private void writeLog(String message) {
        switch (this.logLevel) {
            case DEBUG: {
                this.log.debug((Object)message);
                break;
            }
            case ERROR: {
                this.log.error((Object)message);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)message);
                break;
            }
            case INFO: {
                this.log.info((Object)message);
                break;
            }
            case TRACE: {
                this.log.trace((Object)message);
                break;
            }
            case WARN: {
                this.log.warn((Object)message);
            }
        }
    }

    public void destroy() {
    }

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogLevel(CommonsLogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

