/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.support.CommonsLogUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CommonsQueryCountLoggingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private Log log = LogFactory.getLog(CommonsQueryCountLoggingHandlerInterceptor.class);
    private boolean clearQueryCounter = true;
    private CommonsLogLevel logLevel = CommonsLogLevel.DEBUG;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount counter = QueryCountHolder.get(dsName);
            String message = CommonsLogUtils.getCountLogMessage(counter, dsName);
            this.writeLog(message);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    private void writeLog(String message) {
        switch (this.logLevel) {
            case DEBUG: {
                this.log.debug((Object)message);
                break;
            }
            case ERROR: {
                this.log.error((Object)message);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)message);
                break;
            }
            case INFO: {
                this.log.info((Object)message);
                break;
            }
            case TRACE: {
                this.log.trace((Object)message);
                break;
            }
            case WARN: {
                this.log.warn((Object)message);
            }
        }
    }

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogLevel(CommonsLogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

