/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.support.CommonsLogUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsQueryCountLoggingRequestListener
implements ServletRequestListener {
    private static final String LOG_LEVEL_PARAM = "queryCountCommonsLogLevel";
    private static final CommonsLogLevel DEFAULT_LOG_LEVEL = CommonsLogLevel.DEBUG;
    private Log log = LogFactory.getLog(CommonsQueryCountLoggingRequestListener.class);

    public void requestInitialized(ServletRequestEvent sre) {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletContext context = sre.getServletContext();
        String logLevelParam = context.getInitParameter(LOG_LEVEL_PARAM);
        CommonsLogLevel logLevel = CommonsLogLevel.nullSafeValueOf(logLevelParam);
        if (logLevel == null) {
            logLevel = DEFAULT_LOG_LEVEL;
        }
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount counter = QueryCountHolder.get(dsName);
            String message = CommonsLogUtils.getCountLogMessage(counter, dsName);
            this.writeLog(logLevel, message);
        }
        QueryCountHolder.clear();
    }

    private void writeLog(CommonsLogLevel logLevel, String message) {
        switch (logLevel) {
            case DEBUG: {
                this.log.debug((Object)message);
                break;
            }
            case ERROR: {
                this.log.error((Object)message);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)message);
                break;
            }
            case INFO: {
                this.log.info((Object)message);
                break;
            }
            case TRACE: {
                this.log.trace((Object)message);
                break;
            }
            case WARN: {
                this.log.warn((Object)message);
            }
        }
    }
}

