/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.SLF4JLogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SLF4JQueryCountLoggingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final String LOG_MESSAGE = "DataSource:{} ElapsedTime:{} Call:{} Query:{} (Select:{} Insert:{} Update:{} Delete:{} Other{})";
    private Logger logger = LoggerFactory.getLogger(SLF4JQueryCountLoggingHandlerInterceptor.class);
    private boolean clearQueryCounter = true;
    private SLF4JLogLevel logLevel = SLF4JLogLevel.DEBUG;

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount counter = QueryCountHolder.get(dsName);
            Object[] args = new Object[]{dsName, counter.getElapsedTime(), counter.getCall(), counter.getTotalNumOfQuery(), counter.getSelect(), counter.getInsert(), counter.getUpdate(), counter.getDelete(), counter.getOther()};
            this.writeLog(args);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    private void writeLog(Object[] argArray) {
        switch (this.logLevel) {
            case DEBUG: {
                this.logger.debug(LOG_MESSAGE, argArray);
                break;
            }
            case ERROR: {
                this.logger.error(LOG_MESSAGE, argArray);
                break;
            }
            case INFO: {
                this.logger.info(LOG_MESSAGE, argArray);
                break;
            }
            case TRACE: {
                this.logger.trace(LOG_MESSAGE, argArray);
                break;
            }
            case WARN: {
                this.logger.warn(LOG_MESSAGE, argArray);
            }
        }
    }

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogLevel(SLF4JLogLevel logLevel) {
        this.logLevel = logLevel;
    }
}

