/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.support.CommonsLogUtils;
import net.ttddyy.dsproxy.support.DefaultQueryCountLogFormatter;
import net.ttddyy.dsproxy.support.QueryCountLogFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CommonsQueryCountLoggingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private Log log = LogFactory.getLog(CommonsQueryCountLoggingHandlerInterceptor.class);
    private boolean clearQueryCounter = true;
    private CommonsLogLevel logLevel = CommonsLogLevel.DEBUG;
    private QueryCountLogFormatter logFormatter = new DefaultQueryCountLogFormatter();

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount count = QueryCountHolder.get(dsName);
            String message = this.logFormatter.getLogMessage(dsName, count);
            CommonsLogUtils.writeLog(this.log, this.logLevel, message);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogLevel(CommonsLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogFormatter(QueryCountLogFormatter logFormatter) {
        this.logFormatter = logFormatter;
    }
}

