/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.support.CommonsLogUtils;
import net.ttddyy.dsproxy.support.DefaultQueryCountLogFormatter;
import net.ttddyy.dsproxy.support.QueryCountLogFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsQueryCountLoggingRequestListener
implements ServletRequestListener {
    private static final String LOG_LEVEL_PARAM = "queryCountCommonsLogLevel";
    private static final CommonsLogLevel DEFAULT_LOG_LEVEL = CommonsLogLevel.DEBUG;
    private Log log = LogFactory.getLog(CommonsQueryCountLoggingRequestListener.class);
    private QueryCountLogFormatter logFormatter = new DefaultQueryCountLogFormatter();

    public void requestInitialized(ServletRequestEvent sre) {
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletContext context = sre.getServletContext();
        String logLevelParam = context.getInitParameter(LOG_LEVEL_PARAM);
        CommonsLogLevel logLevel = CommonsLogLevel.nullSafeValueOf(logLevelParam);
        if (logLevel == null) {
            logLevel = DEFAULT_LOG_LEVEL;
        }
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount count = QueryCountHolder.get(dsName);
            String message = this.logFormatter.getLogMessage(dsName, count);
            CommonsLogUtils.writeLog(this.log, logLevel, message);
        }
        QueryCountHolder.clear();
    }

    public void setLogFormatter(QueryCountLogFormatter logFormatter) {
        this.logFormatter = logFormatter;
    }
}

