/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support.jndi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.support.jndi.JndiProxyDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiProxyDataSourceFactory
implements ObjectFactory {
    private static final String TYPE_PREFIX = JndiProxyDataSourceFactory.class.getSimpleName();
    private static String infoAddressType = TYPE_PREFIX.concat(".parentInfo");
    protected ObjectFactory parentFactory;

    public static Reference createReference(JndiProxyDataSource jndiProxyDataSource) throws NamingException {
        Reference parent = ((Referenceable)((Object)jndiProxyDataSource.getParentDataSource())).getReference();
        Object[] parentInfo = new Object[]{parent, jndiProxyDataSource.getDataSourceName(), jndiProxyDataSource.getListener()};
        return new Reference(JndiProxyDataSource.class.getName(), new BinaryRefAddr(infoAddressType, JndiProxyDataSourceFactory.toByteArray(parentInfo)), JndiProxyDataSourceFactory.class.getName(), null);
    }

    static byte[] toByteArray(Object obj) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ObjectOutputStream oOut = new ObjectOutputStream(bOut);
            oOut.writeObject(obj);
            oOut.close();
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Object fromByteArray(byte[] data) {
        try {
            ObjectInputStream oIn = new ObjectInputStream(new ByteArrayInputStream(data));
            return oIn.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)obj;
        RefAddr parentInfoContent = reference.get(infoAddressType);
        if (parentInfoContent == null) {
            throw new IllegalArgumentException("The given reference is not compatible.");
        }
        Object[] parentInfo = (Object[])JndiProxyDataSourceFactory.fromByteArray((byte[])parentInfoContent.getContent());
        Reference originalReference = (Reference)parentInfo[0];
        String factoryClass = originalReference.getFactoryClassName();
        if (this.parentFactory == null || !this.parentFactory.getClass().getName().equals(factoryClass)) {
            this.parentFactory = (ObjectFactory)Class.forName(factoryClass).newInstance();
        }
        DataSource parentDataSource = (DataSource)this.parentFactory.getObjectInstance(originalReference, name, nameCtx, environment);
        JndiProxyDataSource pds = new JndiProxyDataSource(parentInfo[1].toString(), parentDataSource);
        pds.setListener((QueryExecutionListener)parentInfo[2]);
        return pds;
    }
}

