/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsQueryLoggingListener
implements QueryExecutionListener {
    private boolean writeDataSourceName = true;
    private Log log = LogFactory.getLog(CommonsQueryLoggingListener.class);
    private CommonsLogLevel logLevel = CommonsLogLevel.DEBUG;

    @Override
    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    @Override
    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        StringBuilder sb = new StringBuilder();
        if (this.writeDataSourceName) {
            sb.append("Name:");
            sb.append(execInfo.getDataSourceName());
            sb.append(", ");
        }
        sb.append("Time:");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
        sb.append("Num:");
        sb.append(queryInfoList.size());
        sb.append(", ");
        sb.append("Query:");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("{");
            String query = queryInfo.getQuery();
            List<?> args = queryInfo.getQueryArgs();
            sb.append("[");
            sb.append(query);
            sb.append("][");
            for (Object arg : args) {
                sb.append(arg);
                sb.append(',');
            }
            this.chopIfEndWith(sb, ',');
            sb.append("]");
            sb.append("} ");
        }
        this.writeLog(sb.toString());
    }

    private void chopIfEndWith(StringBuilder sb, char c) {
        int lastCharIndex = sb.length() - 1;
        if (sb.charAt(lastCharIndex) == c) {
            sb.deleteCharAt(lastCharIndex);
        }
    }

    private void writeLog(String message) {
        switch (this.logLevel) {
            case DEBUG: {
                this.log.debug((Object)message);
                break;
            }
            case ERROR: {
                this.log.error((Object)message);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)message);
                break;
            }
            case INFO: {
                this.log.info((Object)message);
                break;
            }
            case TRACE: {
                this.log.trace((Object)message);
                break;
            }
            case WARN: {
                this.log.warn((Object)message);
            }
        }
    }

    public void setLogLevel(CommonsLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setWriteDataSourceName(boolean writeDataSourceName) {
        this.writeDataSourceName = writeDataSourceName;
    }
}

