/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.QueryType;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceQueryCountListener
implements QueryExecutionListener {
    @Override
    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    @Override
    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String dataSourceName = execInfo.getDataSourceName();
        QueryCount count = QueryCountHolder.get(dataSourceName);
        if (count == null) {
            count = new QueryCount();
            QueryCountHolder.put(dataSourceName, count);
        }
        count.incrementCall();
        if (execInfo.getThrowable() != null) {
            count.incrementFailure();
        }
        long elapsedTime = execInfo.getElapsedTime();
        count.incrementElapsedTime(elapsedTime);
        for (QueryInfo queryInfo : queryInfoList) {
            String query = queryInfo.getQuery();
            QueryType type = this.getQueryType(query);
            count.increment(type);
        }
    }

    private QueryType getQueryType(String query) {
        QueryType type;
        String trimmedQuery = this.removeCommentAndWhiteSpace(query);
        char firstChar = trimmedQuery.charAt(0);
        switch (firstChar) {
            case 'S': 
            case 's': {
                type = QueryType.SELECT;
                break;
            }
            case 'I': 
            case 'i': {
                type = QueryType.INSERT;
                break;
            }
            case 'U': 
            case 'u': {
                type = QueryType.UPDATE;
                break;
            }
            case 'D': 
            case 'd': {
                type = QueryType.DELETE;
                break;
            }
            default: {
                type = QueryType.OTHER;
            }
        }
        return type;
    }

    private String removeCommentAndWhiteSpace(String query) {
        return query.replaceAll("--.*\n", "").replaceAll("\n", "").replaceAll("/\\*.*\\*/", "").trim();
    }
}

