/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.BatchQueryHolder;
import net.ttddyy.dsproxy.proxy.InterceptorHolder;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ParameterOperationHolder;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;
import net.ttddyy.dsproxy.proxy.StatementMethodNames;
import net.ttddyy.dsproxy.transform.ParameterReplacer;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStatementProxyLogic {
    private PreparedStatement ps;
    private String query;
    private String dataSourceName;
    private ParameterOperationHolder parameterOperationHolder = new ParameterOperationHolder();
    private InterceptorHolder interceptorHolder;
    private JdbcProxyFactory jdbcProxyFactory = JdbcProxyFactory.DEFAULT;
    private List<BatchQueryHolder> batchQueries = new ArrayList<BatchQueryHolder>();

    public PreparedStatementProxyLogic() {
    }

    public PreparedStatementProxyLogic(PreparedStatement ps, String query, InterceptorHolder interceptorHolder, String dataSourceName, JdbcProxyFactory jdbcProxyFactory) {
        this.ps = ps;
        this.query = query;
        this.interceptorHolder = interceptorHolder;
        this.dataSourceName = dataSourceName;
        this.jdbcProxyFactory = jdbcProxyFactory;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!StatementMethodNames.METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ps.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.ps.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.ps;
        }
        if (StatementMethodNames.JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.ps.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.ps.isWrapperFor(clazz);
            }
        }
        if (StatementMethodNames.GET_CONNECTION_METHOD.contains(methodName)) {
            Connection conn = (Connection)MethodUtils.proceedExecution(method, this.ps, args);
            return this.jdbcProxyFactory.createConnection(conn, this.interceptorHolder, this.dataSourceName);
        }
        if (StatementMethodNames.METHODS_TO_OPERATE_PARAMETER.contains(methodName)) {
            if (StatementMethodNames.PARAMETER_METHODS.contains(methodName)) {
                if ("clearParameters".equals(methodName)) {
                    this.parameterOperationHolder.clear();
                } else if (method.getDeclaringClass() == CallableStatement.class && args[0] instanceof String) {
                    this.parameterOperationHolder.put((String)args[0], method, args);
                } else {
                    this.parameterOperationHolder.put((Integer)args[0], method, args);
                }
            } else if (StatementMethodNames.BATCH_PARAM_METHODS.contains(methodName)) {
                if ("addBatch".equals(methodName)) {
                    this.transformParameters(true, this.batchQueries.size());
                    BatchQueryHolder queryHolder = new BatchQueryHolder();
                    queryHolder.setQuery(this.query);
                    queryHolder.setArgs(this.getQueryParameters(this.parameterOperationHolder));
                    this.batchQueries.add(queryHolder);
                } else if ("clearBatch".equals(methodName)) {
                    this.batchQueries.clear();
                }
            }
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        if ("executeBatch".equals(methodName)) {
            for (BatchQueryHolder queryHolder : this.batchQueries) {
                queries.add(new QueryInfo(queryHolder.getQuery(), queryHolder.getArgs()));
            }
        } else if ("executeQuery".equals(methodName) || "executeUpdate".equals(methodName) || "execute".equals(methodName)) {
            this.transformParameters(false, 0);
            queries.add(new QueryInfo(this.query, this.getQueryParameters(this.parameterOperationHolder)));
        }
        QueryExecutionListener listener = this.interceptorHolder.getListener();
        listener.beforeQuery(new ExecutionInfo(this.dataSourceName, method, args), queries);
        ExecutionInfo execInfo = new ExecutionInfo(this.dataSourceName, method, args);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.ps, args);
            long afterTime = System.currentTimeMillis();
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            throw ex.getTargetException();
        }
        finally {
            listener.afterQuery(execInfo, queries);
        }
    }

    private List<Object> getQueryParameters(ParameterOperationHolder parameterOperationHolder) {
        ArrayList<Object> queryParameters = new ArrayList<Object>(parameterOperationHolder.totalSize());
        ArrayList<ParameterSetOperation> operations = new ArrayList<ParameterSetOperation>(parameterOperationHolder.totalSize());
        operations.addAll(parameterOperationHolder.getParamsByIndex().values());
        operations.addAll(parameterOperationHolder.getParamsByName().values());
        for (ParameterSetOperation parameterSetOperation : operations) {
            queryParameters.add(parameterSetOperation.getArgs()[1]);
        }
        return queryParameters;
    }

    private void transformParameters(boolean isBatch, int count) throws SQLException, IllegalAccessException, InvocationTargetException {
        ParameterReplacer parameterReplacer = new ParameterReplacer(this.parameterOperationHolder);
        TransformInfo transformInfo = new TransformInfo(this.ps.getClass(), this.dataSourceName, this.query, isBatch, count);
        ParameterTransformer parameterTransformer = this.interceptorHolder.getParameterTransformer();
        parameterTransformer.transformParameters(parameterReplacer, transformInfo);
        if (parameterReplacer.isModified()) {
            this.ps.clearParameters();
            ParameterOperationHolder modifiedParameterOperationHolder = parameterReplacer.getModifiedParameters();
            int size = modifiedParameterOperationHolder.totalSize();
            ArrayList<ParameterSetOperation> operations = new ArrayList<ParameterSetOperation>(size);
            operations.addAll(modifiedParameterOperationHolder.getParamsByIndex().values());
            operations.addAll(modifiedParameterOperationHolder.getParamsByName().values());
            for (ParameterSetOperation operation : operations) {
                Method paramMethod = operation.getMethod();
                Object[] paramArgs = operation.getArgs();
                paramMethod.invoke((Object)this.ps, paramArgs);
            }
            this.parameterOperationHolder = modifiedParameterOperationHolder;
        }
    }
}

