/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.SLF4JLogLevel;
import net.ttddyy.dsproxy.support.DefaultQueryCountLogFormatter;
import net.ttddyy.dsproxy.support.QueryCountLogFormatter;
import net.ttddyy.dsproxy.support.SLF4JLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class SLF4JQueryCountLoggingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LoggerFactory.getLogger(SLF4JQueryCountLoggingHandlerInterceptor.class);
    private boolean clearQueryCounter = true;
    private SLF4JLogLevel logLevel = SLF4JLogLevel.DEBUG;
    private QueryCountLogFormatter logFormatter = new DefaultQueryCountLogFormatter();

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        List<String> dsNames = QueryCountHolder.getDataSourceNamesAsList();
        Collections.sort(dsNames);
        for (String dsName : dsNames) {
            QueryCount count = QueryCountHolder.get(dsName);
            String message = this.logFormatter.getLogMessage(dsName, count);
            SLF4JLogUtils.writeLog(this.logger, this.logLevel, message);
        }
        if (this.clearQueryCounter) {
            QueryCountHolder.clear();
        }
    }

    public void setClearQueryCounter(boolean clearQueryCounter) {
        this.clearQueryCounter = clearQueryCounter;
    }

    public void setLogLevel(SLF4JLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogFormatter(QueryCountLogFormatter logFormatter) {
        this.logFormatter = logFormatter;
    }
}

