/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support.jndi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.ChainListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import net.ttddyy.dsproxy.support.jndi.JndiProxyDataSourceFactory;

public class JndiProxyDataSource
extends ProxyDataSource
implements Referenceable,
Serializable {
    private static final long serialVersionUID = 5412567340724273513L;
    private DataSource parentDataSource;
    private QueryExecutionListener listener;

    public JndiProxyDataSource() {
    }

    public JndiProxyDataSource(String name, DataSource parentDataSource) {
        this.parentDataSource = parentDataSource;
        this.setDataSource(parentDataSource);
        this.setDataSourceName(name);
    }

    public QueryExecutionListener getListener() {
        return this.listener;
    }

    public void setListener(QueryExecutionListener listener) {
        this.listener = listener instanceof Serializable ? listener : new SerializableListenerAdapter(listener);
        super.setListener(listener);
    }

    public DataSource getParentDataSource() {
        return this.parentDataSource;
    }

    public Reference getReference() throws NamingException {
        return JndiProxyDataSourceFactory.createReference(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SerializableListenerAdapter
    implements Serializable,
    QueryExecutionListener {
        private static final long serialVersionUID = -5945569344502716192L;
        private String[] listenerClasses;
        private transient QueryExecutionListener listener;

        public SerializableListenerAdapter() {
        }

        public SerializableListenerAdapter(QueryExecutionListener listener) {
            if (listener == null) {
                throw new NullPointerException();
            }
            this.listener = listener;
            if (listener instanceof ChainListener) {
                ChainListener cl = (ChainListener)listener;
                ArrayList<String> classNames = new ArrayList<String>();
                for (QueryExecutionListener executionListener : cl.getListeners()) {
                    classNames.add(executionListener.getClass().getName());
                }
                this.listenerClasses = classNames.toArray(new String[classNames.size()]);
            } else {
                this.listenerClasses = new String[]{listener.getClass().getName()};
            }
        }

        @Override
        public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
            if (this.listener == null) {
                this.createListeners();
            }
            this.listener.beforeQuery(execInfo, queryInfoList);
        }

        @Override
        public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
            if (this.listener == null) {
                this.createListeners();
            }
            this.listener.afterQuery(execInfo, queryInfoList);
        }

        private void createListeners() {
            try {
                if (this.listenerClasses.length == 1) {
                    this.listener = (QueryExecutionListener)Class.forName(this.listenerClasses[0]).newInstance();
                } else {
                    ChainListener cl = new ChainListener();
                    for (String s : this.listenerClasses) {
                        cl.addListener((QueryExecutionListener)Class.forName(s).newInstance());
                    }
                    this.listener = cl;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

