/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;

public class ParameterSetOperation {
    private static final Map<Integer, String> SQL_TYPE_NAME_BY_CODE = new HashMap<Integer, String>();
    private Method method;
    private Object[] args;

    public ParameterSetOperation() {
    }

    public ParameterSetOperation(Method method, Object[] args) {
        this.method = method;
        this.args = args;
    }

    public String getParameterNameOrIndexAsString() {
        Object key = this.args[0];
        return key instanceof String ? (String)key : key.toString();
    }

    public Object getParameterValue() {
        Object value = this.args[1];
        String methodName = this.method.getName();
        if ("setNull".equals(methodName)) {
            Integer sqlType = (Integer)value;
            String sqlTypeName = SQL_TYPE_NAME_BY_CODE.get(sqlType);
            value = sqlTypeName != null ? "NULL(" + sqlTypeName + ")" : "NULL";
        } else if ("registerOutParameter".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append("OUTPUT(");
            if (value instanceof Integer) {
                Integer sqlType = (Integer)value;
                String sqlTypeName = SQL_TYPE_NAME_BY_CODE.get(sqlType);
                sb.append(sqlTypeName != null ? sqlTypeName : sqlType);
            } else {
                sb.append(value);
            }
            sb.append(")");
            value = sb.toString();
        }
        return value;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    static {
        try {
            Class<Types> clazz = Types.class;
            for (Field field : clazz.getFields()) {
                String name = field.getName();
                int code = field.getInt(clazz);
                SQL_TYPE_NAME_BY_CODE.put(code, name.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

