/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.InterceptorHolder;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.MethodUtils;
import net.ttddyy.dsproxy.proxy.ParameterSetOperation;
import net.ttddyy.dsproxy.proxy.StatementMethodNames;
import net.ttddyy.dsproxy.transform.ParameterReplacer;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.TransformInfo;

public class PreparedStatementProxyLogic {
    private PreparedStatement ps;
    private String query;
    private String dataSourceName;
    private Map<Object, ParameterSetOperation> parameters = new LinkedHashMap<Object, ParameterSetOperation>();
    private InterceptorHolder interceptorHolder;
    private JdbcProxyFactory jdbcProxyFactory = JdbcProxyFactory.DEFAULT;
    private List<Map<Object, ParameterSetOperation>> batchParameters = new ArrayList<Map<Object, ParameterSetOperation>>();

    public PreparedStatementProxyLogic() {
    }

    public PreparedStatementProxyLogic(PreparedStatement ps, String query, InterceptorHolder interceptorHolder, String dataSourceName, JdbcProxyFactory jdbcProxyFactory) {
        this.ps = ps;
        this.query = query;
        this.interceptorHolder = interceptorHolder;
        this.dataSourceName = dataSourceName;
        this.jdbcProxyFactory = jdbcProxyFactory;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (!StatementMethodNames.METHODS_TO_INTERCEPT.contains(methodName)) {
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        if ("toString".equals(methodName)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.ps.getClass().getSimpleName());
            sb.append(" [");
            sb.append(this.ps.toString());
            sb.append("]");
            return sb.toString();
        }
        if ("getDataSourceName".equals(methodName)) {
            return this.dataSourceName;
        }
        if ("getTarget".equals(methodName)) {
            return this.ps;
        }
        if (StatementMethodNames.JDBC4_METHODS.contains(methodName)) {
            Class clazz = (Class)args[0];
            if ("unwrap".equals(methodName)) {
                return this.ps.unwrap(clazz);
            }
            if ("isWrapperFor".equals(methodName)) {
                return this.ps.isWrapperFor(clazz);
            }
        }
        if (StatementMethodNames.GET_CONNECTION_METHOD.contains(methodName)) {
            Connection conn = (Connection)MethodUtils.proceedExecution(method, this.ps, args);
            return this.jdbcProxyFactory.createConnection(conn, this.interceptorHolder, this.dataSourceName);
        }
        if (StatementMethodNames.METHODS_TO_OPERATE_PARAMETER.contains(methodName)) {
            if (StatementMethodNames.PARAMETER_METHODS.contains(methodName)) {
                if ("clearParameters".equals(methodName)) {
                    this.parameters.clear();
                } else {
                    this.parameters.put(args[0], new ParameterSetOperation(method, args));
                }
            } else if (StatementMethodNames.BATCH_PARAM_METHODS.contains(methodName)) {
                if ("addBatch".equals(methodName)) {
                    this.transformParameters(true, this.batchParameters.size());
                    LinkedHashMap<Object, ParameterSetOperation> newParams = new LinkedHashMap<Object, ParameterSetOperation>(this.parameters);
                    this.batchParameters.add(newParams);
                    this.parameters.clear();
                } else if ("clearBatch".equals(methodName)) {
                    this.batchParameters.clear();
                }
            }
            return MethodUtils.proceedExecution(method, this.ps, args);
        }
        ArrayList<QueryInfo> queries = new ArrayList<QueryInfo>();
        boolean isBatchExecution = false;
        int batchSize = 0;
        if (StatementMethodNames.BATCH_EXEC_METHODS.contains(methodName)) {
            QueryInfo queryInfo = new QueryInfo(this.query);
            for (Map<Object, ParameterSetOperation> params : this.batchParameters) {
                queryInfo.getQueryArgsList().add(this.getQueryParameters(params));
            }
            queries.add(queryInfo);
            batchSize = this.batchParameters.size();
            this.batchParameters.clear();
            isBatchExecution = true;
        } else if (StatementMethodNames.QUERY_EXEC_METHODS.contains(methodName)) {
            this.transformParameters(false, 0);
            queries.add(new QueryInfo(this.query, this.getQueryParameters(this.parameters)));
        }
        QueryExecutionListener listener = this.interceptorHolder.getListener();
        listener.beforeQuery(new ExecutionInfo(this.dataSourceName, this.ps, isBatchExecution, batchSize, method, args), queries);
        ExecutionInfo execInfo = new ExecutionInfo(this.dataSourceName, this.ps, isBatchExecution, batchSize, method, args);
        try {
            long beforeTime = System.currentTimeMillis();
            Object retVal = method.invoke((Object)this.ps, args);
            long afterTime = System.currentTimeMillis();
            execInfo.setResult(retVal);
            execInfo.setElapsedTime(afterTime - beforeTime);
            execInfo.setSuccess(true);
            Object object = retVal;
            return object;
        }
        catch (InvocationTargetException ex) {
            execInfo.setThrowable(ex.getTargetException());
            execInfo.setSuccess(false);
            throw ex.getTargetException();
        }
        finally {
            listener.afterQuery(execInfo, queries);
        }
    }

    private Map<String, Object> getQueryParameters(Map<Object, ParameterSetOperation> params) {
        LinkedHashMap<String, Object> queryParameters = new LinkedHashMap<String, Object>(params.size());
        for (ParameterSetOperation parameterSetOperation : params.values()) {
            String key = parameterSetOperation.getParameterNameOrIndexAsString();
            Object value = parameterSetOperation.getParameterValue();
            queryParameters.put(key, value);
        }
        return queryParameters;
    }

    private void transformParameters(boolean isBatch, int count) throws SQLException, IllegalAccessException, InvocationTargetException {
        ParameterReplacer parameterReplacer = new ParameterReplacer(this.parameters);
        TransformInfo transformInfo = new TransformInfo(this.ps.getClass(), this.dataSourceName, this.query, isBatch, count);
        ParameterTransformer parameterTransformer = this.interceptorHolder.getParameterTransformer();
        parameterTransformer.transformParameters(parameterReplacer, transformInfo);
        if (parameterReplacer.isModified()) {
            this.ps.clearParameters();
            Map<Object, ParameterSetOperation> modifiedParameters = parameterReplacer.getModifiedParameters();
            for (ParameterSetOperation operation : modifiedParameters.values()) {
                Method paramMethod = operation.getMethod();
                Object[] paramArgs = operation.getArgs();
                paramMethod.invoke((Object)this.ps, paramArgs);
            }
            this.parameters = modifiedParameters;
        }
    }
}

