/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.listener.SLF4JLogLevel;
import net.ttddyy.dsproxy.support.CommonsQueryCountLoggingHandlerInterceptor;
import net.ttddyy.dsproxy.support.CommonsQueryCountLoggingServletFilter;
import net.ttddyy.dsproxy.support.SLF4JQueryCountLoggingHandlerInterceptor;
import net.ttddyy.dsproxy.support.SLF4JQueryCountLoggingServletFilter;
import net.ttddyy.dsproxy.support.SystemOutQueryCountLoggingHandlerInterceptor;
import net.ttddyy.dsproxy.support.SystemOutQueryCountLoggingServletFilter;

public class QueryCountLoggerBuilder {
    private boolean writeAsJson = false;
    private CommonsLogLevel commonsLogLevel = CommonsLogLevel.DEBUG;
    private SLF4JLogLevel slf4jLogLevel = SLF4JLogLevel.DEBUG;

    public static QueryCountLoggerBuilder create() {
        return new QueryCountLoggerBuilder();
    }

    public QueryCountLoggerBuilder logLevel(CommonsLogLevel commonsLogLevel) {
        this.commonsLogLevel = commonsLogLevel;
        return this;
    }

    public QueryCountLoggerBuilder logLevel(SLF4JLogLevel slf4jLogLevel) {
        this.slf4jLogLevel = slf4jLogLevel;
        return this;
    }

    public QueryCountLoggerBuilder asJson() {
        this.writeAsJson = true;
        return this;
    }

    public CommonsQueryCountLoggingServletFilter buildCommonsFilter() {
        return this.buildCommonsFilter(null);
    }

    public CommonsQueryCountLoggingServletFilter buildCommonsFilter(CommonsLogLevel logLevel) {
        if (logLevel != null) {
            this.commonsLogLevel = logLevel;
        }
        CommonsQueryCountLoggingServletFilter filter = new CommonsQueryCountLoggingServletFilter();
        if (this.commonsLogLevel != null) {
            filter.setLogLevel(this.commonsLogLevel);
        }
        filter.setWriteAsJson(this.writeAsJson);
        return filter;
    }

    public CommonsQueryCountLoggingHandlerInterceptor buildCommonsHandlerInterceptor() {
        return this.buildCommonsHandlerInterceptor(null);
    }

    public CommonsQueryCountLoggingHandlerInterceptor buildCommonsHandlerInterceptor(CommonsLogLevel logLevel) {
        if (logLevel != null) {
            this.commonsLogLevel = logLevel;
        }
        CommonsQueryCountLoggingHandlerInterceptor handlerInterceptor = new CommonsQueryCountLoggingHandlerInterceptor();
        if (this.commonsLogLevel != null) {
            handlerInterceptor.setLogLevel(this.commonsLogLevel);
        }
        handlerInterceptor.setWriteAsJson(this.writeAsJson);
        return handlerInterceptor;
    }

    public SLF4JQueryCountLoggingServletFilter buildSlf4jFilter() {
        return this.buildSlf4jFilter(null);
    }

    public SLF4JQueryCountLoggingServletFilter buildSlf4jFilter(SLF4JLogLevel logLevel) {
        if (logLevel != null) {
            this.slf4jLogLevel = logLevel;
        }
        SLF4JQueryCountLoggingServletFilter filter = new SLF4JQueryCountLoggingServletFilter();
        if (this.slf4jLogLevel != null) {
            filter.setLogLevel(this.slf4jLogLevel);
        }
        filter.setWriteAsJson(this.writeAsJson);
        return filter;
    }

    public SLF4JQueryCountLoggingHandlerInterceptor buildSlf4jHandlerInterceptor() {
        return this.buildSlf4jHandlerInterceptor(null);
    }

    public SLF4JQueryCountLoggingHandlerInterceptor buildSlf4jHandlerInterceptor(SLF4JLogLevel logLevel) {
        if (logLevel != null) {
            this.slf4jLogLevel = logLevel;
        }
        SLF4JQueryCountLoggingHandlerInterceptor handlerInterceptor = new SLF4JQueryCountLoggingHandlerInterceptor();
        if (this.slf4jLogLevel != null) {
            handlerInterceptor.setLogLevel(this.slf4jLogLevel);
        }
        handlerInterceptor.setWriteAsJson(this.writeAsJson);
        return handlerInterceptor;
    }

    public SystemOutQueryCountLoggingServletFilter buildSysOutFilter() {
        SystemOutQueryCountLoggingServletFilter filter = new SystemOutQueryCountLoggingServletFilter();
        filter.setWriteAsJson(this.writeAsJson);
        return filter;
    }

    public SystemOutQueryCountLoggingHandlerInterceptor buildSysOutHandlerInterceptor() {
        SystemOutQueryCountLoggingHandlerInterceptor handlerInterceptor = new SystemOutQueryCountLoggingHandlerInterceptor();
        handlerInterceptor.setWriteAsJson(this.writeAsJson);
        return handlerInterceptor;
    }
}

