/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support.jndi;

import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.CommonsLogLevel;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.SLF4JLogLevel;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;

public class ProxyDataSourceObjectFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object transformer;
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)obj;
        String dataSourceJndiName = this.getContentFromReference(reference, "dataSource");
        String proxyDataSourceName = this.getContentFromReference(reference, "proxyName");
        String listenerNames = this.getContentFromReference(reference, "listeners");
        String logLevel = this.getContentFromReference(reference, "logLevel");
        String loggerName = this.getContentFromReference(reference, "loggerName");
        String foramt = this.getContentFromReference(reference, "format");
        String queryTransformer = this.getContentFromReference(reference, "queryTransformer");
        String parameterTransformer = this.getContentFromReference(reference, "parameterTransformer");
        Object dataSourceResource = new InitialContext().lookup(dataSourceJndiName);
        if (dataSourceResource == null) {
            throw new Exception(String.format("%s is not available.", dataSourceJndiName));
        }
        if (!(dataSourceResource instanceof DataSource)) {
            throw new Exception(String.format("%s is not DataSource: %s", dataSourceJndiName, dataSourceResource));
        }
        DataSource dataSource = (DataSource)dataSourceResource;
        ProxyDataSourceBuilder builder = ProxyDataSourceBuilder.create(dataSource);
        if (proxyDataSourceName != null) {
            builder.name(proxyDataSourceName);
        }
        if (listenerNames != null) {
            for (String listenerName : this.getListenerNames(listenerNames)) {
                if ("commons".equalsIgnoreCase(listenerName)) {
                    boolean hasLoggerName;
                    boolean hasLogLevel = logLevel != null;
                    boolean bl = hasLoggerName = loggerName != null;
                    if (hasLogLevel && hasLoggerName) {
                        builder.logQueryByCommons(CommonsLogLevel.valueOf(logLevel.toUpperCase()), loggerName);
                        continue;
                    }
                    if (hasLogLevel) {
                        builder.logQueryByCommons(CommonsLogLevel.valueOf(logLevel.toUpperCase()));
                        continue;
                    }
                    if (hasLoggerName) {
                        builder.logQueryByCommons(loggerName);
                        continue;
                    }
                    builder.logQueryByCommons();
                    continue;
                }
                if ("slf4j".equalsIgnoreCase(listenerName)) {
                    boolean hasLogName;
                    boolean hasLogLevel = logLevel != null;
                    boolean bl = hasLogName = loggerName != null;
                    if (hasLogLevel && hasLogName) {
                        builder.logQueryBySlf4j(SLF4JLogLevel.valueOf(logLevel.toUpperCase()), loggerName);
                        continue;
                    }
                    if (hasLogLevel) {
                        builder.logQueryBySlf4j(SLF4JLogLevel.valueOf(logLevel.toUpperCase()));
                        continue;
                    }
                    if (hasLogName) {
                        builder.logQueryBySlf4j(loggerName);
                        continue;
                    }
                    builder.logQueryBySlf4j();
                    continue;
                }
                if ("sysout".equalsIgnoreCase(listenerName)) {
                    builder.logQueryToSysOut();
                    continue;
                }
                if ("count".equalsIgnoreCase(listenerName)) {
                    builder.countQuery();
                    continue;
                }
                QueryExecutionListener listener = this.createNewInstance(QueryExecutionListener.class, listenerName);
                builder.listener(listener);
            }
            if (foramt != null && "json".equals(foramt.toLowerCase())) {
                builder.asJson();
            }
        }
        if (queryTransformer != null) {
            transformer = this.createNewInstance(QueryTransformer.class, queryTransformer);
            builder.queryTransformer((QueryTransformer)transformer);
        }
        if (parameterTransformer != null) {
            transformer = this.createNewInstance(ParameterTransformer.class, parameterTransformer);
            builder.parameterTransformer((ParameterTransformer)transformer);
        }
        return builder.build();
    }

    protected <T> T createNewInstance(Class<T> clazz, String className) throws Exception {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String msg = String.format("Failed to create %s - %s: %s", clazz.getSimpleName(), e.getClass().getName(), e.getMessage());
            throw new Exception(msg);
        }
    }

    protected String getContentFromReference(Reference reference, String key) {
        RefAddr refAddr = reference.get(key);
        if (refAddr == null) {
            return null;
        }
        return refAddr.getContent().toString();
    }

    protected String[] getListenerNames(String listenerNames) {
        HashSet<String> listenerNameSet = new HashSet<String>();
        for (String listenerName : listenerNames.split(",")) {
            listenerNameSet.add(this.trim(listenerName));
        }
        return listenerNameSet.toArray(new String[listenerNameSet.size()]);
    }

    protected String trim(String s) {
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

