/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.listener.QueryLogEntryCreator;

public class DefaultQueryLogEntryCreator
implements QueryLogEntryCreator {
    protected static final Map<Character, String> JSON_SPECIAL_CHARS = new HashMap<Character, String>();

    @Override
    public String getLogEntry(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName) {
        StringBuilder sb = new StringBuilder();
        if (writeDataSourceName) {
            this.writeDataSourceNameEntry(sb, execInfo, queryInfoList);
        }
        this.writeTimeEntry(sb, execInfo, queryInfoList);
        this.writeResultEntry(sb, execInfo, queryInfoList);
        this.writeTypeEntry(sb, execInfo, queryInfoList);
        this.writeBatchEntry(sb, execInfo, queryInfoList);
        this.writeQuerySizeEntry(sb, execInfo, queryInfoList);
        this.writeBatchSizeEntry(sb, execInfo, queryInfoList);
        this.writeQueriesEntry(sb, execInfo, queryInfoList);
        this.writeParamsEntry(sb, execInfo, queryInfoList);
        return sb.toString();
    }

    protected void writeDataSourceNameEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String name = execInfo.getDataSourceName();
        sb.append("Name:");
        sb.append(name == null ? "" : name);
        sb.append(", ");
    }

    protected void writeTimeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Time:");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
    }

    protected void writeResultEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Success:");
        sb.append(execInfo.isSuccess() ? "True" : "False");
        sb.append(", ");
    }

    protected void writeTypeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Type:");
        sb.append(this.getStatementType(execInfo.getStatementType()));
        sb.append(", ");
    }

    protected void writeBatchEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Batch:");
        sb.append(execInfo.isBatch() ? "True" : "False");
        sb.append(", ");
    }

    protected void writeQuerySizeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("QuerySize:");
        sb.append(queryInfoList.size());
        sb.append(", ");
    }

    protected void writeBatchSizeEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("BatchSize:");
        sb.append(execInfo.getBatchSize());
        sb.append(", ");
    }

    protected void writeQueriesEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Query:[");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("\"");
            sb.append(queryInfo.getQuery());
            sb.append("\",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("], ");
    }

    protected void writeParamsEntry(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("Params:[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (Map<String, Object> paramMap : queryInfo.getQueryArgsList()) {
                this.writeParamsForSingleEntry(sb, paramMap, execInfo, queryInfoList);
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
    }

    protected void writeParamsForSingleEntry(StringBuilder sb, Map<String, Object> paramMap, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        TreeMap<String, Object> sortedParamMap = new TreeMap<String, Object>(new StringAsIntegerComparator());
        sortedParamMap.putAll(paramMap);
        sb.append("(");
        for (Map.Entry paramEntry : sortedParamMap.entrySet()) {
            sb.append((String)paramEntry.getKey());
            sb.append("=");
            sb.append(paramEntry.getValue());
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("),");
    }

    @Override
    public String getLogEntryAsJson(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (writeDataSourceName) {
            this.writeDataSourceNameEntryForJson(sb, execInfo, queryInfoList);
        }
        this.writeTimeEntryForJson(sb, execInfo, queryInfoList);
        this.writeResultEntryForJson(sb, execInfo, queryInfoList);
        this.writeTypeEntryForJson(sb, execInfo, queryInfoList);
        this.writeBatchEntryForJson(sb, execInfo, queryInfoList);
        this.writeQuerySizeEntryForJson(sb, execInfo, queryInfoList);
        this.writeBatchSizeEntryForJson(sb, execInfo, queryInfoList);
        this.writeQueriesEntryForJson(sb, execInfo, queryInfoList);
        this.writeParamsEntryForJson(sb, execInfo, queryInfoList);
        return sb.toString();
    }

    protected void writeDataSourceNameEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        String name = execInfo.getDataSourceName();
        sb.append("\"name\":\"");
        sb.append(name == null ? "" : this.escapeSpecialCharacterForJson(name));
        sb.append("\", ");
    }

    protected void writeTimeEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"time\":");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
    }

    protected void writeResultEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"success\":");
        sb.append(execInfo.isSuccess() ? "true" : "false");
        sb.append(", ");
    }

    protected void writeTypeEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"type\":\"");
        sb.append(this.getStatementType(execInfo.getStatementType()));
        sb.append("\", ");
    }

    protected void writeBatchEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"batch\":");
        sb.append(execInfo.isBatch() ? "true" : "false");
        sb.append(", ");
    }

    protected void writeQuerySizeEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"querySize\":");
        sb.append(queryInfoList.size());
        sb.append(", ");
    }

    protected void writeBatchSizeEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"batchSize\":");
        sb.append(execInfo.getBatchSize());
        sb.append(", ");
    }

    protected void writeQueriesEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"query\":[");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("\"");
            sb.append(this.escapeSpecialCharacterForJson(queryInfo.getQuery()));
            sb.append("\",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("], ");
    }

    protected void writeParamsEntryForJson(StringBuilder sb, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        sb.append("\"params\":[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (Map<String, Object> paramMap : queryInfo.getQueryArgsList()) {
                this.writeParamsForSingleEntryForJson(sb, paramMap, execInfo, queryInfoList);
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
        sb.append("}");
    }

    protected void writeParamsForSingleEntryForJson(StringBuilder sb, Map<String, Object> paramMap, ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        TreeMap<String, Object> sortedParamMap = new TreeMap<String, Object>(new StringAsIntegerComparator());
        sortedParamMap.putAll(paramMap);
        sb.append("{");
        for (Map.Entry paramEntry : sortedParamMap.entrySet()) {
            String key = (String)paramEntry.getKey();
            Object value = paramEntry.getValue();
            sb.append("\"");
            sb.append(this.escapeSpecialCharacterForJson(key));
            sb.append("\":");
            if (value == null) {
                sb.append("null");
            } else {
                sb.append("\"");
                sb.append(this.escapeSpecialCharacterForJson(value.toString()));
                sb.append("\"");
            }
            sb.append(",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("},");
    }

    protected String getStatementType(StatementType statementType) {
        if (StatementType.STATEMENT.equals((Object)statementType)) {
            return "Statement";
        }
        if (StatementType.PREPARED.equals((Object)statementType)) {
            return "Prepared";
        }
        if (StatementType.CALLABLE.equals((Object)statementType)) {
            return "Callable";
        }
        return "Unknown";
    }

    protected void chompIfEndWith(StringBuilder sb, char c) {
        int lastCharIndex = sb.length() - 1;
        if (sb.charAt(lastCharIndex) == c) {
            sb.deleteCharAt(lastCharIndex);
        }
    }

    protected String escapeSpecialCharacterForJson(String input) {
        if (input == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String value = JSON_SPECIAL_CHARS.get(Character.valueOf(c));
            sb.append(value != null ? value : Character.valueOf(c));
        }
        return sb.toString();
    }

    static {
        JSON_SPECIAL_CHARS.put(Character.valueOf('\"'), "\\\"");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\\'), "\\\\");
        JSON_SPECIAL_CHARS.put(Character.valueOf('/'), "\\/");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\b'), "\\b");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\f'), "\\f");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\n'), "\\n");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\r'), "\\r");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\t'), "\\t");
    }

    public static class StringAsIntegerComparator
    implements Comparator<String> {
        @Override
        public int compare(String left, String right) {
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            try {
                return Integer.compare(Integer.parseInt(left), Integer.parseInt(right));
            }
            catch (NumberFormatException e) {
                return left.compareTo(right);
            }
        }
    }
}

