/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.StatementType;
import net.ttddyy.dsproxy.listener.QueryLogEntryCreator;

public class DefaultQueryLogEntryCreator
implements QueryLogEntryCreator {
    protected static final Map<Character, String> JSON_SPECIAL_CHARS = new HashMap<Character, String>();

    @Override
    public String getLogEntry(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName) {
        StringBuilder sb = new StringBuilder();
        if (writeDataSourceName) {
            String name = execInfo.getDataSourceName();
            sb.append("Name:");
            sb.append(name == null ? "" : name);
            sb.append(", ");
        }
        sb.append("Time:");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
        sb.append("Success:");
        sb.append(execInfo.isSuccess() ? "True" : "False");
        sb.append(", ");
        sb.append("Type:");
        sb.append(this.getStatementType(execInfo.getStatementType()));
        sb.append(", ");
        sb.append("Batch:");
        sb.append(execInfo.isBatch() ? "True" : "False");
        sb.append(", ");
        sb.append("QuerySize:");
        sb.append(queryInfoList.size());
        sb.append(", ");
        sb.append("BatchSize:");
        sb.append(execInfo.getBatchSize());
        sb.append(", ");
        sb.append("Query:[");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("\"");
            sb.append(queryInfo.getQuery());
            sb.append("\",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("], ");
        sb.append("Params:[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (Map<String, Object> paramMap : queryInfo.getQueryArgsList()) {
                TreeMap<String, Object> sortedParamMap = new TreeMap<String, Object>(new StringAsIntegerComparator());
                sortedParamMap.putAll(paramMap);
                sb.append("(");
                for (Map.Entry paramEntry : sortedParamMap.entrySet()) {
                    sb.append((String)paramEntry.getKey());
                    sb.append("=");
                    sb.append(paramEntry.getValue());
                    sb.append(",");
                }
                this.chompIfEndWith(sb, ',');
                sb.append("),");
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getLogEntryAsJson(ExecutionInfo execInfo, List<QueryInfo> queryInfoList, boolean writeDataSourceName) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (writeDataSourceName) {
            String name = execInfo.getDataSourceName();
            sb.append("\"name\":\"");
            sb.append(name == null ? "" : this.escapeSpecialCharacterForJson(name));
            sb.append("\", ");
        }
        sb.append("\"time\":");
        sb.append(execInfo.getElapsedTime());
        sb.append(", ");
        sb.append("\"success\":");
        sb.append(execInfo.isSuccess() ? "true" : "false");
        sb.append(", ");
        sb.append("\"type\":\"");
        sb.append(this.getStatementType(execInfo.getStatementType()));
        sb.append("\", ");
        sb.append("\"batch\":");
        sb.append(execInfo.isBatch() ? "true" : "false");
        sb.append(", ");
        sb.append("\"querySize\":");
        sb.append(queryInfoList.size());
        sb.append(", ");
        sb.append("\"batchSize\":");
        sb.append(execInfo.getBatchSize());
        sb.append(", ");
        sb.append("\"query\":[");
        for (QueryInfo queryInfo : queryInfoList) {
            sb.append("\"");
            sb.append(this.escapeSpecialCharacterForJson(queryInfo.getQuery()));
            sb.append("\",");
        }
        this.chompIfEndWith(sb, ',');
        sb.append("], ");
        sb.append("\"params\":[");
        for (QueryInfo queryInfo : queryInfoList) {
            for (Map<String, Object> paramMap : queryInfo.getQueryArgsList()) {
                TreeMap<String, Object> sortedParamMap = new TreeMap<String, Object>(new StringAsIntegerComparator());
                sortedParamMap.putAll(paramMap);
                sb.append("{");
                for (Map.Entry paramEntry : sortedParamMap.entrySet()) {
                    String key = (String)paramEntry.getKey();
                    Object value = paramEntry.getValue();
                    sb.append("\"");
                    sb.append(this.escapeSpecialCharacterForJson(key));
                    sb.append("\":");
                    if (value == null) {
                        sb.append("null");
                    } else {
                        sb.append("\"");
                        sb.append(this.escapeSpecialCharacterForJson(value.toString()));
                        sb.append("\"");
                    }
                    sb.append(",");
                }
                this.chompIfEndWith(sb, ',');
                sb.append("},");
            }
        }
        this.chompIfEndWith(sb, ',');
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    protected String getStatementType(StatementType statementType) {
        if (StatementType.STATEMENT.equals((Object)statementType)) {
            return "Statement";
        }
        if (StatementType.PREPARED.equals((Object)statementType)) {
            return "Prepared";
        }
        if (StatementType.CALLABLE.equals((Object)statementType)) {
            return "Callable";
        }
        return "Unknown";
    }

    protected void chompIfEndWith(StringBuilder sb, char c) {
        int lastCharIndex = sb.length() - 1;
        if (sb.charAt(lastCharIndex) == c) {
            sb.deleteCharAt(lastCharIndex);
        }
    }

    protected String escapeSpecialCharacterForJson(String input) {
        if (input == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String value = JSON_SPECIAL_CHARS.get(Character.valueOf(c));
            sb.append(value != null ? value : Character.valueOf(c));
        }
        return sb.toString();
    }

    static {
        JSON_SPECIAL_CHARS.put(Character.valueOf('\"'), "\\\"");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\\'), "\\\\");
        JSON_SPECIAL_CHARS.put(Character.valueOf('/'), "\\/");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\b'), "\\b");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\f'), "\\f");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\n'), "\\n");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\r'), "\\r");
        JSON_SPECIAL_CHARS.put(Character.valueOf('\t'), "\\t");
    }

    private static class StringAsIntegerComparator
    implements Comparator<String> {
        private StringAsIntegerComparator() {
        }

        @Override
        public int compare(String left, String right) {
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            try {
                return Integer.compare(Integer.parseInt(left), Integer.parseInt(right));
            }
            catch (NumberFormatException e) {
                return left.compareTo(right);
            }
        }
    }
}

